/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: string_length.cpp,v 1.3 2003/10/02 02:56:37 chris Exp $ */

#include <math.h>

#include <anomaly.h>


StringLengthModel::StringLengthModel()
{
  _element_count = 0;
}

StringLengthModel::~StringLengthModel()
{
}

 
void StringLengthModel::insert_item(Item *_item) throw (ModelInputException)
{
  NumericalItem *item;
  map<int, unsigned long>::iterator iter;

  item = dynamic_cast<NumericalItem *>(_item);
  if (item == 0) 
    throw ModelInputException("NumericalItem required for StringLengthModel::insert_item");
  
  iter = _elements.find(item->value());
  if (iter != _elements.end())
    iter->second++;
  else 
    _elements[item->value()] = 1;

  ++_element_count;
}

void StringLengthModel::switch_mode(ModelMode mode) throw (ModelException)
{
  map<int, unsigned long>::iterator iter;
  unsigned long N;
  double sum = 0.0;

  if ((_mode == Training) && (mode == Detection)) {

    if ((N = _element_count) < 1) 
      throw ModelException("StringLengthModel::switch_mode needs at least a single data point");
    
    /* calculate the mean */
    for (iter = _elements.begin(); iter != _elements.end(); ++iter) 
      sum += (double) (iter->first * iter->second);

    _mean =  sum / (double) N;

    /* calculate the standard deviation */
    if (N > 1) {
      sum = 0.0;
      for (iter = _elements.begin(); iter != _elements.end(); ++iter)
	sum += (double) iter->second * ((double) iter->first - _mean) * ((double)iter->first - _mean);
      _sigma = sqrt(sum / (double) (N - 1));
    }
    else
      _sigma = 0;

    // cout << "StrLen: sigma = " << _sigma << " mean = " << _mean << " and elements = " << N << endl; 

    _mode = mode;
  }
  else
    throw ModelException("Histogram::switch_mode performs illegal mode transition");
}


double StringLengthModel::check_item(Item *_item) throw (ModelInputException)
{
  NumericalItem *item;
  double result;

  item = dynamic_cast<NumericalItem *>(_item);
  if (item == 0) 
    throw ModelInputException("NumericalItem required for StringLengthModel::check_item");

  if ((double) item->value() <  _mean)
    return 1.0;

  double enumerator = _sigma * _sigma;
  double denominator = ((double) item->value() - _mean) *  ((double) item->value() - _mean);
  
  if (denominator == 0.0)
    result = 1.0;
  else
    result = (enumerator / denominator);

  if (result > 1.0)
    result = 1.0;

  // cout << "StringLength of " << item->value() << " yields " << result << " with " << _mean << " and " << _sigma << endl;
  return result;
}


Model* StringLengthModelFactory::instance(void)
{ 
  StringLengthModel *strlen = new StringLengthModel();
  return strlen;
}
