/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: string_item.cpp,v 1.5 2003/02/28 22:00:59 chris Exp $ */

#include <anomaly.h>

StringItem::StringItem()
{
  _s = "";
}

StringItem::StringItem(string s)
{
  _s = s;
}

StringItem::~StringItem()
{
}

bool StringItem::operator==(const Item &right) const 
{
  const StringItem *sright = dynamic_cast<const StringItem *>(&right);

  if ((sright != 0) && (_s == sright->_s))
    return true;
  else
    return false;
}

size_t StringItem::hash_value() const
{
  size_t res = 0;
  size_t len = _s.length();

  for (int i = 0; i < len; ++i)
    res = (res << 1)^_s[i];

  return res;
}


void StringItem::to_string(ostream &out) const 
{
  out << "StringItem(" << _s << ")";
}

string StringItem::getValue()
{
  return _s;
}
