#ifndef PROFILE_INT_H__
#define PROFILE_INT_H__

/* Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: profile_int.h,v 1.11 2004/10/20 00:35:41 dhm Exp $ */
 
/* convenience classes and typedefs for profile 
 * moved here from anomaly.h - chris 
 */

typedef ListCollection FeatureVector;



/* confidence is moved into the models themselves 
 * all confidence related classes and methods are removed - chris
 */

//class ModelConfidence {};
//
// class ModelConfidenceCollection : public list<ModelConfidence *> {
//  public:
//   virtual ~ModelConfidenceCollection() { }
// };

// class ModelConfidenceCollections : public list<ModelConfidenceCollection *> {
//  public:
//   virtual ~ModelConfidenceCollections() { }
// };

class ModelFeatureMapping : public Item {
 private:
  Model                         *_model;
  ListCollection                *_features;

 public:
  ModelFeatureMapping(Model *m, ListCollection *features);
  ListCollection *getFeatures(void);
  Model *getModel(void);
  virtual size_t hash_value(void) const;
};

/** Implementation of the Profile.
 */
class ProfileImpl : public Profile {
protected:
  ListCollection               _modelFeatureMappings;
  bool                         _debug;

public:

private:
  double _computeAggregateScore(ListCollection *evaluationResults);

  EvaluationResult *_getEvaluationResult(Model *model, 
					 Item *arg, 
					 Item *featureNumber);

  ListCollection *
    _getEvaluationResults(ListCollection *fv, 
			  ListCollection *evaluationResults = 0x0);

public:
  ProfileImpl(void);

  virtual void toString(void);

  virtual void addModelFeatureMapping(Model *m, int feature);
  virtual void addModelFeatureMapping(Model *m, ListCollection *featureSet);

  virtual Model *get_model(unsigned int index);
  virtual unsigned int get_number_of_models(void);


  virtual void insert_item(ListCollection *fv);
  virtual void switch_mode(Model::ModelMode mode);
  virtual double check_item(ListCollection *fv);

  virtual ListCollection *
    check_item_individual_model_scores(ListCollection *fv);

  virtual double check_item_deep(ListCollection *fv,
				 ListCollection *evaluationResults);
};


#ifdef HAVE_SMILE
class SmartProfile : public ProfileImpl
{
 public:
  virtual double check_item(ListCollection *fv) = 0x0;

  // virtual void check();
};

class GBUSmartProfile : public SmartProfile {
 private:

  BayesianNetworkModel *_good;
  BayesianNetworkModel *_bad;
  BayesianNetworkModel *_ugly;

 public:

  GBUSmartProfile(BayesianNetwork *bn);

  virtual double check_item(ListCollection *fv);

};

#endif

#endif
