/* Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: list_collection.cpp,v 1.5 2003/02/28 22:00:59 chris Exp $ */

#include <anomaly.h>

ListCollection::~ListCollection()
{

}

void ListCollection::lock()
{
  ListCollection::iterator i;
  
  for (i = this->begin(); i != this->end(); i++) {
    if (*i)
      (*i)->lock();
  }

  ++_refc;
}

void ListCollection::release()
{
  ListCollection::iterator i;
  
  for (i = this->begin(); i != this->end(); i++) {
    if (*i)
      (*i)->release();
  }
  
  if (_refc == 0) 
    delete this;
  else
    --_refc;
}

void ListCollection::to_string(ostream &o) const 
{
  o << "ListCollection(";
  for(const_iterator i = begin(); i != end() ; i++) {
    if(*i) 
      (*i)->to_string(o);
    else 
      o << "<NULL>";
  }
  o << ")";
}

size_t ListCollection::hash_value() const
{
  size_t res = 0;

  for(const_iterator i = begin(); i != end() ; i++) {
    if (*i)
      res = (res << 1)^(*i)->hash_value();
  }

  return res;
}



