/* Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: item_count.cpp,v 1.7 2003/02/28 22:00:59 chris Exp $ */

#include <anomaly.h>

ItemCount::ItemCount()
{ 
  _item = NULL; 
  _count = 0;
}

ItemCount::ItemCount(Item *i)
{ 
  _item = i; 
  _count = 0;
}

ItemCount::ItemCount(Item* i, size_t c)
{
  _item = i;
  _count = c;
}
  
ItemCount::~ItemCount()
{

}

void ItemCount::lock()
{
  if (_item)
    _item->lock();

  ++_refc;
}

void ItemCount::release()
{
  if (_item)
    _item->release();

  if (_refc == 0)
    delete this;
  else
    --_refc;
}

size_t ItemCount::hash_value() const
{
  if (_item)
    return _item->hash_value();
  else
    return (size_t) 0;
}


bool ItemCount::operator<(ItemCount& right)
{
  return _count < right._count;
}

void ItemCount::to_string(ostream &o) const
{
  o << "ItemCount(";
  if(_item) _item->to_string(o);
  else o << "<NULL>";
  o << "," << _count << ")";
}

Item* ItemCount::getValue()
{
  return _item;
}

size_t ItemCount::getCount() const
{
  return _count;
}

void ItemCount::setValue(Item *i) 
{
  _item = i;
}
