/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: item.cpp,v 1.8 2003/03/25 05:44:14 dhm Exp $ */

#include <anomaly.h>

unsigned int Item::_total_alloc = 0;

unsigned int Item::get_allocated()
{
  return _total_alloc;
}

Item::Item()
{
  _refc = 0;
  ++_total_alloc;
}

Item::~Item()
{
  --_total_alloc;
}

void Item::lock()
{
  ++_refc;
}

void Item::release()
{
  if (_refc == 0) 
    delete this;
  else
    --_refc;
}

bool Item::operator==(const Item & right) const
{
  return this == &right;
}

void Item::to_string(ostream &out) const {
  out << "Item()";
}

ostream& operator<< ( ostream& os, Item& i) {
  i.to_string(os);
  return os;
}

ostream& operator<< ( ostream& os, Item* i) {
  if (i) 
    i->to_string(os);
  else
    os << "<NULL>";
  return os;
}

double DoubleItem::get_value(void) const {
  return _x;
}
