/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: integer_item.cpp,v 1.4 2003/02/27 22:37:18 chris Exp $ */

#include <anomaly.h>

IntegerItem::IntegerItem()
{
  _i = 0;
}

IntegerItem::IntegerItem(int i)
{
  _i = i;
}

IntegerItem::~IntegerItem()
{
}

bool IntegerItem::operator==(const Item & right) const  {
  const IntegerItem *iright = dynamic_cast<const IntegerItem *>(&right);

  if ((iright != 0) && (_i == iright->_i))
    return true;
  else
    return false;
}

size_t IntegerItem::hash_value() const
{
  size_t res = 0;
  size_t len = sizeof(_i);

  const char *p = reinterpret_cast<const char *>(&_i);
  while (len--) res = (res << 1)^*p++;

  return res;
}


void IntegerItem::to_string(ostream &out) const {
   out << "IntegerItem(" << _i << ")";
}

size_t IntegerItem::value() const {
  return (size_t) _i;
}

bool IntegerItem::operator<(const Item &right) const throw (NumericalException) {
  const IntegerItem *iright = dynamic_cast<const IntegerItem *>(&right);

  if (iright != 0)
    return _i < iright->_i;
  else
    throw NumericalException("right item is not of type NumericalItem");
}

