/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: char_item.cpp,v 1.3 2003/02/27 22:37:18 chris Exp $ */

#include <anomaly.h>

CharItem::CharItem()
{
  _c = '\0';
}

CharItem::CharItem(unsigned char c)
{
  _c = c;
}

CharItem::~CharItem()
{
}

bool CharItem::operator==(const Item &right) const
{
  const CharItem *cright = dynamic_cast<const CharItem *>(&right);

  if ((cright != 0) && (_c == cright->_c))
    return true;
  else
    return false;
}

size_t CharItem::hash_value() const
{
  return (size_t) _c;
}


void CharItem::to_string(ostream &out) const 
{
  out << "CharItem(" << _c << ")";
}

size_t CharItem::value() const {
  return (size_t) _c;
}

bool CharItem::operator<(const Item &right) const throw (NumericalException) {
  const CharItem *cright = dynamic_cast<const CharItem *>(&right);

  if (cright != 0)
    return _c < cright->_c;
  else
    throw NumericalException("right item is not of type NumericalItem");
}
