#ifndef BAYES_H__
#define BAYES_H__

/* Copyright (C) 2003 Reliable Software Group 
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* $Id: bayes.h,v 1.6 2003/10/06 23:17:17 dhm Exp $ */

#include <iostream>
#include <smile/network.h>

#include "anomaly.h"

#define MAXBUFFER 4096

// forward class decls
class BayesianNetworkImpl;

/** \brief A libAnomaly Model implementation. This is a 'view' of an
 *  instance of BayesianNetwork, corresponding to a single state of 
 *  a single query variable in the instance of Bayesian Network. 
 */
class BayesianNetworkModelImpl : public BayesianNetworkModel {
 private:
  BayesianNetworkImpl                          *_bn;
  DSL_network                                  *_net;
  char                                         *_queryVariable;
  char                                         *_stateName;
  char                                         _debugString[MAXBUFFER];

 public:

 private:

 public:
  BayesianNetworkModelImpl(BayesianNetwork *bn, 
			   string queryVariable, 
			   string stateName);

  virtual void insert_item(Item *item) throw (ModelInputException);
  
  virtual void switch_mode(ModelMode mode);

  virtual double check_item(Item *item) throw (ModelInputException);

  virtual double get_confidence(void);
};

class BayesianNetworkImpl : public BayesianNetwork {
 private:
  string                                     _filename;
  DSL_network                                *_net;

 public:
  BayesianNetworkImpl(string filename);
  DSL_network *getNetworkReference(void) { return _net; }
};


#endif

