#include <fstream>
#include <iostream>
#include <string>

#include "anomaly.h"

using namespace std;

#define LINE_SIZE 512



void usage(const char *fname)
{
  cerr << fname << " <input file>\n";
  exit(1);
}

char* eat_ws(char *p) 
{
  while ((*p == ' ') || (*p == '\t'))
    ++p;
  return p;
}  

bool callUnitTestMethods(void) {
  // call test methods for each class
  bool testingVerbosity = true;
  
  cout << "Testing histogram ... ";
  if (Histogram::test(testingVerbosity)) {
    cout << "ok" << endl;
  }
  else {
    cout << "FAILED" << endl;
    return false;
  }

  return true;
}

int f(int argc, char **argv)
{
  HiddenMarkovModel *hmm = 
    dynamic_cast<HiddenMarkovModel *>(HiddenMarkovModel::instance());
  ListCollection sequence;

  if (argc != 2)
    usage(argv[0]);

  ifstream in(argv[1]);

  char *p, line[LINE_SIZE];
  int i = 0;
  
  while (in.getline(line, LINE_SIZE)) {
    p = eat_ws(line);
    if (*p == '#')
      continue;

    sequence.clear();
    
    while ((*p != '\0') && (*p != '\t')) {
      sequence.push_back(new CharItem(*p++));
    }
      
    hmm->insert_item(&sequence);
  }

  cout << "input read\n";

  ofstream tmp("step1.dot");
  hmm->to_string(tmp);

  if (!in.eof()) {
    cout << "Get line failed - maybe your lines are too long\n";
    exit(1);
  }

  try {
    hmm->optimize();
  }
  catch (ModelConsistencyException &ex) {
    cerr << "Exception caught: " << ex.get_message() << "\n";
    exit(1);
  }

  ofstream result("step.dot");
  hmm->to_string(result);

  return 0;
}


void g()
{
	Item *x, *y;
	__gnu_cxx::hash_map<Item*, int> map;
	
	x = new CharItem('a');
	y = new CharItem('a');



	map[x] = 1;
	if (map.find(y) != map.end())
	  cout << "ok";
	else
	  cout << "ko";

	x->release();
	y->release();
}

class derived : public ListCollection
{
  int syscallno;
  string procpath;
  // FIX: this should be a real IntegerItem with a real value
  int retval;
  
  const string getSyscall() const;

private:

public:
  ListCollection *getFeatures(void) { return this; }

};


int main(int argc, char **argv)
{
  LinearRegression::test(true);

  bool verbose = true;

  derived *d = new derived();
  d->release();

  try {
    HiddenMarkovModel::test(verbose);
    Histogram::test(verbose);
    TokenFinder::test(verbose);
    numericalUtilities::test(verbose);
#ifdef HAVE_SMILE
    BayesianNetworkModel::test(verbose);
#endif
  }
  catch (ModelException ex) {
    cerr << "General failure: " << ex.get_message() << endl;
    return false;
  }
  catch (LibAnomalyException ex) {
    cerr << "General failure: " << ex.get_message() << endl;
    return false;
  }
  
  // f(argc, argv);

  cout << endl << "all tests successful!" << endl;

  // test_correlation();

  return 0;
}
