#ifndef NUMERICAL_UTILITIES_H__
#define NUMERICAL_UTILITIES_H__

/* Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: numerical_utilities.h,v 1.8 2004/10/20 00:32:50 dhm Exp $ */

#include <anomaly.h>

class numericalUtilities {
private:
  static const double _epsilon;
  static const bool   _debug;

public:

  static double mean(ListCollection *l);
  static double max(ListCollection *l);
  static double variance(ListCollection *l);
  static double standardDeviation(ListCollection *l);

  static double doubleMean(ListCollection *l);
  static double doubleVariance(ListCollection *l);
  static double doubleStandardDeviation(ListCollection *l);

  static double doubleCovariance(ListCollection *sequenceX,
				 ListCollection *sequenceY);

  static double pearsonProductMomentCorrelation(ListCollection *X1,
						ListCollection *X2);



  static void doublePrintValues(ListCollection *l);

  static void doubleHistogram(ListCollection *l, 
			      double low, 
			      double high, 
			      double bucketSize);

  static void doubleHistogram(ListCollection *l, 
			      double bucketSize);

  static bool test(bool verbose);

  // equality for floating point numbers; uses _epsilon
  static bool fpEqual(double a, double b);
};

#endif
