#ifndef EXCEPTION_H__
#define EXCEPTION_H__

/* Declarations of exceptions that the library functions can throw
 * Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: exception.h,v 1.6 2003/04/11 07:17:47 chris Exp $ */


/** \brief Main class for exception handling.
 */
class LibAnomalyException
{
 protected:
  /** String that stores a specific error message.
   */
  string _msg;

 public:
  /** Default constructor and initialize error message with empty
   *  string.  
   */
  LibAnomalyException();

  /** Constructor.
   * @param msg: the string (pointer to character array) with the specific error message
   */
  LibAnomalyException(char *msg);

  /** Virtual Destructor 
   */
  virtual ~LibAnomalyException();

  /** Return the specific error message.
   * @return the stored error message
   */
  virtual string get_message();
};




/** \brief Root exception class for model exceptions.
 * 
 * Exceptions of this type are declared in function signatures.
 */
class ModelException : public LibAnomalyException
{
 public:
  /** Default constructor and initialize error message with empty
   *  string.  
   */
  ModelException();

  /** Constructor.
   * @param msg: the string (pointer to character array) with the specific error message
   */
  ModelException(char *msg);

  /** Virtual Destructor 
   */
  virtual ~ModelException();
};




/** \brief An exception class for internal consistency errors (bugs)
 * in the models.
 *
 * The exceptions of this class are never declared in the function
 * signatures as the application is not supposed to catch them (they
 * should actually never occur. 
 */
class ModelConsistencyException : public ModelException
{
 public:
  /** Default constructor and initialize error message with empty
   *  string.  
   */
  ModelConsistencyException();

  /** Constructor.
   * @param msg: the string (pointer to character array) with the specific error message
   */
  ModelConsistencyException(char *msg);

  /** Virtual Destructor 
   */
  virtual ~ModelConsistencyException();
};




/** \brief An exception class used to signal invalid input to models.
 *
 * Exceptions of this type are declared in function signatures.
 */
class ModelInputException : public ModelException
{
 public:
  /** Default constructor and initialize error message with empty
   *  string.  
   */
  ModelInputException();

  /** Constructor.
   * @param msg: the string (pointer to character array) with the specific error message
   */
  ModelInputException(char *msg);

  /** Virtual Destructor 
   */
  virtual ~ModelInputException();
};




/** \brief An exception class used to signal use of non numerical
 * items when NumericalItem is accepted. 
 *
 * Exceptions of this type are declared in function signatures.
 */
class NumericalException : public LibAnomalyException
{
 public:
  /** Default constructor and initialize error message with empty
   *  string.  
   */
  NumericalException();

  /** Constructor.
   * @param msg: the string (pointer to character array) with the specific error message
   */
  NumericalException(char *msg);

  /** Virtual Destructor 
   */
  virtual ~NumericalException();
};

#endif
