#ifndef ANOMALY_H__
#define ANOMALY_H__

/* Main include file - this is the only one that a user wants to include
 * Copyright (C) 2003 Reliable Software Group
 *                    - University of California, Santa Barbara
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* CVS $Id: anomaly.h,v 1.38 2003/10/07 23:29:46 dhm Exp $ */

/*****************************************************************************/
/*                          General STL Includes                             */
/*****************************************************************************/

#include <iostream>
#include <list>
#include <set>
#include <map>
#include <string>
#if defined(__GNUC__) && __GNUC__ == 3
#include <ext/hash_map>
using namespace __gnu_cxx;
#else
#include <hash_map>
#endif

using namespace std;

/*****************************************************************************/
/*                        Exception Handling Classes                         */
/*****************************************************************************/

#include <libAnomaly/exception.h>


/*****************************************************************************/
/*                                 Items                                     */
/*****************************************************************************/

#include <libAnomaly/item.h>


/*****************************************************************************/
/*                    Containers or Collection of Objects                    */
/*****************************************************************************/

#include <libAnomaly/collection.h>


/*****************************************************************************/
/*                       Models and Model Factories                          */
/*****************************************************************************/

#include <libAnomaly/model.h>


/*****************************************************************************/
/*                                Profile                                    */
/*****************************************************************************/

#include <libAnomaly/profile.h>


/*****************************************************************************/
/*                           Numerical Utilities                             */
/*****************************************************************************/


#include <libAnomaly/numerical_utilities.h>

#endif



