#!/usr/bin/perl
package CyberArmy::Apache::Lists;

## Cyberarmy::Apache::Lists version 0.5
## Created by Pandect
## Last modified: 2-13-2002

## Todo: Implement proxy checking.
##       -- Something I can't do off of this non-inet-connected box! =/
##       -- Or at least something I can't *test*

use strict;
use CyberArmy::Utils::Database;
use CyberArmy::Utils::Config;
use CyberArmy::CGI;

our $cgi = CyberArmy::CGI->new;
our $dbh = CyberArmy::Utils::Database->Connect;

#Seconds to cache HTML output for...
$CyberArmy::Apache::Lists::cachetime = 300;
$CyberArmy::Apache::Lists::lastcache = time - ( $CyberArmy::Apache::Lists::cachetime + 1 ); #Make sure that on first run, cache is updated.
$CyberArmy::Apache::Lists::proxycache = '';
$CyberArmy::Apache::Lists::wingatecache = '';

$CyberArmy::Apache::Lists::levelstoauth = 'z9c6';

our ($params,$posted,$user,$first,@args, $pos);

sub handler {
	my $r = shift;	(undef,$first, @args) = split(/\//,$r->path_info); 
	$params = $cgi->Params(-escapehtml => 1); $posted = $cgi->PostedParams(-escapehtml => 1);
	$user = CyberArmy::Users->Session; 
	print $cgi->Header(-title => "CyberAmy - Lists", -complete => 1).$cgi->PageHeader(-complete => 1);

	&_filter_vars;

	# Implement caching...
	if ( ( time - $CyberArmy::Apache::Lists::lastcache ) > $CyberArmy::Apache::Lists::cachetime )
	{

		&_make_cache;
		$CyberArmy::Apache::Lists::lastcache = time;

	}

	if (!$params->{pos}) { $pos = 1 }
	else { $pos = $params->{pos} }	

	if (!$params->{action} && !$first) { &_frontpage() }
	elsif ($params->{action} eq "add" && $posted->{code}) { &_addnew2(); }
	elsif ($params->{action} eq "add" && !$posted->{code}) { &_addnew(); }
	elsif ($first =~ /proxy/ || $first =~ /wingate/ ) { if ( $params->{action} eq "search" ) { &_search() } elsif ( $params->{action} eq "admin" ) { &_admin; } else { &_wpview() } }
#	elsif ($first eq "proxy" || $first eq "wingate") { &_wpview() }
	else { print "Welcome to Oblivion!"; }


}

sub _make_cache {

	@CyberArmy::Apache::Lists::wingatecache = ('','','','');
	@CyberArmy::Apache::Lists::proxycache = ('','','','');

	my $u = 1;
	my $i = 1;
	while ( $i < 5 ) {
		$u = ( $i - 1 ) * 50;
		my $sth =
		$dbh->prepare( "SELECT iid, location, port, description, creator FROM lists WHERE type LIKE 'wingate' ORDER BY create_time DESC LIMIT $u,50");
		$sth->execute();
		my $wingate_data = $sth->fetchall_arrayref();
		$sth->finish;
	
		my $sth2 =
		$dbh->prepare( "SELECT iid, location, port, description, creator FROM lists WHERE type LIKE 'proxy' ORDER BY create_time DESC LIMIT $u,50");
		$sth2->execute();
		my $proxy_data = $sth2->fetchall_arrayref();
		$sth2->finish;

		my $adminer = '';
		$adminer = qq~ - <a href=http://$CyberArmy::Utils::Config::site{server}/lists/$first?action=admin>(Admin)</a>~;
	
		$CyberArmy::Apache::Lists::proxycache[$i] = qq~
			<h1><div align=center>Proxy List</div></h1><div align=center><a href=http://$CyberArmy::Utils::Config::site{server}/lists/proxy?action=add>(Submit Proxy)</a>$adminer</div>
			<br>
			<table cellpadding="5" cellspacing="0" border="0" width="100%" align="Center">
			  <tbody>
			    <tr>
			      <td colspan=5 align=center>
				<table width=60% border=0 align=center>
				  <tbody>
				    <tr>
				      <td align=right>
					<form method=GET><input type=hidden name=action value=search>Domain Matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=domain value="*.co.uk">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Author:
				      </td>
				      <td align=right>
					<input type=text name=author value="*">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>
					Description matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=desc value="*">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Port: 
				      </td>
				      <td align=right>
					<input type=text name=port value="8080">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>Results per page:</td>
				      <td colspan=2 align=left>
					<select name=pp><option value=100>100</option><option value=50 selected>50</option><option value=25>25</option><option value=10>10</option></select>
				      </td>
			              <td align=right>
					<input type=submit value="Search"></form>
			              </td>
			            </tr>
				  </tbody>
				</table>
			      </td>
			    <tr>
			      <td colspan=5 align=center>
				<hr align=center width=40% size=2>
			      </td>
			    </tr>
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				<b>Description</b>
			      </td>
			      <td width="15%">
				<b>Address</b>
			      </td>
			      <td width="100">
				<b>Port</b>
			      </td>
			      <td width="15%"><b>Submitted by</b></td>
			    </tr>		    <tr>
			      <td colspan=5 >&nbsp;</td>
			    </tr>
		~;
	
		$CyberArmy::Apache::Lists::wingatecache[$i] = qq~
			<h1><div align=center>Wingate List</div></h1><div align=center><a href=http://$CyberArmy::Utils::Config::site{server}/lists/wingate?action=add>(Submit Wingate)</a>$adminer</div>
			<br>
			<table cellpadding="5" cellspacing="0" border="0" width="100%" align="Center">
			  <tbody>
			    <tr>
			      <td colspan=5 align=center>
				<table width=60% border=0 align=center>
				  <tbody>
				    <tr>
				      <td align=right>
					<form method=GET><input type=hidden name=action value=search>Domain Matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=domain value="*.co.uk">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Author:
				      </td>
				      <td align=right>
					<input type=text name=author value="*">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>
					Description matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=desc value="*">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Port: 
				      </td>
				      <td align=right>
					<input type=text name=port value="8080">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>Results per page:</td>
				      <td colspan=2 align=left>
					<select name=pp><option value=100>100</option><option value=50 selected>50</option><option value=25>25</option><option value=10>10</option></select>
				      </td>
			              <td align=right>
					<input type=submit value="Search"></form>
			              </td>
			            </tr>
				  </tbody>
				</table>
			      </td>
			    <tr>
			      <td colspan=5 align=center>
				<hr align=center width=40% size=2>
			      </td>
			    </tr>
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				<b>Description</b>
			      </td>
			      <td width="15%">
				<b>Address</b>
			      </td>
			      <td width="100">
				<b>Port</b>
			      </td>
			      <td width="15%"><b>Submitted by</b></td>
			    </tr>		    <tr>
			      <td colspan=5 >&nbsp;</td>
			    </tr>
		~;
	
		my $x = 0;
		foreach (@$wingate_data) {
		$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				$wingate_data->[$x]->[3]
			      </td>
			      <td width="15%">
				<!-- IID: $wingate_data->[$x]->[0] -->
				$wingate_data->[$x]->[1]
			      </td>
			      <td width="100">
				$wingate_data->[$x]->[2]
			      </td>
			      <td width="15%">
				$wingate_data->[$x]->[4]
			      </td>
			    </tr>
		~;
		$x++;
		}
	
		$x=0;
		foreach (@$proxy_data) {
		$CyberArmy::Apache::Lists::proxycache[$i] .= qq~
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				$proxy_data->[$x]->[3]
			      </td>
			      <td width="15%">
				<!-- IID: $proxy_data->[$x]->[0] -->
				$proxy_data->[$x]->[1]
			      </td>
			      <td width="100">
				$proxy_data->[$x]->[2]
			      </td>
			      <td width="15%">
				$proxy_data->[$x]->[4]
			      </td>
			    </tr>
	~;
	$x++;
	}

	$CyberArmy::Apache::Lists::proxycache[$i] .= qq~
		  </tbody>
		</table><br><br>~;

	unless ( $i == 1 || $i == 4 ) {
		my $forpos = $i +1;
		my $backpos = $i - 1;
		my $two = "2"; my $three = "3";
		if ($i == 2) { $two = "<font color=orange>2</font>" } else { $three = "<font color=orange>3</font>" }
		$CyberArmy::Apache::Lists::proxycache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=1">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=2">$two</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=3">$three</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=4">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=$backpos">&lt; &lt;</a>&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=$forpos">&gt; &gt;</a></div>~;

	} elsif ( $i == 1 ) {

		$CyberArmy::Apache::Lists::proxycache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=1"><font color="orange">1</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=2">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=3">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=4">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=2">&gt; &gt;</a></div>~;

	} elsif ( $i == 4 ) {

		$CyberArmy::Apache::Lists::proxycache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=1">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=2">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=3">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=4"><font color="orange">4</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy?pos=3">&lt; &lt;</a></div>~;

	}

	$CyberArmy::Apache::Lists::proxycache[$i] .= qq~
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists">&lt;&lt;Back to /lists</a>
	~;


	$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~
		  </tbody>
		</table><br><br>~;

	unless ( $i == 1 || $i == 4 ) {
		my $forpos = $i +1;
		my $backpos = $i - 1;
		my $two = "2"; my $three = "3";
		if ($i == 2) { $two = "<font color=orange>2</font>" } else { $three = "<font color=orange>3</font>" }
		$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=1">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=2">$two</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=3">$three</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=4">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=$backpos">&lt; &lt;</a>&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=$forpos">&gt; &gt;</a></div>~;

	} elsif ( $i == 1 ) {

		$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=1"><font color="orange">1</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=2">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=3">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=4">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=2">&gt; &gt;</a></div>~;

	} elsif ( $i == 4 ) {

		$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=1">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=2">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=3">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=4"><font color="orange">4</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate?pos=3">&lt; &lt;</a></div>~;

	}

	$CyberArmy::Apache::Lists::wingatecache[$i] .= qq~
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists">&lt;&lt;Back to /lists</a>
	~;

	$i++;
	}
	

}

sub _frontpage {

print qq~
<br>Available lists:<br>
- <a href="http://$CyberArmy::Utils::Config::site{server}/lists/wingate">Wingate</a><br>
- <a href="http://$CyberArmy::Utils::Config::site{server}/lists/proxy">Proxy</a><br>

~;

}

sub _wpview {

	if ($first =~ /wingate/) { print $CyberArmy::Apache::Lists::wingatecache[$pos]; } 
	elsif ($first =~ /proxy/) { print $CyberArmy::Apache::Lists::proxycache[$pos]; }

}

sub _addnew {

	my @chars  = ('1'..'3');
	my @chars2 = ('0'..'4');
	my $key;
	$key .= $chars[int rand $#chars];
	$key .= $chars2[int rand $#chars2];

	my $real = "";

	$real = "EP7SOHCROG" if ($key eq 10);
	$real = "IOHXNPIAQO" if ($key eq 11);
	$real = "I1PRF1UM8S" if ($key eq 12);
	$real = "1GSGZ2FSLP" if ($key eq 13);
	$real = "ON4DAYJU44" if ($key eq 14);
	$real = "NFCVUV123F" if ($key eq 20);
	$real = "W2MGL65IK3" if ($key eq 21);
	$real = "TXXANIO8R0" if ($key eq 22);
	$real = "3ZRBNGOAMQ" if ($key eq 23);
	$real = "DRUJ0042ZE" if ($key eq 24);
	$real = "2DJIZLWI7W" if ($key eq 30);
	$real = "8WZAL1RUTR" if ($key eq 31);
	$real = "3S6WPYSE7Y" if ($key eq 32);
	$real = "CRF50DPQ12" if ($key eq 33);
	$real = "KI6KSBNUNH" if ($key eq 34);

	my $printval = $real;
	$printval =~ tr/A-Z0-9/8LMNOP45XW1VUQRST902KJI3HGAB6C7DEFYZ/;

	if ($first) {

	print qq~
		<h1><div align=center>Add New $first</div></h1>
		<br>
		<table cellpadding="5" cellspacing="0" border="0" width="75%" align="Center">
		  <tbody>
		    <tr>
		      <td>
			<form method=POST><input type=hidden name=action value=add><input type=hidden name=verify value=$printval>Address <font size = 2><i>(URL)</i></font>:
		      </td>
		      <td>
			<input type=text name=loc>
		      </td>
		    </tr>
		    <tr>
		      <td>
			Port:
		      </td>
		      <td>
			<input type=text name=port>
		      </td>
		    </tr>
		    <tr>
		      <td>
			Description <font size = 2><i>(Anything you want to say/mention)</i></font>:
		      </td>
		      <td>
			<input type=text name=descr>
		      </td>
		    </tr>
		    <tr>
		      <td>
			<font size=2>Please write the contents of the image below into the box directly right.</font><br><img src="$CyberArmy::Utils::Config::site{includes}/protection/$key.jpg" border=0>
		      </td>
		      <td>
			<input type=text name=code>
		      </td>
		    </tr>
		    <tr><td colspan=2>
			<input type=submit value="Submit"></form>
		    </td></tr></tbody></table>
	~;
	} else {
		print "Please go to a section [proxy/wingate] before you try to add!";
	}


}

sub _addnew2 {

	
	my $printval = $posted->{verify};
	$printval =~ tr/8LMNOP45XW1VUQRST902KJI3HGAB6C7DEFYZ/A-Z0-9/;

	if ( $first ) {

	if ( &_filter_posted ) {

		if ( $printval eq $posted->{code} ) {
			
			my $username = $user->{fields}->{showname};
			$username = "Guest" if (!$user->{fields}->{showname});
	
			eval { $dbh->do("INSERT INTO lists ( create_time, location, port, description, type, creator ) VALUES ( ?, ?, ?, ?, ?, ? )", undef, time, $posted->{loc}, $posted->{port}, $posted->{descr}, $first, $username ); };
			if ($@) { print "Database insert failed. Please try again momentarily." }
			else { print "Database insert successful. Please wait a minute or two for the server cache to be updated before you will view your $first in the list."; }
	
		} else {
			
			print "Code incorrect! Please go back and enter it again...";
	
		}

	} else { print "Your form was not complete. Please go back and try again." }

	} else { print "Please go to a section [proxy/wingate] before you try to add!"; }

}

sub _search {

	my $u = ($pos -1) * $params->{pp};
	my $worp = $first;

	my $sth =
	$dbh->prepare( "SELECT iid, location, port, description, creator FROM lists WHERE type LIKE '$worp' AND description LIKE '$params->{desc}' AND creator LIKE '$params->{author}' AND port LIKE '$params->{port}' AND location LIKE '$params->{domain}' ORDER BY create_time DESC LIMIT $u,$params->{pp}");
	$sth->execute();
	my $data = $sth->fetchall_arrayref();
	$sth->finish;

	&_out_filter;

	my $adminer = '';
	if ($user) { $adminer = qq~ - <a href=http://$CyberArmy::Utils::Config::site{server}/lists/$first?action=admin>(Admin)</a>~ if (&_check_auth($CyberArmy::Apache::Lists::levelstoauth)); }

	if ( $first eq "proxy" ) { print qq~ <h1><div align=center>Proxy List</div></h1><div align=center><a href=http://$CyberArmy::Utils::Config::site{server}/lists/proxy?action=add>(Submit Proxy)</a>$adminer</div><br> ~; }
	else { print qq~ <h1><div align=center>Wingate List</div></h1><div align=center><a href=http://$CyberArmy::Utils::Config::site{server}/lists/wingate?action=add>(Submit Wingate)</a>$adminer</div><br> ~; }

	print qq~
			<table cellpadding="5" cellspacing="0" border="0" width="100%" align="Center">
			  <tbody>
			    <tr>
			      <td colspan=5 align=center>
				<table width=60% border=0 align=center>
				  <tbody>
				    <tr>
				      <td align=right>
					<form method=GET><input type=hidden name=action value=search>Domain Matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=domain value="$params->{domain}">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Author:
				      </td>
				      <td align=right>
					<input type=text name=author value="$params->{author}">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>
					Description matches:&nbsp; &nbsp;
				      </td>
				      <td>
					<input type=text name=desc value="$params->{desc}">&nbsp; &nbsp;
			              </td>
			              <td align=right>
					Port: 
				      </td>
				      <td align=right>
					<input type=text name=port value="$params->{port}">
			              </td>
			            </tr>
			            <tr>
			              <td align=right>Results per page:</td>
				      <td colspan=2 align=left>
					<select name=pp><option value=100>100</option><option value=50 selected>50</option><option value=25>25</option><option value=10>10</option></select>
				      </td>
			              <td align=right>
					<input type=submit value="Search"></form>
			              </td>
			            </tr>
				  </tbody>
				</table>
			      </td>
			    <tr>
			      <td colspan=5 align=center>
				<hr align=center width=40% size=2>
			      </td>
			    </tr>
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				<b>Description</b>
			      </td>
			      <td width="15%">
				<b>Address</b>
			      </td>
			      <td width="100">
				<b>Port</b>
			      </td>
			      <td width="15%"><b>Submitted by</b></td>
			    </tr>		    <tr>
			      <td colspan=5 >&nbsp;</td>
			    </tr>
		~;

	my $x = 0;
	foreach (@$data) {
		print qq~
			    <tr>
			      <td width="20%"></td>
			      <td width="33%">
				$data->[$x]->[3]
			      </td>
			      <td width="15%">
				<!-- IID: $data->[$x]->[0] -->
				$data->[$x]->[1]
			      </td>
			      <td width="100">
				$data->[$x]->[2]
			      </td>
			      <td width="15%">
				$data->[$x]->[4]
			      </td>
			    </tr>
		~;
		$x++;
	}

	print qq~
		  </tbody>
		</table><br><br>~;

	unless ( $pos == 1 || $pos == 4 ) {
		my $forpos = $pos +1;
		my $backpos = $pos - 1;
		my $two = "2"; my $three = "3";
		if ($pos == 2) { $two = "<font color=orange>2</font>" } else { $three = "<font color=orange>3</font>" }
		print qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=1&action=search">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=2&action=search">$two</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=3&action=search">$three</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=4&action=search">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=$backpos&action=search">&lt; &lt;</a>&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=$forpos&action=search">&gt; &gt;</a></div>~;

	} elsif ( $pos == 1 ) {

		print qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=1&action=search"><font color="orange">1</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=2&action=search">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=3&action=search">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=4&action=search">4</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=2&action=search">&gt; &gt;</a></div>~;

	} elsif ( $pos == 4 ) {

		print qq~ <div align="center">Page &nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=1&action=search">1</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=2&action=search">2</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=3&action=search">3</a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=4&action=search"><font color="orange">4</font></a>&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists/$worp?desc=$params->{desc}&port=$params->{port}&author=$params->{author}&domain=$params->{domain}&pp=$params->{pp}&pos=3&action=search">&lt; &lt;</a></div>~;

	}

	print qq~
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists">&lt;&lt;Back to /lists</a>
	~;


}

sub _admin {

if ( $user ) { 
	if ( &_check_auth($CyberArmy::Apache::Lists::levelstoauth) ) {
		if ($params->{iid}) {

			my $statement = qq~  ~;
			
			eval ' $dbh->do("DELETE FROM lists WHERE iid = ?", undef, $params->{iid}); ';

			if ($@) { print "Error in deletion from database: $@. Please try again in a few minutes, or contact an admin to resolve the problem."; }
			else { print "<br>$first IID $params->{iid} successfully removed from database."; }

			print qq~<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://$CyberArmy::Utils::Config::site{server}/lists">&lt;&lt;Back to /lists</a>~;

		} else {
				
			print qq~ <br><br><form method=get><input type=hidden name=action value=admin>Enter ID number of the proxy/wingate you wish to delete: &nbsp; <input type=text name=iid> &nbsp; <input type=submit name=submit value="Delete"></form>~; 
			if ($params->{submit}) { print "<font color=red>Please enter an IID</font><br>"; } 
			print qq~<br><b>Note: This process is not reversible.</b><br><br><i><b>Hint:</b> To find an IID, go to the proxy/wingate page with the<br>proxy/wingate which you want to delete, view source,<br> and search for it. There will be a comment with it's IID.</i> ~;

		}
	}
} else {

print "Access denied. Clearance not high enough.";

}

}


#########################
## Utilitarian subs
######
     #
     #
sub _out_filter {

	#Filter all of the vars!
	while ( my ($key, $value) = each %$params) {

		# Transfer a normal * wildcard into a SQL %
		$value =~ s/\%/\*/g;

		# Assign the new value to the key!
		$params->{$key} = $value;

	}

}

sub _check_auth {

	my ( $restricted ) = @_;

	my $valid_access = 0;

	if ( $restricted ) 
	{ 
		my $firstrank = substr($restricted,0,2);
		my $secondrank = substr($restricted,2,4);

		if ( $user->IsInGroup($firstrank) && $user->IsInGroup($secondrank) ) 
		{ $valid_access = 1; }


	} else {
		$valid_access = 1;
	}

	return $valid_access;

}

sub _filter_posted {

	my $go = 1;

	#Filter all of the vars!
	while ( my ($key, $value) = each %$posted) {
	
		# Make a NULL value suitable for the db...
		$go = 0 if !$posted->{$key};
		
		# Take out all non alphanum or nice symbols... Thanks booto!
		$value =~ s/[^_0-9a-zA-Z\s\!\,\.\@\#\$\&\*\(\)\-\+\=\?\/]//eg;

		# Assign the new value to the key!
		$posted->{$key} = $value;
	}

	return 1 if ($go);
	return 0 if (!$go);

}

sub _filter_vars {

	#Filter all of the vars!
	while ( my ($key, $value) = each %$params) {
	
		# Make a NULL value suitable for the db...
		$params->{$key} = undef if !$params->{$key};
		
		# Take out all non alphanum or nice symbols... Thanks booto!
		$value =~ s/[^_0-9a-zA-Z\s\!\,\.\@\#\$\&\*\(\)\-\+\=\?]//eg;

		# Transfer a normal * wildcard into a SQL %
		$value =~ s/\*/\%/g;
	
		# Make the search vars have a * if they are blank...
		if ( $key eq 'desc' || $key eq 'author' || $key eq 'port' || $key eq 'domain' )
		{
			if ( $value eq undef ) { $value = "*"; }
		}

		# Make sure the IID is a number...
		if ( $key eq 'iid' ) { $value =~ s/[^_0-9]//eg; }

		if ( $key eq 'pp' ) { if ( $value eq undef ) { $value = 50; } }
	
		# Assign the new value to the key!
		$params->{$key} = $value;
	}

}

1;




