#!/usr/bin/perl
package CyberArmy::News;

use strict;
use CyberArmy::CGI;
use CyberArmy::Utils::Config;
use CyberArmy::Utils::Database;

#Set this to set the level at which a user can admin! e.g. z9c6
$CyberArmy::News::levelstoauth = "z1c6";

#Seconds to cache news for...
$CyberArmy::News::cachetime = 60;
$CyberArmy::News::lastcache = time - 80;

## Fonts/Colors
	$CyberArmy::News::bgcolor =  "#000000";
	$CyberArmy::News::bgcolor1 = "#FF9900";
	$CyberArmy::News::fontcolor1 = "#000000";
	$CyberArmy::News::fontcolor2 = "#C0C0C0";
	$CyberArmy::News::font = "Verdana";
	$CyberArmy::News::size = "2";
## Tables
	$CyberArmy::News::tablewidth="175"; ## The Width Of The News Tables
	$CyberArmy::News::newstoshow = "4"; ## How Many News To Show?
	$CyberArmy::News::topicmaxlength = "30"; ## The Max Length Of The News Topic (0 = Disabled)
	$CyberArmy::News::textmaxlength = "300"; ## The Max Length Of The News Text (0 = Disabled)
	$CyberArmy::News::wordsmaxlength = "30"; ## The Max Length Of The Words, Prevent Table Distortions (0 = Disabled)

our $dbh  = CyberArmy::Utils::Database->Connect;

our ($params, $posted, $cgi, $user, $news_data);

sub export {

	$user = CyberArmy::Users->Session;
	$cgi  = CyberArmy::CGI->new;

	$params = $cgi->Params(-escapehtml => 0);
	$posted = $cgi->PostedParams(-escapehtml => 0);

	# I'll bet you can't guess what this one does  =P
	&_filter_vars;

	# Sort out where to go!
	if (!$params->{action}) { &_show; }
	elsif ($params->{action} eq "admin") { 
		if (!$params->{admin}) {
			&_header;
			print qq~
			<a href="$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin&admin=add">Add a news item</a><BR>
			<a href="$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin&admin=edit">Edit a news item</a><BR>
			<a href="$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin&admin=del">Delete a news item</a><BR>
			~;
			&_footer;
		}
		elsif ($params->{admin} eq "add") { &_add; }
		elsif ($params->{admin} eq "del") { &_del; }
		elsif ($params->{admin} eq "edit") { &_edit; }
		else { print "Welcome to Oblivion!"; }
	}
	else { print "Welcome to Oblivion!"; }


}

sub _show {

	# Implement caching...
	if ( ( time - $CyberArmy::News::lastcache ) > $CyberArmy::News::cachetime )
	{
		#Get the description for the requested poll...
		my $limits = $CyberArmy::News::newstoshow * 10;
		my $sth = $dbh->prepare( "SELECT news_id, title, creator, body, create_time, restricted, bg_color FROM news ORDER BY news_id LIMIT $limits" );
		$sth->execute();
		$news_data = $sth->fetchall_arrayref();
		$sth->finish;

		$CyberArmy::News::lastcache = time;

		#print "Updated cache!";

	}

	my $canauth = 0;
	$canauth = 1 if (&_check_auth($CyberArmy::News::levelstoauth));



	for (my $x=0; $x < $CyberArmy::News::newstoshow; $x++)
	{ 

		last if (!$news_data->[$x]->[1]);

		#Quick hack
		my $email = '';

		my $specialbg = $CyberArmy::News::bgcolor1;
		$specialbg = "#cc0000" if ($news_data->[$x]->[5] =~ /c8/);

		my $delpic = "<img border=0 src=\"$CyberArmy::Utils::Config::site{includes}/x.gif\">";
		$delpic = "<a href=\"$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin&admin=del&news_id=$news_data->[$x]->[0]\"><img border=0 src=\"$CyberArmy::Utils::Config::site{includes}/x.gif\" ></a>" if ( $canauth );

		my $edpic = "<img border=0 src=\"$CyberArmy::Utils::Config::site{includes}/edit.gif\">";
		$edpic = "<a href=\"$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin&admin=edit&news_id=$news_data->[$x]->[0]\"><img border=0 src=\"$CyberArmy::Utils::Config::site{includes}/edit.gif\"></a>" if ( $canauth );

#		last if (!$news_data->[$x]->[1]);

		if ( &_check_auth($news_data->[$x]->[5]) ) 
		{

			my $date = gmtime($news_data->[$x]->[4]);
	
			print qq~
			<div align="center">
			<table spacing=0 border="0" width="$CyberArmy::News::tablewidth" >
			  <tr>
			    <td width="%90" bgcolor="$news_data->[$x]->[6]">
				<font face="$CyberArmy::News::font" size="$CyberArmy::News::size"><font color="$CyberArmy::News::fontcolor1"><b>$date</b></font><br><font color="$CyberArmy::News::fontcolor1">$news_data->[$x]->[1]</font>
			    </td>
			    <td width="10%" bgcolor="$specialbg" align=center valign=middle >
				$delpic
				$edpic
			    </td>
			  </tr>
			  <tr bgcolor=$CyberArmy::News::bgcolor >
			    <td colspan=2 width="%100" >
				<font color="$CyberArmy::News::fontcolor2" size="$CyberArmy::News::size" face="$CyberArmy::News::font">$news_data->[$x]->[3]</font>
			    </td>
			  </tr>
			~;
			
			if ( !$email ) {
				print qq~
				  <tr>
				    <td colspan=2 width="%100">
					<p align="right"><font color="$CyberArmy::News::fontcolor2" size="$CyberArmy::News::size" face="$CyberArmy::News::font"> 
					- By <u>$news_data->[$x]->[2]</u>
					</font>
				    </td>
				  </tr>
				</table></div><br>
				~;
			} else { 
				print qq~
				  <tr>
				    <td colspan=2 width="100%">
					<p align="right"><font color="$CyberArmy::News::fontcolor2" size="$CyberArmy::News::size" face="$CyberArmy::News::font"> 
					- By <a href="mailto:$email"><font color="$CyberArmy::News::fontcolor2">$news_data->[$x]->[2]
					</font></a>
				    </td>
				  </tr>
				</table></div><br>
				~;
			}
			
		}
		else { $CyberArmy::News::newstoshow++; }
	}

	print "<div align=center><a href=\"$CyberArmy::Utils::Config::site{officeurl}?area=News&action=admin\">Admin?</a></div>" if (&_check_auth($CyberArmy::Vote::levelstoauth));


}

## Exports finished, on to normal subs...
##########

sub _add {

	if ( $params->{title} && $params->{body} ) 
	{
		unless ( ($params->{title} =~ /.{$CyberArmy::News::topicmaxlength}/ && $CyberArmy::News::topicmaxlength) || ($params->{body} =~ /.{$CyberArmy::News::textmaxlength}/ && $CyberArmy::News::textmaxlength) ) {
			unless ( ($params->{title} =~ /[^\s]{$CyberArmy::News::wordsmaxlength}/ || $params->{body} =~ /[^\s]{$CyberArmy::News::wordsmaxlength}/) && $CyberArmy::News::wordsmaxlength )
			{
				eval {
					$dbh->do("INSERT INTO news ( title, creator, body, create_time, restricted, bg_color ) VALUES ( ?, ?, ?, ?, ?, ? )", undef, $params->{title}, $user->{fields}->{showname}, $params->{body}, time, $params->{restricted}, &_set_color  );
				};
		
				&_header;			
				print "Error creating news: $@. Please contact an administrator to manually inspect the database." if $@;
				print "News successfully created." if !$@;
				&_footer;
			} else {
				&_header;			
				print "Error creating news: One of your words is too long... Please shorten it to less than $CyberArmy::News::wordsmaxlength characters!";
				&_footer;
			}
		} else {
			&_header;			
			print "Error creating news: Your news is too lengthy!";
			&_footer;
		}
	} else 
	{

		&_header;

		print qq~
		<form method=get>
		<br><h2>Add News&nbsp;</h2><br>
		<table>
		  <tr align=center>
		    <td width=50%>
			<div align=right>Title: &nbsp;</div>
		    </td>
		    <td valign="Bottom">
			<div align=left><input type=text name="title" size="35"></div>
		    </td>
		  </tr>
		  <tr align=center>
		    <td width=50%>
			<div align=right>Body: &nbsp;</div>
		    </td>
		    <td valign="Bottom">
			<div align=left><textarea name="body" cols="35" rows="3" ></textarea></div></div>
		    </td>
		  </tr>
		  <tr>
		    <td width=50%>
			<div align=right>Poll restricted to: </div>
		    </td>
		    <td>
			<div align=left><input type=text name="restricted" size="5"></div>
		    </td>
		  </tr>
		  <tr>
		    <td colspan=2>
			<font size=2><i>( ex. z1c6; Rank entered *must* be matched, so to create a Starchamber poll you would put z0c8, etc... )</i></font><br><br>
		    </td>
		  </tr>
		  <tr align=center>
		    <td colspan=2>
			<br><div align=center><input type=submit value="Create"></div>
		    </td>
		  </tr>
		</table>
		<input type=hidden name=area value=News>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value=add></form>
		~;
	
		&_footer;



	}

}


sub _edit {

	if ( $params->{news_id} ) 
	{
		if ( $params->{title} && $params->{body} ) 
		{
			unless ( ($params->{title} =~ /.{$CyberArmy::News::topicmaxlength}/ && $CyberArmy::News::topicmaxlength) || ($params->{body} =~ /.{$CyberArmy::News::textmaxlength}/ && $CyberArmy::News::textmaxlength) ) 
			{
				unless ( ($params->{title} =~ /[^\s]{$CyberArmy::News::wordsmaxlength}/ || $params->{body} =~ /[^\s]{$CyberArmy::News::wordsmaxlength}/) && $CyberArmy::News::wordsmaxlength )
				{
					eval {
						$dbh->do("UPDATE news SET title = ?, body = ?, restricted = ? WHERE news_id = '$params->{news_id}'", undef, $params->{title}, $params->{body}, $params->{restricted}  );
					};
			
					&_header;			
					print "Error editing news: $@. Please contact an administrator to manually inspect the database." if $@;
					print "News successfully edited." if !$@;
					&_footer;
				} else {
					&_header;			
					print "Error editing news: One of your words is too long... Please shorten it to less than $CyberArmy::News::wordsmaxlength characters!";
					&_footer;
				}
			} else {
				&_header;			
				print "Error editing news: Your news is too lengthy!";
				&_footer;
			}
		} else {	
		
			my $edit_data = $dbh->selectrow_arrayref( "SELECT title, body, restricted FROM news WHERE news_id = ?", undef, $params->{news_id} );

			&_header;
	
			print qq~
			<form method=get>
			<br><h2>Edit News&nbsp;</h2><br>
			<table>
			  <tr align=center>
			    <td width=50%>
				<div align=right>Title: &nbsp;</div>
			    </td>
			    <td valign="Bottom">
				<div align=left><input type=text name="title" size="35" value="$edit_data->[0]"></div>
			    </td>
			  </tr>
			  <tr align=center>
			    <td width=50%>
				<div align=right>Body: &nbsp;</div>
			    </td>
			    <td valign="Bottom">
				<div align=left><textarea name="body" cols="35" rows="3" >$edit_data->[1]</textarea></div></div>
			    </td>
			  </tr>
			  <tr>
			    <td width=50%>
				<div align=right>Poll restricted to: </div>
			    </td>
			    <td>
				<div align=left><input type=text name="restricted" 
			~; if ($edit_data->[2]) { print "value=\"$edit_data->[2]\" "; } print qq~ size="5"></div>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2>
				<font size=2><i>( ex. z1c6; Rank entered *must* be matched, so to create a Starchamber poll you would put z0c8, etc... )</i></font><br><br>
			    </td>
			  </tr>
			  <tr align=center>
			    <td colspan=2>
				<br><div align=center><input type=submit value="Edit"></div>
			    </td>
			  </tr>
			</table>
			<input type=hidden name=area value=News>
			<input type=hidden name=action value=admin>
			<input type=hidden name=admin value=edit>
			<input type=hidden name=news_id value=$params->{news_id}></form>
			~;
		
			&_footer;
	
		}

	} else {
		
		&_header;
	
		print qq~
		<form method=get>
		<br>Edit news:&nbsp;<br> <select name="news_id">
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT news_id, title FROM news ORDER BY create_time DESC" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $news_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$news_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> <br><br> &nbsp; <input type=submit value="Edit" >
		<input type=hidden name=area value=News>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value=edit></form>
		~;
	
		&_footer;

	}
	
}
	

sub _del {

	if ($params->{news_id})
	{
		if ($params->{confirm})
		{

			eval {
				$dbh->do("DELETE FROM news WHERE news_id = '$params->{news_id}'");
			};

			&_header;			
			print "Error deleting news: $@. Please contact an administrator to manually inspect the database." if $@;
			print "News successfully deleted." if !$@;
			&_footer;

		} else {

			&_header;
		
			print qq~
			<form method=get>
			<br>Are you sure you want to delete this news item? <br>( ID = $params->{news_id} )<br><br>
			<div align=center><input type=submit value=Yes>
			<input type=hidden name=area value=News>
			<input type=hidden name=action value=admin>
			<input type=hidden name=admin value=del>
			<input type=hidden name=confirm value=1>
			<input type=hidden name=news_id value=$params->{news_id}></form>
			~;
	
			&_footer;
		}

	} else {

		&_header;
	
		print qq~
		<form method=get>
		<br>Delete news:&nbsp;<br> <select name="news_id">
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT news_id, title FROM news ORDER BY create_time DESC" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $news_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$news_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> <br><br> &nbsp; <input type=submit value="Delete" onClick="javascript:var n=confirm('Are you sure you want to delete this poll?'); return n;">
		<input type=hidden name=area value=News>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value=del>
		<input type=hidden name=confirm value=1></form>
		~;
	
		&_footer;
	}

}


## Normal subs finished, on to utility subs...
##########

sub _filter_vars {

	#Filter all of the vars!
	while ( my ($key, $value) = each %$params) {
	
		# Make a NULL value suitable for the db...
		$params->{$key} = undef if !$params->{$key};
		
		# Take out all non alphanum, non nice, and, for now, leave html...
		$value =~ s/[^_0-9a-zA-Z\s\!\,\.\@\#\$\&\*\(\)\-\+\=\?\;\<\>\]\:\/\\]//g;

#		$value =~ s/(\&lt\;)/\</g;
#		$value =~ s/(\&gt\;)/\>/g;
#		$value =~ s/(\&quote\;)/\"/g;

		# Take out not nice HTML... Using this only until I get somethin a little better
		$value =~ s/<[^\/ai].*>//g;

		# Take out multiple spaces...
		$value =~ tr/+/ /;

		# Turn newline into br...
		$value =~ s/\r/<br>/g;
		$value =~ s/\n//g;
	
		# Num vars take out alpha as well...
		if ( $key eq "news_id" )
		{
			$value =~ s/[^0-9]//eg;
		}
	
		# Assign the new value to the key!
		$params->{$key} = $value;
	}

}

sub _check_auth {

	my ( $restricted ) = @_;

	my $valid_access = 0;

	if ( $restricted ) 
	{ 
		my $firstrank = substr($restricted,0,2);
		my $secondrank = substr($restricted,2,4);

		if ( $user->IsInGroup($firstrank) && $user->IsInGroup($secondrank) ) 
		{ $valid_access = 1; }


	} else {
		$valid_access = 1;
	}

	return $valid_access;

}

sub _set_color {

	## Get a user's brigade, then set his color accordingly... 
	# Note, will probably just get the color straight off of the DB

	return "#FF9900";


}

sub _header {

	print qq~
	
	<BR>
	<table cellpadding="1" cellspacing="0" border="0" width="60%" align="Center" bgcolor="#000000" class='blackbg'>
	  <tbody>
	    <tr valign="Top">
	      <td valign="Top">
		<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
		  <tbody>
		    <tr valign="Top">
		      <td valign="Top">
			<div align=center>
	~;
}

sub _footer {

	print qq~
		      </td>
		    </tr>
		  </tbody>
		</table>
	      </td>
	    </tr>
	  </tbody>
	</table>
	~;

}

1337357;






