#!/usr/bin/perl

package CyberArmy::Windstone::Utils;

use strict;
use CyberArmy::Utils;

sub get_sitedetails_by_url {
	my($url) = @_;
	my $site_req = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT id,secret FROM windstone_sites WHERE url = ?"
	);
	$site_req->execute($url);
	my @arr = $site_req->fetchrow_array();
	return @arr if $arr[0];
}

sub get_sitedetails_by_id {
	my($id) = @_;
	my $site_req = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT url,secret FROM windstone_sites WHERE id = ?"
	);
	$site_req->execute($id);
	my @arr = $site_req->fetchrow_array();
	return @arr if $arr[0];
}

sub test_pass_by_id {
	my($id, $pass) = @_;
	my @arr = &get_sitedetails_by_id($id);
	if ($pass eq $arr[1] && length($pass) > 0) { return 1 }
}

sub insert_auth_token {
	my($site_id, $request_token, $caid) = @_;
	my $newtoken = CyberArmy::Utils::RandomAlphaNum(32);

	# fill in the auth field corresponding to the request field
	my $site_insert = $CyberArmy::Utils::Database::dbh->prepare(
		"UPDATE windstone_tokens SET caid = ?, auth_token = ? WHERE siteid = ? AND request_token = ?"
	);
	my $rv = $site_insert->execute($caid, $newtoken, $site_id, $request_token);

	return ($rv > 0?$newtoken:0);
}

sub get_auth {
	my($ca_uname, $pass) = @_;

	my $user = CyberArmy::User->new(nickname => $ca_uname);
	if (!$user) {
		return "-1";
		# "Auth failed(nonexistent) for $ca_uname\n";
	}
    else {
		if (not $user->Passhash($pass)) {
			return "0";
			# "Auth failed for $ca_uname\n";
		}
		elsif ($user->IsBanned) {
			return "-2";
			# "Auth BANNED for $ca_uname\n";
		}
		else {
			# "Auth success for $ca_uname\n";
			return "1";
		}
    }
}

sub expire_old_tokens {
	my($cutoff_diff) = @_;
	
	my $request_cull = $CyberArmy::Utils::Database::dbh->prepare(
		"DELETE FROM windstone_tokens WHERE dateset<(DATE_SUB(NOW(), INTERVAL $cutoff_diff HOUR))"
	);
	return $request_cull->execute();
}

1;