#!/usr/bin/perl

package CyberArmy::Windstone::User;

use strict;
use CyberArmy::Utils;
use CyberArmy::Windstone::Utils;
use SOAP::Transport::HTTP;

  my $server = SOAP::Transport::HTTP::Apache
    -> dispatch_to('Cyberarmy::Windstone::User');

sub get_nickname_from_auth_token {
	my($self, $site_id, $auth_tok, $pass) = @_;
	
	return if !CyberArmy::Windstone::Utils::test_pass_by_id($site_id, $pass);

	my $token_req = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT caid FROM windstone_tokens
		WHERE siteid = ? AND auth_token = ?"
	);
	$token_req->execute($site_id, $auth_tok);
	my @arr = $token_req->fetchrow_array();

	my $user = CyberArmy::User->new(caID => $arr[0]);
	return $user->nickname;
}

sub get_showname_from_nickname {
	my($self, $nickname) = @_;
	return if $nickname !~ /^[a-zA-Z0-9]+$/;

	my $user = CyberArmy::User->new(nickname => $nickname);
	return $user->showname;
}

1;