#!/usr/bin/perl

package CyberArmy::Windstone::Auth;

use strict;
use CyberArmy::Utils;
use CyberArmy::Windstone::Utils;
use SOAP::Transport::HTTP;

  my $server = SOAP::Transport::HTTP::Apache
    -> dispatch_to('Cyberarmy::Windstone::Auth');

sub register_site {
	my($self, $url, $newsecret) = @_;

	# if already have in db, then give them their last number.
	my($precheck, $secret) = CyberArmy::Windstone::Utils::get_sitedetails_by_url($url);
	return $precheck if $precheck;

	# create it
	my $site_insert = $CyberArmy::Utils::Database::dbh->prepare(
		"INSERT INTO windstone_sites VALUES
		(DEFAULT, ?, ?)"
	);
	$site_insert->execute($url, $newsecret);

	# return the id of the newly created site url
	return CyberArmy::Windstone::Utils::get_sitedetails_by_url($url);
}

sub create_request_token {
	my($self, $site_id, $pass) = @_;

	return if !CyberArmy::Windstone::Utils::test_pass_by_id($site_id, $pass);
	my $newtoken = CyberArmy::Utils::RandomAlphaNum(32);

	# create it
	my $site_insert = $CyberArmy::Utils::Database::dbh->prepare(
		"INSERT INTO windstone_tokens VALUES
		(DEFAULT, NOW(), NULL, ?, ?, NULL)"
	);
	
	$site_insert->execute($site_id, $newtoken);

	return $newtoken;
}

1;