#!/usr/bin/perl

package CyberArmy::Windstone::Accomplishments;

use strict;
use CyberArmy::Utils;
use CyberArmy::Windstone::Utils;
use CyberArmy::Accomplishments;
use SOAP::Transport::HTTP;

  my $server = SOAP::Transport::HTTP::Apache
    -> dispatch_to('Cyberarmy::Windstone::Accomplishments');

sub award_accomp_by_nickname {
	my($self, $accomplishment, $target_nick, $note, $ca_uname, $ca_pass) = @_;

	return -3 if (CyberArmy::Windstone::Utils::get_auth($ca_uname, $ca_pass) != 1);
	my $user = CyberArmy::User->new(nickname => $ca_uname);

	return -2 if $target_nick !~ /^[a-zA-Z0-9]+$/;
	my $target_user = CyberArmy::User->new(nickname => $target_nick);

	if (CyberArmy::Accomplishments->canAward($accomplishment, $user)) {
		CyberArmy::Accomplishments->awardOnce(
	            $target_user->caID,
	            $accomplishment,
				$note,
				$user->caID
	    );
		return 1;
	}
	else {
		return -1;
	}
}

1;
