#!perl -wW
package CyberArmy::Wiki;

use strict;
use CyberArmy::Utils;

$CyberArmy::Wiki::VERSION = '0.1';

sub new {
	my ($class,$name) = @_;
	if ($name) {
		my $wiki = $CyberArmy::Utils::Database::dbh->selectrow_hashref
			('SELECT * FROM wiki WHERE name = ? ',undef,$name);
		return $wiki ? bless($wiki, $class) : undef
	} else { return undef }
}

sub getNode {
	my ($wiki,$name,$revision) = @_;
	
	if ($name) {
		if ($revision) {
			if ($revision < 1) {
				my $skip = abs($revision);
				return $CyberArmy::Utils::Database::dbh->selectrow_hashref(
					'SELECT * FROM wiki_revision WHERE wiki = ? AND name = ?'.
					'ORDER BY revision DESC LIMIT '.($skip-1).','.$skip,
				undef,$wiki->{'name'},$name);
			} else {
				return $CyberArmy::Utils::Database::dbh->selectrow_hashref(
					'SELECT * FROM wiki_revision '.
					'WHERE wiki = ? AND name = ? AND revision = ? LIMIT 1',
				undef,$wiki->{'name'},$name,$revision);
			}
		} else {
			return $CyberArmy::Utils::Database::dbh->selectrow_hashref(
				'SELECT * FROM wiki_node WHERE wiki = ? AND name = ? LIMIT 1',
			undef,$wiki->{'name'},$name);
		}
	} else { return undef }
	
}

sub getLinks {
	my ($wiki,@args) = @_;
	
	my ($direction,$name) =  $#args ? (@args) : ('from',$args[0]);
	
	return undef unless $direction and $name;
	
	#$CyberArmy::Utils::Database::dbh->trace(2);
	my $getLinks = $CyberArmy::Utils::Database::dbh->prepare_cached(
			(($direction eq 'from') ?
	'SELECT destination AS link from wiki_link WHERE wiki = ? AND origin = ?' :
	'SELECT origin AS link from wiki_link WHERE wiki = ? AND destination = ?')
	); $getLinks->execute($wiki->{'name'},$name);
	#$CyberArmy::Utils::Database::dbh->trace(0);
	
	my $links = $getLinks->fetchall_hashref('link');
	$getLinks->finish; return $links;
}

sub _indexLinksFromNode { ## WARNING, DOENS'T DO LOCKING!
	my ($wiki,$name,$content) = @_;
	
	## find all the WikiWords that *could* be nodes
	my (@possible_nodes,%possible_nodes,@verfied_nodes);
	foreach (split /\W+/, $$content) {
		$possible_nodes{$CyberArmy::Utils::Database::dbh->quote($1)} = 1
			if(/^((?:[A-Z][a-z]*){2,})$/);
	}
			
	## uniquify the list
	@possible_nodes = keys %possible_nodes;	
	
	## verify
	if ($possible_nodes[0]) {
		my $getLinks = $CyberArmy::Utils::Database::dbh->prepare(
			'SELECT name from wiki_node WHERE wiki = ? AND name IN ('.
			join(',',@possible_nodes).')'
		); $getLinks->execute($wiki->{'name'});
		
		while (my $link = $getLinks->fetchrow_arrayref()) {
			$CyberArmy::Utils::Database::dbh->do(
				'REPLACE wiki_link SET wiki=?,origin=?,destination=?',
			undef,$wiki->{'name'},$name,$link->[0]);
			push @verfied_nodes, "'".$link->[0]."'";
		}
	
		$getLinks->finish;
		
		if ($verfied_nodes[0]) {
			## delete any links that aren't in the current revision (stale)
			$CyberArmy::Utils::Database::dbh->do(
				'DELETE FROM wiki_link WHERE wiki =? and origin=? AND destination NOT IN ('
				.join(',',@verfied_nodes).')',undef,$wiki->{'name'},$name);
		}
	}
}

sub _indexNodeFromLinks {  ## WARNING, DOENS'T DO LOCKING!
	my ($wiki,$name) = @_;

	my $getNodes = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT name from wiki_node WHERE wiki = ? AND content LIKE '%$name%'"
	); $getNodes->execute($wiki->{'name'});
	
	## here we aren't acctually verifying that the node name
	## verbatim, i'm not sure it's worth it compared to the
	## perfomance hit that we will have.
	
	while (my $node = $getNodes->fetchrow_arrayref()) {
		$CyberArmy::Utils::Database::dbh->do(
			'REPLACE wiki_link SET wiki=?,origin=?,destination=?',
		undef,$wiki->{'name'},$node->[0],$name);
	}

	$getNodes->finish;
}

sub setNode {
	my ($wiki,$name,$author,$content,$log,$modified) = @_;
	($name and $author and $content) or return undef;
	 $modified ||= time;
	
	$name =~ /^\w+$/ or return undef; ## sanitized node name
	
	$CyberArmy::Utils::Database::dbh->do( ## consistencies!
		'LOCK TABLES wiki_link WRITE, wiki_revision WRITE, wiki_node WRITE');

	$wiki->_indexLinksFromNode($name,$content);
	$wiki->_indexNodeFromLinks($name);
		
	my $current = $wiki->getNode($name,-1) || {};
	$current->{'revision'}++;
		
	$CyberArmy::Utils::Database::dbh->do(
		'INSERT INTO wiki_revision values (?,?,?,FROM_UNIXTIME(?),?,?,?)',undef,
	$wiki->{'name'},$name,$current->{'revision'},$modified,$log,$author,$$content);
	
	$CyberArmy::Utils::Database::dbh->do(
		'REPLACE wiki_node SET wiki=?,name=?,'.
		'created=FROM_UNIXTIME(?),author=?,content=? '
		,undef,$wiki->{'name'},
	$name,$modified,$author,$$content,$wiki->{'name'},$name);
	
	$CyberArmy::Utils::Database::dbh->do('UNLOCK TABLES');
	return $current->{'revision'};
}


sub getNodeRevisionsList {
	my ($wiki,@args) = @_;
	
	my ($name,$number) =  ($#args >= 0) ? 
		(($args[0] =~ /^\d+$/) ? @args[1,0] : @args) : (undef,7);

	my @bind = ($wiki->{'name'});
	
	if ($name) { push @bind,$name; $name = 'AND name=?' } else { $name = '' }
	
	my ($limit,$period) = !$number ? ('','') :
		('AND created > FROM_UNIXTIME(?)',(time - (60 * 60 * 24 * $number)));
	push @bind,$period  if ($period);
	
	my $getRevisions = $CyberArmy::Utils::Database::dbh->prepare(
		'SELECT revision,name,author,created,log FROM wiki_revision '.
			'WHERE wiki=? '.$name.' '.$limit.' ORDER BY created DESC'
	); $getRevisions->execute(@bind);
	
	my $revisions = $getRevisions->fetchall_arrayref({});
	$getRevisions->finish;

	return $revisions;
}

sub searchNodes {
	my ($wiki,$search) = @_;

	return $CyberArmy::Utils::Database::dbh->selectcol_arrayref(
		'SELECT name FROM wiki_node WHERE wiki=? '.
		'AND (name=? OR content LIKE ?) ORDER BY created DESC',
	{ Columns=>[1] },$wiki->{'name'},$search,'%'.$search.'%');
}

sub deleteNode {
	my ($wiki,$name) = @_;

	if($CyberArmy::Utils::Database::dbh->do(
		'DELETE FROM wiki_node WHERE wiki=? AND name=?',
	undef,$wiki->{'name'},$name)) {
		return (
			$CyberArmy::Utils::Database::dbh->do(
				'DELETE FROM wiki_revision WHERE wiki=? AND name=?',
			undef,$wiki->{'name'},$name),
			$CyberArmy::Utils::Database::dbh->do(
				'DELETE FROM wiki_link WHERE wiki=? '.
				'AND (origin=? OR destination=?)',
			undef,$wiki->{'name'},$name,$name)
		)
	} else { return undef }
}

sub getNodeDiff {}

1;
