#!/usr/bin/perl -W
package CyberArmy::WWW::UserDir;

use strict;
use CyberArmy::User;
use CyberArmy::Accomplishments;

$CyberArmy::WWW::UserDir::VERSION = '0.1';

my $select =
	'nickname,showname,pubemail,away,bantime,retired,'.
	'session_id,session_time,session_ltime,'.
	'publicplan,brigade_id,brigade_pos,brigade_name,date_format(joined_on, \'%d-%b-%Y %T\') AS joined_on';

sub handler {
	# Our CyberArmy site instance..
	my $r = CyberArmy::WWW::Request->instance(shift);
	if ($r->uri =~ /\/~([\w-]+)/ ) {
		CyberArmy::WWW::Utils::escapeHtml(my $nickname = $1);
		my $user = CyberArmy::User->new( 
			nickname => $nickname, select => $select 
		) or return 404;
		
		my $mail = CyberArmy::WWW::Utils::encodeHtml($user->pubemail);
		my $tmp_plan = $user->IsBanned ? '' : $user->publicplan;


		my $tmp_pgpkr = $user->IsBanned ? {} : $user->getPGPKeyRing();
		if ($tmp_pgpkr->{'has_key'}) {
			$tmp_pgpkr->{'uid'} =~ 
				s/<([\w.-]+)(@)([\w.-]+)\.(.+)>$/
					"&lt;$1 \[aht\] $3.".reverse($4)."&gt;";/e;
		}

		my $projects = $user->getProjects();
		my $finalList;
		#this code makes sure a viewer only sees projects they have access to
		my $viewer = CyberArmy::WWW::Request::User->instance();
		foreach my $project(@$projects) { 
			my $ok = 0;
			if ($project->access eq "C") { #Classified/Queued
				
				if ( ($viewer) && 
				( ($viewer->IsInGroup("x".$project->brigade_parent)) || 
				($viewer->IsInGroup($project->group)) )) {
					$ok = 1;
				}
			} 
			elsif ($project->access eq "I") { # Internal project
				if (($viewer) && 
				((($viewer->IsInGroup($project->group)) ||
				($viewer->IsInBrigade($project->brigade_parent)) ||
				($viewer->CheckGroupList($project->invite)))))
				{
					$ok = 1;
				}
			} 
			else { 
				$ok = 1;
			}
			if($ok==1) {
				push(@$finalList,$project);		
			}
		}

		# List achievements
		my $AccomplishmentsList = CyberArmy::Accomplishments->getAccomplishmentsEarnedByCaid($user->caid);
		
		$r->printTemplate('userdir/user.tmpl',
			{ user => $user, plan => $tmp_plan, 
				mail => $mail, pgpkey => $tmp_pgpkr,
				user_skills => $user->skillsSet->get(),
				user_projects => $finalList,
				Accomplishments => $AccomplishmentsList
			});
		
	} else { return 404 }
}

1;
