#!/usr/bin/perl -W
package CyberArmy::WWW::Portal;

use strict;

use CyberArmy::Forum;
use CyberArmy::Template;
use CyberArmy::Projects;
use CyberArmy::Remote::Feed;

$CyberArmy::WWW::Portal::VERSION = '0.1';

sub handler {	
	my %info = ();
	$info{'feeds'} = CyberArmy::Remote::Feed::List->new();
	&ShowPortal();

}


sub ShowPortal{
	
	my $r = CyberArmy::WWW::Request->instance();
	
	my $params = $r->getParams({ escapehtml => 1 });
	my ($news_offset, $myNews, $vulns_offset, $myVulns, $library_offset, $myArticles, $science_offset, $myScience, $itnews_offset, $myITNews);
	
	if ($params->{news} && $params->{news} =~ /^\d+$/ && 
			($params->{news} % 5 == 0) && $params->{news} > 0) {
		$news_offset = $params->{news};
	}

	if ($params->{vulns} && $params->{vulns} =~ /^\d+$/ && 
			($params->{vulns} % 5 == 0) && $params->{vulns} > 0) {
		$news_offset = $params->{vulns};
	}

	if ($params->{library} && $params->{library} =~ /^\d+$/ && 
			($params->{library} % 5 == 0) && $params->{library} > 0) {
		$library_offset = $params->{library};
	}
	
	$news_offset ||=0;
	$myNews = CyberArmy::Remote::Feed::List->new({
				offset => $news_offset,
				count => '5',
			   feedtype => 'secnews'});
			   
	$vulns_offset ||=0;
	$myVulns = CyberArmy::Remote::Feed::List->new({
				offset => $vulns_offset,
				count => '5',
			   feedtype => 'vulns'});

	$myArticles = CyberArmy::Remote::Feed::List->new({
				offset => $library_offset,
				count => '5',
			   feedtype => 'library'});
			   
	$science_offset ||=0;		   
	$myScience = CyberArmy::Remote::Feed::List->new({
				offset => $science_offset,
				count => '5',
			   feedtype => 'science'});
	
	$itnews_offset ||=0;		   
	$myITNews = CyberArmy::Remote::Feed::List->new({
				offset => $itnews_offset,
				count => '5',
			   feedtype => 'itnews'});

	my $remote_host = $ENV{'REMOTE_HOST'};
	my $remote_addr = $ENV{'REMOTE_ADDR'};
	my $xforwardedfor = $ENV{'X-forwarded-for'};
	my $useragent = $ENV{'HTTP_USER_AGENT'};
	my $via = $ENV{'HTTP_VIA'};

	$r->content_type('text/html');
	$r->printTemplate(
		'portal/portal.tmpl', {
			title => "CyberArmy Portal",
			remote_host => $remote_host,
			remote_addr => $remote_addr,
			xforwardedfor => $xforwardedfor,
			via => $via,
			useragent => $useragent,
			newsfeeds => $myNews,
			vulnsfeeds => $myVulns,
			libraryfeeds => $myArticles,
			sciencefeeds => $myScience,
			itnewsfeeds => $myITNews,
			news_offset => $news_offset,
			vulns_offset => $vulns_offset,
			library_offset => $library_offset,
			science_offset => $science_offset,
			itnews_offset => $itnews_offset
		}
	);
	
	return 0;

}


1;
