#!perl -wW
package CyberArmy::WWW::IRC;

#
# IRC Handler
#

$CyberArmy::WWW::IRC::VERSION = '0.5';

use strict;

use CyberArmy::WWW::Request;

sub handler {
	my $r = CyberArmy::WWW::Request->instance( shift );
	my $path = $r->path_info;

	if ($path eq '') { $r->redirectTo('/irc/'); }
	elsif ($path eq '/') { 
		my %mibconfig;
		if (my $user = CyberArmy::WWW::Request::User->instance) {
                        $mibconfig{'nick'} = $user->showname;
                        $mibconfig{'nick'} =~ tr/ //d;
		} else {
			$mibconfig{'nick'} = 'Guest%';
		}
		$r->printTemplate('irc/irc.tmpl',\%mibconfig);
	 }
	elsif ($path eq '/getconfig') {
		my %config;
		if (my $user = CyberArmy::WWW::Request::User->instance) {
			my $attributes = $user->getAttributes('title_abrv');
			$config{'nick'} = $user->showname;
			$config{'nick'} =~ tr/ //d; # nuke spaces
			$config{'ident'} = $user->nickname;
			$config{'realname'} = join(' ',@{$attributes->{'title_abrv'}})
				. '. ' . $user->showname;
			$config{'auto'} = 'Yes';
		} else {
			$config{'nick'} = 'Java%';
			$config{'ident'} = 'javaguest';
			$config{'realname'} = 'Java Applet Guest';
			$config{'auto'} = 'No';
		}
		$r->content_type('plain/text');
		$r->printTemplate('irc/config.tmpl',\%config);
	} else { $r->redirectTo('/includes/'.$r->uri)  }

	return 0;
}

1;
