#!perl -wW
package CyberArmy::WWW::Error;

#
# generic handler for errors
#

$CyberArmy::WWW::Error::VERSION = '0.5.5';

use strict;
use CyberArmy::WWW::Request;

sub handler {
	my $r = CyberArmy::WWW::Request->new(shift);
	return 404 if $r->is_initial_req;
	
	my $code = $r->subprocess_env('REDIRECT_STATUS');
	if (my $error = $r->prev->pnotes('error_tmpl')) {
		$r->printTemplate($error->{'template'},$error->{'args'});
	} else {
		if ($code == 403) {
			my $user = CyberArmy::WWW::Request::User->instance;
			$r->printTemplate('errors/forbidden.tmpl',{ user => $user });
		} elsif ($code == 404) {
			$r->printTemplate('errors/not_found.tmpl');
		} elsif ($code == 409) {
			$r->printTemplate('errors/conflict.tmpl');
		} elsif ($code == 412) {
			$r->printTemplate('errors/precondition_failed.tmpl');
		} elsif ($code == 503) {
			$r->printTemplate('errors/service_unavailable.tmpl');
		} else { 
			$r->printTemplate('errors/internal_server_error.tmpl') 
		}
	}

	return 0;	
}

1;
