#!perl -wW
package CyberArmy::WWW::Contact;

#
# Contacts Handler
#

$CyberArmy::WWW::Contact::VERSION = '0.5';

use strict;

use CyberArmy::Forum;
use CyberArmy::WWW::Request;

sub handler {
	my $r = CyberArmy::WWW::Request->instance( shift );
	my %map_forum = $r->dir_config->get('MAP_FORUM');
	my $user = CyberArmy::WWW::Request::User->instance;
	
	if ($r->method eq 'POST') {
		my $posted = $r->getParams({from=>'posted',escapehtml=>1});
		exit (412) unless (
			$posted->{'message'} && $posted->{'subject'} && $posted->{'topic'} && !($posted->{'topic'} eq ''));

		unless ($user) {
			my $captcha = CyberArmy::WWW::Captcha
					->new({string => $posted->{'security_code'}});
			$captcha ? $captcha->drop() : return 412;
		}
	
		my $forum = CyberArmy::Forum->new(
			id => $map_forum{$posted->{'topic'}}
		) or exit (500);

		my ($caid,$name,$rank,$color,$badge);
		if ($user && not $posted->{'anonymous'}) {
			my $attributes = $user->getAttributes('title_abrv','badge');
			$name = $user->showname; $caid = $user->caID;
			$rank = join(' ',@{$attributes->{'title_abrv'}});
			$badge = join(',',@{$attributes->{'badge'}});
			$color = $user->brigade_hex_color if $user->brigade_pos;
		} else { $name = 'Anonymous Hero'; $rank = 'Guest'; }
		
		my $host = gethostbyaddr(pack('C4',split(/\./,$r->get_remote_host)),2);
		my $subject = "\[$posted->{topic}\] $posted->{subject}";

		my $id = $forum->PostMessage(
			author => $name,
			author_rank => $rank,
			author_caID => $caid,
			author_color => $color,
			author_ip => $r->get_remote_host,
			author_host => $host,
			author_badge => $badge,
			subject => $subject,
			body => $posted->{'message'}
		) or exit (500);
		
		my $cms = 0;
		if ($user && not $posted->{'anonymous'}) {
			#remind the user what they sent in
			$cms = 1;
			CyberArmy::Message->new(
					caID => [$user->caID],
					user => $user,
					subject => 'Feedback Submitted',
					body => 'Thank you for your recent feedback submission.<br>'
					.'For future reference, this request has been assigned the id: '.$id.'<br><br>'
					.'[center]-----------------------------------------------------------------------[/center]<br><br>'
					.'Category: [b]'.$posted->{topic}.'[/b]<br>'
					.'Subject: [b]'.$posted->{subject}.'[/b]<br>'
					.'[quote]'.$posted->{'message'}.'[/quote]'
				) or $cms = 0;
			}
		$r->printTemplate('contact/thank_you.tmpl',{ id => $id, cms => $cms });					

	} else {
		my $captcha = $user ? {} : CyberArmy::WWW::Captcha->new();
		$r->printTemplate('contact/form.tmpl',
			{captcha => $captcha, map_forum => \%map_forum})
	}
	
	return 0;
}

1;
