#!perl -wW
package CyberArmy::WWW::Bootcamp;

#
# Handles registrations
#

use strict;

use CyberArmy::User;
use CyberArmy::Utils;
use CyberArmy::Template;
use CyberArmy::Database;
use CyberArmy::WWW::Request;
use CyberArmy::WWW::Captcha;

sub handler {
	my $r = CyberArmy::WWW::Request->instance( shift );
	$r->redirectTo($r->uri .'/') unless ($r->uri =~ m{/$});

	my $ip = $r->connection->remote_ip;

	if ($r->method eq 'POST') {
		my $posted = $r->getParams({from=>'posted',escapehtml=>1});
		$r->errorTemplate(412,'bootcamp/error_invalid_info.tmpl') unless (
			$posted->{'showname'} && $posted->{'email'} 
			&& $posted->{'email'} =~ /\@/ ## invalid email
			&& (length($posted->{'email'}) < 46) ## email too long
			&& (my $showname = CyberArmy::Utils::niceShowName($posted->{'showname'}))
		);

		my $nickname = CyberArmy::Utils::nickFromShowName($showname);

		( ## see if we don't have the choosen info already in the db
			CyberArmy::User->new(nickname => $nickname)
				or CyberArmy::User->new(prvemail => $posted->{'email'})
		) && $r->errorTemplate(412,'bootcamp/error_inuse.tmpl');

		my $db = CyberArmy::Database->instance;
		my @check = $db->selectrow_array(
		'SELECT nickname FROM script_register '.
			'WHERE (nickname = ? OR prvemail = ?)',
		undef,$nickname,$posted->{'email'});
		$r->errorTemplate(412,'bootcamp/error_inuse_reg.tmpl') if $check[0];
			
		my $captcha = CyberArmy::WWW::Captcha
				->new({string => $posted->{'security_code'}});
		$captcha ? $captcha->drop() : return 412;

		## All checks ok, we proceed..
		my $confirmation = CyberArmy::Utils::RandomAlphaNum(24);

		if ($db->do(
			'INSERT INTO script_register (confirm,nickname,showname,prvemail,rdate,'.
			'remote_ip) VALUES (?,?,?,?,NOW(),?)',
			undef,$confirmation,$nickname,$showname,$posted->{'email'},$ip
		)) {

			CyberArmy::Template->instance
				->process('bootcamp/confirmation_email.tmpl',
					{ confirmation => $confirmation, showname => $showname, 
						ip=>$ip, server => $r->getServerLink(),
						location => $r->uri },
			\my $body);

			CyberArmy::Mail::Send(
				from => $r->dir_config('MAIL_FROM'),
				to => [$posted->{'email'}, $showname],
				body => $body,
				subject => 'Registration confirmation for '.$showname
			);

			$r->printTemplate('bootcamp/confirmation.tmpl',
				{email => $posted->{'email'}});	
				
			$db->do(
			'REPLACE INTO join_reason_votes (nickname,reason_id,comments,rdate) VALUES (?,?,?,NOW())',
			undef,$nickname,$posted->{'reason'},$posted->{'comments'});
		} else { return 500 }

	} else {
		my $params = $r->getParams({escapehtml=>1});
		if ($params->{'confirm'}) {
			my $db = CyberArmy::Database->instance;
			my $registration = $db->selectrow_arrayref(
				'SELECT prvemail,nickname,showname FROM script_register WHERE confirm = ?',
			undef,$params->{'confirm'}) or return 412;

			unless (CyberArmy::User->new(nickname => $registration->[1])) {
				my $generate_password = CyberArmy::Utils::RandomAlphaNum(8);

				CyberArmy::User->Add(
					showname => $registration->[2], 
					prvemail => $registration->[0],
					passwd => $generate_password
				);

				if (my $user = CyberArmy::User
						->new(nickname => $registration->[1])) {
					$user->Log( type => 'joined',
						logby => 'bootcamp', msg => 'From '.$ip );
					$user->Update(addtogroup => $_)
						foreach ($r->dir_config->get('DEFAULT_GROUP'));

					CyberArmy::Template->instance->process(
						'bootcamp/welcome_email.tmpl', { 
							user => $user, password => $generate_password,
								server => $r->getServerLink()
						},\my $body
					);

					CyberArmy::Mail::Send(
						from => $r->dir_config('MAIL_FROM'),
						to => $registration,  body => $body,
						subject  =>  'Welcome to CyberArmy',
					);


					#Send message from Recruit Guidance Project leader

					#Only send if the project exists. Can't use proj_id as this will break other dinah installs, so use the name.
					my $project_name ="Recruit Guidance Project";
					my $project =$CyberArmy::Utils::Database::dbh->selectrow_hashref("select proj_id as id from projects where ".
 							     "proj_name = ?",undef,$project_name);

					if ($project->{id} ne ""){#project exists, send the cMS

						$project = CyberArmy::Projects->new($project->{id},
								'proj_id,proj_name,proj_brigade_parent,proj_desc,proj_type,proj_status,'.
								'proj_start,proj_end,proj_modified,proj_access,proj_invite,proj_img,proj_leader_access'
						);
						my $leader = $project->GetLeader();
						CyberArmy::Template->instance->process(
							'bootcamp/guidance_cms.tmpl', { 
								user => $user->showname,
								project => $project,
								leader => $leader
							},\my $message
						);
	
						CyberArmy::Message->new( 
							caID => [$user->caID], 
							user => $leader,
							subject => 'Welcome to CyberArmy',
							body => $message);
					}
					
					$db->do(
					'UPDATE join_reason_votes set user_caid=? WHERE nickname=? and user_caid IS NULL',
					undef,$user->caID,$user->nickname);
					

				} else { return 500 }
			}
			$r->printTemplate('bootcamp/welcome.tmpl', {email => $registration->[0]});
		} else {
			my $captcha = CyberArmy::WWW::Captcha->new();
			
			my $reasons = $CyberArmy::Utils::Database::dbh->prepare(
					"SELECT * From join_reasons order by reason asc"
					);
			$reasons->execute();
			my $reasonList = $reasons->fetchall_arrayref({});

			$r->printTemplate('bootcamp/recruiting.tmpl',{captcha=>$captcha, reasons => $reasonList});
		}
	}

	return 0;
}

1;
