#!perl -wW
package CyberArmy::User::Todo;

use CyberArmy::User;
use CyberArmy::Database;
use base qw(CyberArmy::User);

$__PACKAGE__::VERSION = '0.5';

sub CyberArmy::User::todoList {
	bless shift,__PACKAGE__;
}

sub add {
	my $db = CyberArmy::Database->instance;
	if ($_[1]) {
		if($_[2]){
			$db->do(
				'INSERT INTO user_todo (caID,date,task,group_id) VALUES (?,NOW(),?,?)',
				undef, $_[0]->caID, $_[1], $_[2]);
		}
		else{
			$db->do(
				'INSERT INTO user_todo (caID,date,task) VALUES (?,NOW(),?)',
				undef, $_[0]->caID, $_[1]);
		}
	} else { return undef }
}

sub del {
	my $db = CyberArmy::Database->instance;
	my $user = $_[0];
	my $id = $_[1];
	my $group = $_[2] || "user";
	if ($id) {
		$db->do(
			'DELETE FROM user_todo WHERE (caID = ? AND id = ? AND group_id= ?)',
			undef, $user->caID, $id, $group);
	} else { 
		#we only do a delete all for projects, primarily for when a user is discharged
		if($group ne "user"){
			$db->do(
				'DELETE FROM user_todo WHERE (caID = ? AND group_id = ?)',
				undef, $user->caID, $group);
		}
	} 

}

sub get {#used to get project, personal (user) or both types of ToDos defined by $_[1] or defaults to personal (user).
	my $group_id = ($_[1] && $_[1] eq "project") ? ' AND group_id != "user"'  : ($_[1] && $_[1] eq "all")? '' : ' AND group_id="user" ';
	my $orderByGroup = ($_[1] && $_[1] eq "all")? '' : 'group_id, ';
	my $order = $_[2] ? ' DESC' : '';
	my $limit = $_[3] ? ' LIMIT '.$_[3] : '';
	my $db = CyberArmy::Database->instance;
	my $gettodo = $db->prepare(
		'SELECT id,date,task,group_id FROM user_todo '.
		'WHERE caID = ? '.$group_id.
		'ORDER BY '.$orderByGroup.'date' .
		$order . $limit
	); $gettodo->execute($_[0]->caID) or return undef;
	my $todolist = $gettodo->fetchall_arrayref({});
	$gettodo->finish; return $todolist;
}

sub count {
	my $db = CyberArmy::Database->instance;
	my $gettodo = $db->prepare_cached(
		'SELECT COUNT(*) FROM user_todo '.
		'WHERE caID = ?'
	); $gettodo->execute($_[0]->caID) or return undef;
	my $count = $gettodo->fetchrow_array();
	$gettodo->finish; return $count;
}
1;
