#!perl -wW
package CyberArmy::User::Skills;

use CyberArmy::User;
use CyberArmy::Database;
use base qw(CyberArmy::User);

$__PACKAGE__::VERSION = '0.5';

sub CyberArmy::User::skillsSet {
	bless shift,__PACKAGE__;
}

sub set {
	my $db = CyberArmy::Database->instance;
	if ($_[1]) { ## verify the id is valid
		my $valid = $db->selectrow_arrayref(
				'SELECT name FROM skill WHERE id = ?',
		undef,$_[1]);

		if ($valid->[0]) {
			if ($_[2]) { ## if specified level, update
				$db->do(
					'REPLACE INTO user_skill VALUES (?,?,?)'
				,undef,$_[0]->caID,$_[1],$_[2]);
			} else { ## else, delete, if listed
				$db->do(
					'DELETE FROM user_skill WHERE '.
					'(user_id = ? AND skill_id = ?)'
				,undef,$_[0]->caID,$_[1]);			
			}
		} else { return undef }
	} else { return undef }
}

sub get {
	my $db = CyberArmy::Database->instance;
	my $getskill = $db->prepare(
		'SELECT skill.id as id,skill.name as name,skill_level.name as level FROM user_skill,skill,skill_level'.
		' WHERE (user_skill.user_id=? AND user_skill.skill_id=skill.id AND skill_level.id=user_skill.level_id)'.
		' ORDER BY skill_level.name'
	); $getskill->execute($_[0]->caID) or return undef;
	my $skills = $getskill->fetchall_arrayref({});
	$getskill->finish; return $skills;
}

1;
