#!perl -wW
package CyberArmy::Services::Mail;

#
# Mail Service API
#

use strict;
use CyberArmy::User;
use CyberArmy::Utils;
use CyberArmy::Database;

$CyberArmy::Services::Mail::VERSION = '0.1';

sub new {
	bless { id => $_[1] }
}

sub isSetup {
	my $db = CyberArmy::Database->instance;
	$db->selectrow_hashref(
		'SELECT * FROM mail WHERE id = ? LIMIT 1',undef,$_[0]->{'id'}
	);	
}

sub setAsForward {
	my $db = CyberArmy::Database->instance;
	$db->do(
		'UPDATE mail set forward = ? WHERE id = ?',
		undef,$_[1],$_[0]->{'id'}
	);
}

sub setAsMailbox {
	my $db = CyberArmy::Database->instance;
	
	my $info = $_[0]->isSetup();
	
	my $password = $_[1]->{'password'} ? crypt($_[1]->{'password'},
		CyberArmy::Utils::RandomAlphaNum(2)) : $info->{'password'};
	
	my $maildir = join('/',(reverse split(/\@/,$_[0]->{'id'}))).'/';
	my $date_limit = defined $_[1]->{'limit'} ? 
		'ADDDATE('.($info->{'date_limit'} ? $db->quote($info->{'date_limit'})
			: 'NOW()').',INTERVAL '.$_[1]->{'limit'}.')' : 'NULL';
	$_[1]->{'quota'} ||= 0;

	$db->do(
		'REPLACE INTO mail (id,caid,password,quota,maildir,date_limit)'.
		' VALUES (?,?,?,?,?,'.$date_limit.')',undef,
	$_[0]->{'id'},$_[1]->{'caid'},$password,$_[1]->{'quota'},$maildir);
}

sub purge {
	my $db = CyberArmy::Database->instance;
	$db->do('DELETE FROM mail WHERE id = ?',undef,$_[0]->{'id'});
}
