#!perl -wW
package CyberArmy::Missions;

use strict;
use CyberArmy::Utils;

$CyberArmy::Missions::VERSION = '0.2';

## Constructors

sub add {
	my $class = shift; my %tags = @_;

	$CyberArmy::Utils::Database::dbh->do(q~
		INSERT INTO mission ( state, author, author_caID, author_rank, category, 
		score, mtext, mdate ) VALUES ( 'on_wait', ?, ?, ?, ?, 100, ?, NOW() )~,undef,
	$tags{author},$tags{author_caID},$tags{author_rank},$tags{category},$tags{text}
	) or return undef;
}

sub new {
	my $class = shift; my %tags = @_;

	my $mission; if (!$tags{id}) { return undef }
	elsif ($tags{id} =~ /^\d+$/) {
		$mission = $CyberArmy::Utils::Database::dbh
		->selectrow_hashref(
			'SELECT * FROM mission WHERE id = ?'
		,undef,$tags{id}) or return undef;	
	} elsif ($tags{id} eq 'current') { 
		$mission = $CyberArmy::Utils::Database::dbh
		->selectrow_hashref(
			'SELECT * FROM mission WHERE state = ?'
		,undef,'current') or return undef;			
	} elsif ($tags{id} eq 'next') { 
		$mission = $CyberArmy::Utils::Database::dbh
		->selectrow_hashref(
			'SELECT * FROM mission WHERE state = ? ORDER BY id ASC LIMIT 0,1'
		,undef,'queued') or return undef;
	}

	bless $mission,$class;
}


sub getCategories {
	if ($_[1]) {
		return $CyberArmy::Utils::Database::dbh
		->selectrow_hashref(
			'SELECT name FROM mission_category WHERE id = ?'
		,undef,$_[1])
	} else {
		my $sth = $CyberArmy::Utils::Database::dbh
		->prepare_cached(
			'SELECT id,name FROM mission_category'
		); $sth->execute();
		return $sth->fetchall_hashref('id');
	}
}

sub listByStatus {
	shift; my %tags = @_;
	
	if ($tags{get}) {
		my $sth = $CyberArmy::Utils::Database::dbh
		->prepare(
			'SELECT * FROM mission WHERE state = ? ORDER BY id ASC'
		); $sth->execute($tags{state});
		return $sth->fetchall_arrayref({});
	} else {
		return $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(id) FROM mission WHERE state = ?'
		,undef,$tags{state})->[0];
	}
}

sub countByStatus {
	my $sth = $CyberArmy::Utils::Database::dbh
		->prepare(
			'SELECT state, count(*) as num_items FROM mission GROUP BY state'
		); $sth->execute();
	return $sth->fetchall_hashref('state');
}

###########################################################################################

## Delete Mission

sub Scrap {
	$CyberArmy::Utils::Database::dbh->do(
		'DELETE FROM mission WHERE id = ?',
	undef,$_[0]->{id}) or return undef;	
}

## Refresh Object

sub Refresh {
		my $mission = $CyberArmy::Utils::Database::dbh
		->selectrow_hashref(
			'SELECT * FROM mission WHERE id = ?'
		,undef,$_[0]->{id});

		foreach (keys %$mission) { $_[0]->{$_} = $mission->{$_} }
}

## Status Change

sub Status {
	if ($_[1] eq 'current' &&
			(my $current = new CyberArmy::Missions id=>'current')) {
		$current->Status('completed');

		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE mission SET mdate = NOW() WHERE id = ?',
		undef,$_[0]->{id}) or return undef;
	}
	
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE mission SET state = ? WHERE id = ?',
	undef,$_[1],$_[0]->{id}) or return undef;

	if ($_[1] eq 'completed' && 
			!CyberArmy::Missions->new(id=>'current')) {
		my $next = CyberArmy::Missions->new(id=>'next');
		$next->Status('current') if $next;
	}	
	
	$_[0]->Refresh;
}

## Vote/Scoring

sub Vote {
	return undef unless ($_[0]->{state} eq 'on_vote');

	$CyberArmy::Utils::Database::dbh->do(
		'INSERT INTO mission_vote (mission_id, author_caID, vdate) VALUES (?, ?, NOW())',
	undef,$_[0]->{id}, $_[1]) or return undef;

	my $score = $_[0]->{score} + ($_[2]);
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE mission SET score=? WHERE id=?',
	undef,$score,$_[0]->{id}) or return undef;

	if ( $score >= 1500) {
		if (CyberArmy::Missions->new(id=>'current')) {
			$_[0]->Status('queued')
		} else { $_[0]->Status('current') }
	} elsif ($score < 0) { $_[0]->Status('defeated') }

	$_[0]->Refresh; return 1;
}

sub Completed {
	return undef unless (($_[0]->{state} eq 'current' || $_[0]->{state} eq 'completed') && $_[1]);

	($CyberArmy::Utils::Database::dbh->do(
		'INSERT INTO mission_completed (mission_id, author_caID, cdate) VALUES (?, ?, NOW())',
	undef,$_[0]->{id}, $_[1])
	&&
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE mission SET completed = completed+1 WHERE id=?',
	undef,$_[0]->{id})) || return undef;

	$_[0]->Refresh; return 1;
}

sub HasVoted {
	return undef unless (($_[0]->{state} eq 'on_vote') && $_[1]);

	return $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(*) FROM mission_vote WHERE mission_id = ? AND author_caID = ?'
		,undef,$_[0]->{id},$_[1])->[0];
}

sub HasCompleted {
	return undef unless (($_[0]->{state} eq 'current' || $_[0]->{state} eq 'completed') && $_[1]);

	return $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(*) FROM mission_completed WHERE mission_id = ? AND author_caID = ?'
		,undef,$_[0]->{id},$_[1])->[0];
}

