#!/usr/bin/perl -w
package CyberArmy::Message;

use strict;
use CyberArmy::User;
use CyberArmy::Utils;

$CyberArmy::Message::VERSION = '0.5';

sub new {
    my $self = shift; my %tags = @_;
	if($tags{'mid'} && $tags{'replied'}){
		#mark msg as replied to
		my $sth1 = $CyberArmy::Utils::Database::dbh->prepare(q~
			UPDATE cMS set replied = "1" WHERE mid = ?
		~); $sth1->execute($tags{'mid'});
	} elsif($tags{'mid'} && $tags{'forwarded'}){
		#mark message as fwded
		my $sth2 = $CyberArmy::Utils::Database::dbh->prepare(q~
			UPDATE cMS set forwarded = "1" WHERE mid = ?
		~); $sth2->execute($tags{'mid'});		
	}
	if (!$tags{'from'} && $tags{'user'}) {
			my $attributes = $tags{'user'}->getAttributes('title_abrv');
        	$tags{from}[0] = $tags{'user'}->showname;  
        	$tags{from}[1] = join(' ',@{$attributes->{'title_abrv'}});
        }
        return undef unless ($tags{from} && $tags{subject} && $tags{body});

        my ($user,$query,@vid,@to,@failed);
        foreach ('caID','nickname','session_id','prvemail') {
			if ($tags{$_}) { my $key = $_;
				my %list = map {$_ => 1} @{$tags{$key}};
				foreach (keys %list) {
					if ($user = CyberArmy::User->new( $key => $_ , select => 'nickname' )) {
						push(@vid,$user->{fields}->{caID}); push(@to,$user->{fields}->{nickname});
					} else { push(@failed,$_) }
				}
			} else { next }
        }

	my $tolist = join ';',@to; my $failedlist = join ';',@failed if @failed;
        my $sth = $CyberArmy::Utils::Database::dbh->prepare(q~
        	INSERT INTO cMS (caID,rdate,sender_name,sender_rank,
			subject,body,tostring,folder,viewed,direction) VALUES (?,NOW(),?,?,?,?,?,?,?,?)
        ~); foreach (@vid) {
			$sth->execute($_,$tags{from}[0],$tags{from}[1],
				$tags{subject},$tags{body},$tolist,'inbox','n','incoming');
		}
		
		$sth->execute($tags{'user'}->caID,$tags{from}[0],$tags{from}[1],
			$tags{subject},$tags{body},$tolist,'sent','y','outgoing') if $tags{'user'};
		
	return $failedlist ? \$failedlist : 1  ; ## return the erroreus nicknames
} 


package CyberArmy::Message::Search;

use CyberArmy::Database;
use base qw(CyberArmy::Database::FetchIter);

sub new {
	my $class = shift;
	my $args = shift;

	my $db = CyberArmy::Database->instance();

	## Sanity Check
	return undef unless $args->{'terms'};

	my @opts;
	
	if( $args->{'caID'} ) {
		push @opts, 'caID = '.$db->quote($args->{'caID'});
	}

	if(($args->{'folder'} eq 'sent') || ($args->{'folder'} eq 'inbox')){
		push @opts, 'folder = '.$db->quote($args->{'folder'});
	}

	my @fields; ## Specify what fields are to be searched
	if ($args->{'in_msg'}) { push @fields, 'body' }
	if ($args->{'in_subjs'}) { push @fields, 'subject' }
	if ($args->{'in_auth'}) { push @fields,'sender_name','tostring' }
	return undef unless ($#fields > -1);

	my $opts = join (' AND ',@opts); $opts && ($opts .= ' AND ');
	my $sqlquery .= 'SELECT * FROM cMS WHERE '.$opts.' (';

	## Terms search	
	if ($args->{'match'} eq 'All') {
		my @terms = split / /,$args->{'terms'};
		my $j; foreach (@fields) {
			$j++; $sqlquery .= ' OR ' if ($j > 1);
			my $i; foreach my $term (@terms) { 
				$i++; my $term = $db->quote($term); $term =~ s/'(.*)'/'%$1%'/;
				$sqlquery .= "($_ like $term)";
				$sqlquery .= ' AND ' if ($i <= $#terms);
			}
		}

	} elsif ($args->{'match'} eq 'Any') {
		my @terms = split / /,$args->{'terms'};
		my $j; foreach (@fields) {
			$j++; $sqlquery .= ' OR ' if ($j > 1);
			my $i; foreach my $term (@terms) {
				$i++; my $term = $db->quote($term); $term =~ s/'(.*)'/'%$1%'/;
				$sqlquery .= "($_ like $term)";
				$sqlquery .= ' OR ' if ($i <= $#terms);
			}
		}

	} elsif ($args->{'match'} eq 'Exact') {
		my $i; foreach (@fields) { 
			$i++; my $term = $db->quote($args->{'terms'});
			$term =~ s/'(.*)'/'%$1%'/;
			$sqlquery .= "($_ like $term)";
			$sqlquery .= ' OR ' if ($i <= $#fields);
		}

	} else { return undef  }

	$sqlquery .= ')';

	##Date parameters
	if ($args->{'date'}) {
		if ($args->{'date'} eq 'before') {
			my $date = $args->{'year_1'}.'-'.
				$args->{'month_1'}.'-'.$args->{'day_1'};
			$sqlquery .= ' AND (rdate < '.$db->quote($date).')';
		} elsif ($args->{'date'} eq 'after') {
			my $date = $args->{'year_1'}.'-'.
				$args->{'month_1'}.'-'.$args->{'day_1'};
			$sqlquery .= ' AND (rdate > '.$db->quote($date).')';		
		} elsif ($args->{'date'} eq 'between') {
			my $date = $args->{'year_1'}.'-'.
				$args->{'month_1'}.'-'.$args->{'day_1'};
			my $date2 = $args->{'year_2'}.'-'.
				$args->{'month_2'}.'-'.$args->{'day_2'};
			$sqlquery .= ' AND (rdate > '.$db->quote($date).
						') AND (rdate < '.$db->quote($date2).') ';		
		}
	}

	## Final touch
	$sqlquery .= ' ORDER BY rdate DESC';

	## Limits?
	if ($args->{'num'} =~ /^\d+$/ && $args->{'num'} <= 100) {
		$sqlquery .= ' LIMIT 0,'.$args->{'num'};
	}
	
	## Finaly execute the query
	my $self = $db->prepare($sqlquery);

	$self->execute() ? 
		bless ($self,$class) : undef;
}

1;
