#!/usr/bin/perl -wW

package CyberArmy::Jabber::AuthDaemon;

## inspired/ported/ripped from  
## xdb_auth_cpile (Chris Pile - chris@snoogans.co.uk)

$|++;

use Sys::Syslog;
use Proc::Daemon;
use Proc::PID::File;

use Jabber::Connection 0.04;
use Jabber::NodeFactory;
use Jabber::NS qw(:all);

use CyberArmy::User;

$CyberArmy::Jabber::AuthDaemon::VERSION = '0.1';

$0 = 'CyberArmyJabberAuthDaemon/'.
	$CyberArmy::Jabber::AuthDaemon::VERSION;

Proc::Daemon::Init;

die "already running!\n" if Proc::PID::File->running( { name => 'dinah-jabber' } ); 

openlog('dinah-jabber', 'pid', 'daemon');

my $c = Jabber::Connection->new(
	server => 'localhost:5222',
	localname => 'xdb_auth_cyberarmy',
	ns => 'jabber:component:accept'
);

die $c->lastError unless $c->connect();
syslog('debug','connected to %s:%s',$c->{'host'},$c->{'host'});

# Handle kill signals
$SIG{'HUP'} = $SIG{'KILL'} = 
$SIG{'TERM'} = $SIG{'INT'} = \&_cleanup;

$c->register_handler('xdb', \&xdb);

# Authenticate against the server
$c->auth('secret');

# Start processing packets
$c->start;


sub _cleanup {
	$c->disconnect;
	exit(0);
}

sub xdb {
	my $node = shift;
	return unless($node->attr('ns') eq NS_AUTH);

	my ($user_id,undef) = split(/@/,$node->attr('to'),2);
	$node->attr('to', $node->attr('from'));
	$node->attr('from', $c->{'localname'});

	# For 'get's, we return an empty namespace,
	# flagging that they exist but a check action must be used
	if($node->attr('type') eq 'get') {
		$node->attr('type', IQ_RESULT);
		$node->insertTag('query', NS_AUTH);
	} elsif( defined($node->attr('action')) ) {
		## here comes the check action, where we do actual
		## auth via the cyberarmy api
		if($node->attr('type') eq 'set' && $node->attr('action') eq 'check') {
			my $pass = $node->getTag('password')->data;
			my $user = CyberArmy::User->new(
				nickname => $user_id , select => 'passwd,bantime'
			);
			if ($user && $user->Passhash($pass)) {
				if ($user->IsBanned()) {
					$node->attr('type', 'Account is banned!');
					syslog('info','%s is banned, denying',$user_id);					
				} else {
					$node->attr('type', IQ_RESULT);
					syslog('info','authentication sucessfull for %s',$user_id);
				}
			} else {
				$node->attr('type', IQ_ERROR);
				syslog('warning','authentication failed for %s',$user_id);
			}

			# remove the action attr
			$node->attr('action', '');

			# remove the password tag
			$node->getTag('password')->hide;
		}
	} elsif($node->attr('type') eq 'set') { ## trying the change their password
		my $pass = $node->getTag('password')->data;
		my $user = CyberArmy::User->new(nickname=>$user_id);
		if ($user->Update(passwd=>$pass)) {
			$node->attr('type', IQ_RESULT);
			syslog('info','password update for %s sucessfull',$user_id);
		} else {
			$node->attr('type', IQ_ERROR);
			syslog('info','password update for %s failed',$user_id);
		}
	} else {
		syslog('debug','event %s not handled',$node->attr('type'));
		$node->attr('type', IQ_ERROR); 
	}

  $c->send($node);
  return r_HANDLED;
}

1;
