#!perl -wW
package CyberArmy::Groupware;

use strict;

use CyberArmy::Database;

$CyberArmy::Groupware::VERSION = '0.1';


sub get {
	shift;
	my $db = CyberArmy::Database->instance();
	
	if ($#_ == 0) {
		$db->selectrow_hashref(
			'SELECT * FROM groupware WHERE id = ?',
		undef,$_[0]);
	} elsif ($#_ == 1) {
		my $getGroups = $db->prepare_cached(
			'SELECT * FROM groupware WHERE '.$_[0].' = ? ORDER BY name');
		$getGroups->execute($_[1]);
		my $groups = $getGroups->fetchall_arrayref({});
		$getGroups->finish();
		return $groups;		
	} else {
		my $getGroups = $db->prepare_cached(
			'SELECT * FROM groupware ORDER BY name');
		$getGroups->execute();
		my $groups = $getGroups->fetchall_arrayref({});
		$getGroups->finish();
		return $groups;
	}
}

sub getUsers {
	shift;
	my $group = shift or return undef;
	my $level = shift || 1;
	my $db = CyberArmy::Database->instance();

	my $getUsers = $db->prepare_cached('
		SELECT users.caID,nickname,showname FROM user_group
		LEFT JOIN users ON users.caID = user_group.caID
		WHERE group_id = ? AND level >= ?
		ORDER BY users.caID
	'); $getUsers->execute($group,$level);
	
	my $users = $getUsers->fetchall_arrayref({});
	$getUsers->finish;

	return $users;
}

sub set {
	my $db = CyberArmy::Database->instance();
	$db->do(
		'REPLACE INTO groupware '.
			'(id,name,priority,hitpoints,brigade,master,description,'.
			'deprecated_by,depends_on,add_title,add_title_abrv,add_badge,'.
			'add_role) '.
		'VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)',undef,
	$_[1]->{'id'},$_[1]->{'name'},$_[1]->{'priority'},$_[1]->{'hitpoints'},
	$_[1]->{'brigade'},$_[1]->{'master'},$_[1]->{'description'},
	$_[1]->{'deprecated_by'},$_[1]->{'depends_on'},$_[1]->{'add_title'},
	$_[1]->{'add_title_abrv'},$_[1]->{'add_badge'},$_[1]->{'add_role'}
	);
}

sub move {
	my $new_group = pop;
	my $old_group = pop;
	my $db = CyberArmy::Database->instance();

	## this sub is focused on moving *users*, 
	## NOT replacing into groupware

	$db->do( ## we don't really care if there is a clash
		'UPDATE IGNORE groupware SET id = ? WHERE id = ?',
	undef,$new_group,$old_group) 
		&& $db->do( ## get rid of the old one, if it sticks
			'DELETE FROM groupware WHERE id = ?',
		undef,$old_group);

	#$db->do('LOCK TABLE user_group WRITE');
		
	$db->do( ## reset the levels for the target group
		'UPDATE user_group SET level = 1 WHERE group_id = ?',
	undef,$new_group);
	
	if ( my $IDs_to_merge = join(',',
		@{$db->selectcol_arrayref( 
		'SELECT caID FROM user_group WHERE group_id = ?',
		{ Columns=>[1] },$old_group)}) 
	) { ## can SUBSELECTS in SELECT only
		$db->do(## if user exists in both groups,
				## wipe him from the target one
			'DELETE FROM user_group WHERE group_id = ? 
			 AND caID IN ('.$IDs_to_merge.')',
		undef,$new_group);
	}

	$db->do( ## then relocate the rest
		 ## this preserve the levels from the old group
		'UPDATE user_group SET group_id = ? WHERE group_id = ?',
	undef,$new_group,$old_group);
	
	#$db->do('UNLOCK TABLES');
}

sub wipe {
	$_[1] or return undef;

	CyberArmy::Database->instance->do(
		'DELETE FROM user_group WHERE group_id = ?'
	,undef,$_[1]);
}

sub del {
	$_[1] or return undef;

	my $db = CyberArmy::Database->instance();
	
	## make sure the group is empty before deleting it
	return undef if ($db->selectrow_array(
		'SELECT COUNT(*) FROM user_group WHERE group_id = ?'
	,undef,$_[1]));
	
	$db->do('DELETE FROM groupware WHERE id = ?',undef,$_[1]);
}
