#!perl -wW

package CyberArmy::Forum::FromMail;

## contains code/inspired from PostFromMail.pl by <chawmp@cyberarmy.net>

use strict;
use File::Spec();
use MIME::Parser();
use HTML::Entities();

use CyberArmy::Forum;
use CyberArmy::Database;

sub submit {
	shift; ## to fix some day
	my $parser = new MIME::Parser;
	$parser->output_under(File::Spec->tmpdir());
	
	my $data; if (my $entity = ($data = shift) ?
		$parser->parse_data($data) : $parser->parse(\*STDIN)) {

		my $filer = $parser->filer();
		## cleanup the temp dir
		## not sure why this isn't the default
		$filer->purgeable($filer->output_dir);
				
		$entity->make_multipart;
		$entity->sync_headers(Length=>'COMPUTE');
		
		my $head = $entity->head;
		chomp (my $to = $head->get('To',0));
		chomp (my $rdr = $head->get('X-Envelope-Recipient',0));
		chomp (my $cc = $head->get('Cc',0));
		chomp (my $from = $head->get('From',0));
		chomp (my $date = $head->get('Date',0));
		chomp (my $subject = $head->get('Subject',0));

		## optional internal use of Mail::SpamAssassin
		#eval 'require Mail::SpamAssassin'; unless ($@) {
		#	## duplicated parsing, needs to be fixed someday
		#	my $spamtest = Mail::SpamAssassin->new();
		#	my $mail = $spamtest->parse($entity->stringify());
		#	my $status = $spamtest->check( $mail );
		#	my $spam = $status->is_spam();
		#	$status->finish(); $mail->finish();
		#	if ($spam) {
		#		$filer->purge();
		#		return (undef,'spam from '.$from);
		#	}
		#}
		if (($head->get('X-Spam-Flag',0)||'') =~ /^YES/i) {
			return warn "Rejected message from $from (SPAM)\n";
		}

		my $fromname = $from; if ($fromname =~ /^(.*) <.*>$/) {
			$fromname = $1; $fromname =~ s/^"(.*)"$/$1/;
		}
		
		## try to guess the originating ip: *NOT* garanteed and *EASY* to forge
		my $ip = (($head->get('Received'))[-1] =~ ## needs to be improved
			/from.*\W(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\W/m) ? $1 : '';
		my $host = $ip ? gethostbyaddr(pack('C4',split(/\./,$ip)),2) : '';
	
		my $body = '';
		$body .= "[b]From[/b]: $from \n" if $from;
		$body .= "[b]To[/b]: $to \n" if $to;
		$body .= "[b]Cc[/b]: $cc \n" if $cc;
		$body .= "[b]Subject[/b]: $subject \n" if $subject;
		$body .= "[b]Date[/b]: $date \n" if $date;
		$body .= "\n";	
	
		my $warnings = '';
		foreach my $part (($entity->parts)) {
			unless ($part->mime_type =~ /^text\//) {
				my $phead = $part->head;
				$warnings .= "\n[b]Stripped Part[/b]: ".
					$phead->recommended_filename." (".$phead->mime_type.")";
				next;
			}
			if (my $io = $part->open("r")) { my $msg;
				while (defined($_ = $io->getline)) { $msg .= $_ }
				$io->close;
				
				if ($part->mime_type eq 'text/html') {
					require HTML::TreeBuilder;
					my $tree = HTML::TreeBuilder->new->parse($msg);
					require HTML::FormatText;
					$msg = HTML::FormatText->
						new(leftmargin => 0, rightmargin => 0)->format($tree);			
				}
				
				$body .= $msg."\n";
			}		
		} $filer->purge(); ## cleanup

		my $db = CyberArmy::Database->instance();
		$body = HTML::Entities::encode_entities($body.$warnings);

		## build the rcpt list, use a hash to avoid duplicates
		my %rcpt; foreach (split /,/, $to.($rdr?','.$rdr:'').($cc?','.$cc:'')){
			my $rcpt = (/^.* <(.*)>$/ || /^<(.*)>$/) ? $1 : $_;
			$rcpt =~ s/\s+//g; ## remove possible spaces
			$rcpt {$db->quote($rcpt)} = 1;
		}

		if (my @rcpt = keys(%rcpt)) {
			## depending on the to/cc list, if it's valid,
			## we reroute the message to the correct forums
			my $findForums = $db->prepare(
				'SELECT forum FROM forum_from_mail '.
					'WHERE mail IN ('.join(',',@rcpt).')'
			); $findForums->execute();
			while (my $row = $findForums->fetchrow_array) {
				if (my $forum = new CyberArmy::Forum (id => $row)) {		
					$forum->PostMessage(
						author => $fromname ? $fromname : $from,
						author_rank => 'Guest',
						author_ip => $ip,
						author_host => $host,
						subject => '[Mail] '.$subject,
						body => $body
					);
					print "Injected message from $from to $row";
				}
				return 0;
			}
		} else { warn 'no valid recipients' }
	} else { warn 'cannot parse' }
}

1;
