package CyberArmy::Forum;

use strict;
use CyberArmy::Utils;

$CyberArmy::Forum::VERSION = '0.4_9';
$CyberArmy::Forum::VoteLimit = '5';

sub GetCategories {
	my $cat = $CyberArmy::Utils::Database::dbh->prepare(
		'SELECT category,category_name FROM forum_categories'
		.' ORDER BY category_name '
	); $cat->execute();

	return $cat->fetchall_arrayref({});
}

sub getHeadlines {
	my (undef,$tags) = @_;
	my $limit = ($tags->{count} && $tags->{offset}) ? 'LIMIT '.$tags->{offset}.','.$tags->{count} :
		($tags->{count} ? 'LIMIT '.$tags->{count} : '');
	my $forums = "";
	if($tags->{forums})
	{
		$forums="AND forum_list.forum IN (".$tags->{forums}.") ";
	}
	
	if ($tags->{select}) { $tags->{select} =  ','.$tags->{select} }
	else {
		$tags->{select} = ',pid,subject,rdate,body,author,author_rank,'.
		'author_color,author_badge,icon,access_group,administrator,moderator';
	}
	
	my $getfp = $CyberArmy::Utils::Database::dbh->prepare('
		SELECT mid,rdate,forum_list.forum'.$tags->{select}.' FROM forum_replies '.
		'LEFT JOIN forum_list ON forum_replies.forum = forum_list.forum '.
		'WHERE frontpage IS NOT NULL '.$forums.' ORDER BY rdate DESC '.$limit
	); $getfp->execute; ## exec...

	return $getfp->fetchall_arrayref({}); ## fetchx0r	
}

sub getLatestMessages {
	my $args = pop;
	my $forum = exists $args->{'from'} ? $args->{'from'} : [];
	my $count = exists $args->{'count'} ? $args->{'count'} : 50;

	my $where_forum = '';
	$count = 0 unless ($count && $count=~ /^\d+$/);

	if ($#$forum >= 0) {
		my @forum = map {
			$CyberArmy::Utils::Database::dbh->quote($_)
		} @$forum;
		$where_forum = 'WHERE forum IN ('.join(',',@forum).')';
	}

	my $getMessages = $CyberArmy::Utils::Database::dbh->prepare('
		SELECT mid,pid,forum,subject,author_rank,author,
			DATE_FORMAT(rdate,"%Y-%m-%dT%H:%i:%s") As w3cdate
				FROM forum_replies '.$where_forum.' 
					ORDER BY rdate DESC LIMIT '.$count
	); $getMessages->execute();

	return $getMessages ->fetchall_arrayref({});
}


sub new {
	my $class = shift; my %tags = @_;

	$tags{select} ||= 'forum,name';
	my $forum = $CyberArmy::Utils::Database::dbh
	->selectrow_hashref(
		'SELECT '.$tags{select}.' FROM forum_list WHERE forum = ?'
	,undef,$tags{id}) or return undef;
	
	bless $forum,$class;
}

sub GetStickyList {
        my ($self,$number) = @_;

	## nb by chawmp: if >1 posts in a thread are marked sticky, only the highest
	## will show up as such, although all keep their sticky flag. this is by
	## comet's design, i think, but change below if other behaviour is desired :)

        my $GetSticky = $CyberArmy::Utils::Database::dbh
        ->prepare(
                'SELECT MIN(mid),thread,MAX(rdate) as max_rdate '.
                'FROM forum_replies '.
                'WHERE (forum = ? AND sticky)'.
                'GROUP BY thread '.
                'ORDER BY max_rdate DESC, thread DESC '.
                'LIMIT '.$number
                );$GetSticky->execute($self->{forum});
	return $GetSticky->fetchall_arrayref([0,1]);
}
sub GetThreadsList {
	my ($self,$number,$page,$sorted) = @_;

	my $skip = $page == 1 ? 0 : (($number * $page) - 50);
	if ($skip != int $skip) { $skip = int $skip; $skip++; }
	if ($sorted) {
		## Here we will select the lastest n threads by latest post
		my $GetThreads = $CyberArmy::Utils::Database::dbh
		->prepare(
			'SELECT MIN(mid),thread,MAX(rdate) as max_rdate '.
			'FROM forum_replies '.
			'WHERE forum = ? '.
			'GROUP BY thread '.
			'ORDER BY max_rdate DESC, thread DESC '.
			'LIMIT '.$skip.','.$number
		);$GetThreads->execute($self->{forum});

		return $GetThreads->fetchall_arrayref([0,1])
	} else {
		## Here we will select the lastest n threads for the given forum
		my $GetThreads = $CyberArmy::Utils::Database::dbh
		->prepare(
			'SELECT mid,thread '.
			'FROM forum_replies '.
			'WHERE (pid = 0 AND forum = ? ) '.
			'ORDER BY rdate DESC '.
			'LIMIT '.$skip.','.$number
		);$GetThreads->execute($self->{forum});
		return $GetThreads->fetchall_arrayref([0,1])
	}
}

sub GetPostsFromThreads {
	my ($self,$threads) = @_;
	
	my $GetReplies = $CyberArmy::Utils::Database::dbh->prepare(qq~
		SELECT mid,pid,subject,author_rank,author,author_color,
			author_badge,author_color,rdate,bold,sticky
		FROM forum_replies
		WHERE thread in ($threads)
		ORDER BY rdate DESC
	~); $GetReplies->execute; ## exec...

	return $GetReplies->fetchall_arrayref({}); ## fetchx0r
}

sub GetThreadsList2 {
	my ($self,$number,$page,$sorted) = @_;

	my $skip = $page == 1 ? 0 : (($number * $page) - 50);
	if ($skip != int $skip) { $skip = int $skip; $skip++; }

	## Here we will select the lastest n threads for the given forum
	my $GetThreads = $CyberArmy::Utils::Database::dbh
	->prepare(
		'SELECT thread, MIN(mid) AS min_mid, MAX(mid) as max_mid, '.
                '       COUNT(mid) as count_mid, MAX(rdate) as max_rdate '.
		'FROM forum_replies '.
		'WHERE forum = ? '.
		'GROUP BY thread '.
		($sorted ? 'ORDER BY max_rdate DESC, thread DESC ' : 'ORDER BY thread DESC ') .
		'LIMIT '.$skip.','.$number
	);$GetThreads->execute($self->{forum});
	
	return $GetThreads->fetchall_arrayref({});
}

sub GetPostsFromMids {
	my ($self,$mids) = @_;

	my $GetReplies = $CyberArmy::Utils::Database::dbh->prepare(qq~
		SELECT mid,pid,subject,author_rank,author,author_color,
			author_badge,author_color,rdate,bold,sticky
		FROM forum_replies
		WHERE mid in ($mids)
	~); $GetReplies->execute; ## exec...

	return $GetReplies->fetchall_arrayref({}); ## fetchx0r
}

sub getNumberOfPages {
	my $pages = ($_[0]->{'threads_num'}) / 50;
	return  ($pages  != int $pages ) 
		? int(++$pages) : $pages;
}

sub PostMessage {
	my $forum = shift;
	my %tags = @_; my $thread = 0;

	if ($tags{pid}) {
		my $parent = $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(q~
			SELECT thread,trail FROM forum_replies WHERE mid = ?~,
		undef,$tags{pid}) or return 0;
		
		$tags{thread} = $parent->[0];
		$tags{trail} = $parent->[1];
	} else {
		## Get the lastest thread ID
		my $last_thread_ID = $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(q~
			SELECT MAX(thread) FROM forum_replies
		~); ## WARNING ##, possible desyncs?
		$tags{thread} = $last_thread_ID->[0] +1; ## New Thread
		$tags{pid} = 0; $thread++;
		$tags{trail} = '';
	}	
	
	$CyberArmy::Utils::Database::dbh->do('
		INSERT INTO forum_replies (
			forum,thread,pid,author,author_caID,author_rank,
			author_color,author_ip,author_host,author_badge,subject,
			img_url,body,signature,bold,sticky,rdate
		) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'.
			($tags{'date'} ? '?' : 'NOW()').')',
		
		undef,$forum->{forum},$tags{thread},$tags{pid},$tags{author},
		$tags{author_caID},$tags{author_rank},$tags{author_color},
		$tags{author_ip},$tags{author_host},$tags{author_badge},
		$tags{subject},$tags{img_url},$tags{body},$tags{signature},
		$tags{bold},$tags{sticky},$tags{'date'}
	);
	## Warning : MySQL-specific !
	my $insertId = $CyberArmy::Utils::Database::dbh->{'mysql_insertid'};

	$tags{trail} .= _create_trail($insertId);

	$CyberArmy::Utils::Database::dbh->do(q~
		UPDATE forum_replies
		SET trail = ?
		WHERE mid = ?~,
		undef,$tags{trail},$insertId
	);

	if ($thread) { ##Update the stats
		$CyberArmy::Utils::Database::dbh->do(q~
			UPDATE forum_list
			SET threads_num = threads_num + 1, posts_num = posts_num + 1,
			    last_post_id=?, last_modified=NOW()
			WHERE forum = ?	~,
		undef,$insertId,$forum->{forum});
	} else {
		$CyberArmy::Utils::Database::dbh->do(q~
			UPDATE forum_list
			SET posts_num = posts_num + 1,
			    last_post_id=?, last_modified=NOW()
                        WHERE forum = ?~,
		undef,$insertId,$forum->{forum});
	}
	
	return $insertId;
}

####
# sub getRecentTopPosters
#
# Obtain stats of the top 10 posters over the last 30 days, ordered by number of posts
##
sub getRecentTopPosters {
	my $stats = $CyberArmy::Utils::Database::dbh->prepare(
				"SELECT nickname,showname,replies.posts FROM `users`, 
					(SELECT count(*) posts ,author_caid FROM `forum_replies` 
					   WHERE (TO_DAYS(NOW()) - TO_DAYS(rdate)) <=30 
					         AND author_rank NOT IN ('Editor', 'Author', 'Guest')
					   GROUP BY author_caid) replies 
				 WHERE replies.author_caid=users.caid 
				 ORDER BY posts DESC LIMIT 10");
	$stats->execute();
	$stats = $stats->fetchall_arrayref({});
	return $stats;

}

####
# sub getTopPosters
#
# Obtain stats of the top 10 posters ever, ordered by number of posts
##
sub getTopPosters {
	my $stats = $CyberArmy::Utils::Database::dbh->prepare(
				"SELECT nickname,showname,replies.posts FROM `users`, 
					(SELECT count(*) posts ,author_caid FROM `forum_replies` 
					   WHERE author_rank NOT IN ('Editor', 'Author', 'Guest')
					   GROUP BY author_caid) replies 
				 WHERE replies.author_caid=users.caid 
				 ORDER BY posts DESC LIMIT 10");
	$stats->execute();
	$stats = $stats->fetchall_arrayref({});
	return $stats;

}

sub _create_trail {
	my $insertId = shift;

	## The message trail consists of the concatenation of the inverse
	## in base 95 of all the message IDs, converted to the ASCII range
	## 33 .. 127 (which seems safe to sort in MySQL for default locales)

	## Purpose is to get back all messages of a thread in the "right" order
	## (= WWWBoard-style) by using "ORDER BY trail ASC" in the SQL query...

	## With 4 characters per message, this allows up to 81.450.625 messages
	## and a maximum thread depth of 63 when stored in a VARCHAR(255) field

	my @code;
	my $count = 0;
	foreach (33 .. 127) {
		$code[$count] = chr($_);
		$count++;
	}
	my $num = $count ** 4 - $insertId;
	# use the ASCII representation (33 .. 127) of the number in base 95
	my $string = '';
	while ($num > 1) {
		$string .= $code[$num % $count];
		$num = int($num / $count);
	}
	# pad with chr(33) to a maximum length of 4
	if (length($string) < 4) {
		$string .= chr(33) x (4 - length($string));
	}
	# reverse the whole thing and append to the trail
	return scalar reverse $string;
}


###########
# sub AddDisapprovalVote
#
# Casts a vote of disapproval on a forum post. If the post has 5 votes, moderators are alerted.
##
sub AddDisapprovalVote {
    my ($class, $post_id, $user) = @_;
    my $voteLimit = $CyberArmy::Forum::VoteLimit;
    if( $post_id && $user ){
    	my $db = CyberArmy::Database->instance;
		$db->do('INSERT INTO forum_reply_votes (message_id, user_caID) VALUES (?, ?)', 
			undef, $post_id, $user->caID);
    	
    	my $count= CyberArmy::Forum->CountDisapprovalVotes($post_id);
    	
    	if($count >= $voteLimit) {
			my $forum = CyberArmy::Forum->new( id=> 'moderation');
			my $message = CyberArmy::Forum::Message->new ( id => $post_id,
				select => 'pid,mid,forum,thread,subject,author_rank,author,rdate,trail'
			);			
			my $rank = "System";
			my $name = "Moderation";
			my $reason;
			if($forum){
				my ($body, $subject);
	    		if($count == $voteLimit) {	
					$subject = '[Alert] '.$message->{subject};
					$body = 'A post has been disapproved by the community (the disapproval'.
					' threshold is set to: '.$voteLimit.'):<br/><br/>'.
					'[url=/forum/'.$message->{forum}.'/messages/'.$post_id.'.html]View Post[/url]<br/><br/>'.
					'Please check this post and move it to the garbage bin if it is unsuitable. If you suspect the system (voting against posts) is being abused, please report this to the staff.'.
					'<br/><br/><small>If moderation does not have access to this post, please contact a staff member.</small>';
					
					$reason = 'Disapproval vote limit reached (limit: '.$voteLimit.')';	
			
					
	    		}
	    		elsif ($count % $voteLimit == 0){    	
	    			$subject = '[Follow-up Alert] '.$message->{subject};
					$body = 'The following post has been further disapproved by the community. The disapproval'.
					' threshold is set to: '.$voteLimit.', this post now has '.$count.' votes against it.<br/><br/>'.
					'[url=/forum/'.$message->{forum}.'/messages/'.$post_id.'.html]'.$message->{subject}.'[/url]<br/><br/>'.
					'Please check this post and move it to the garbage bin if it is unsuitable. If you suspect the system (voting against posts) is being abused, please report this to the staff.';
					
					$reason = 'Disapproval vote count reached multiple of voting limit (votes: '.$count.')';
	    		}
	    		if($reason) {
					my $action = 'report';
					$db->do('INSERT INTO log_forum 	(forum, action, thread_id, subject, author,'.
						' rdate, logby, logby_id, ldate, reason, votes) '.
						'VALUES (?,?,?,?,?,?,?,\'\',NOW(),?, ?)',undef,
						$message->{forum}, $action, $message->{mid}, $message->{subject},
						$message->{author_rank}.' '.$message->{author},$message->{rdate}, 
						$rank.' '.$name,$reason, $count);
					return ($forum->PostMessage( 
						author => $name,
						author_rank => $rank,
						subject => $subject,
						body => $body
					));	
	    		}
    		}
    		else {
    			#TODO: log the problem	
				my $action = 'warn';
				$reason = 'Failed to send notification to moderation indicating post disapproval vote count has reached the threshold';
				$db->do('INSERT INTO log_forum 	(forum, action, thread_id, subject, author,'.
					' rdate, logby, logby_id, ldate, reason, votes) '.
					'VALUES (?,?,?,?,?,?,?,\'\',NOW(),?, ?)',undef,
					$message->{forum}, $action, $message->{mid}, $message->{subject},
					$message->{author_rank}.' '.$message->{author}, $message->{rdate}, 
					$rank.' '.$name,$reason, $count);	
    		}	
    	}
    }
}

###########
# sub CountDisapprovalVotes
#
# Counts the number of votes of disapproval for a forum post. 
##
sub CountDisapprovalVotes {
    my ($class, $post_id) = @_;
    my $count = 0;
    if( $post_id ){
    	my $countArticles = $CyberArmy::Utils::Database::dbh->prepare("SELECT COUNT(*) FROM forum_reply_votes WHERE message_id=?");
    	$countArticles->execute($post_id) or return undef;	
		$count = $countArticles->fetchrow_array();   
    }
    return $count; 
}

###########
# sub HasVoted
#
# Counts the number of votes of disapproval for a forum post by a specific user.
##
sub HasVoted {
    my ($class, $post_id, $user) = @_;
    my $count = 0;
    if( $post_id ){
    	my $countArticles = $CyberArmy::Utils::Database::dbh->prepare("SELECT COUNT(*) FROM forum_reply_votes WHERE message_id=? AND user_caID=?");
   		$countArticles->execute($post_id, $user->caID) or return undef;	
		$count = $countArticles->fetchrow_array(); 
    }
    return $count;  


}


package CyberArmy::Forum::Message;

sub new {
	my $class = shift; my %tags = @_;

	$tags{select} ||= 'mid,pid,forum,thread';
	my $message = $CyberArmy::Utils::Database::dbh
	->selectrow_hashref(
		'SELECT '.$tags{select}.' FROM forum_replies WHERE mid = ?'
	,undef,$tags{id}) or return undef;
	
	bless $message,$class;
}

sub moveTo {
	my $message = shift;
	my $to_forum = shift;

	## move the thread to the selected forum
	my ($rows);
	if ($message->{'pid'} == 0) {
		my $move = $CyberArmy::Utils::Database::dbh
			->prepare('UPDATE forum_replies SET forum = ? WHERE thread = ?');

		$CyberArmy::Utils::Database::dbh->do(
			'LOCK TABLES forum_replies WRITE, forum_list WRITE');

		unless ($move->execute($to_forum,$message->{'thread'})) {
			$CyberArmy::Utils::Database::dbh->do('UNLOCK TABLES');
			return undef;
		}
		$rows = $move->rows; $move->finish;

	} else {
		my %is_in_my_tree; $is_in_my_tree{$message->{'mid'}}++;
		foreach (reverse @{$message->GetThread('mid,pid')}) {
			$is_in_my_tree{$_->{'mid'}}++
				if ($is_in_my_tree{$_->{'pid'}});
		}

		$CyberArmy::Utils::Database::dbh->do(
			'LOCK TABLES forum_replies WRITE, forum_list WRITE');

		## find a new thread id
		my $newtid = $CyberArmy::Utils::Database::dbh
			->selectrow_arrayref('SELECT MAX(thread) FROM forum_replies')->[0];
		$newtid++;

		my $move = $CyberArmy::Utils::Database::dbh->prepare(
			'UPDATE forum_replies SET forum = ?,thread = ? '.
			'WHERE mid IN ('.(join ',', (keys %is_in_my_tree)).')'
		);

		unless ($move->execute($to_forum,$newtid)) {
			$CyberArmy::Utils::Database::dbh->do('UNLOCK TABLES');
			return undef;
		}
		$rows = $move->rows; $move->finish;

		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE forum_replies SET pid = 0 WHERE mid = ?',
		undef,$message->{'mid'});

		## now i wanna reset the trails, if they spawn new replies
		## the trail would be handicaped by what it carries already
		## (i hope i'm getting this right)

		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE forum_replies SET trail = SUBSTRING(trail,(LENGTH("'.
			$message->{'trail'}.'") - 3)) WHERE thread = ?',
		undef,$newtid);
	}

	## refresh the indexes from where it is being moved from
	my $last_post = $CyberArmy::Utils::Database::dbh->selectrow_hashref(
		'SELECT MAX(mid) as max_mid FROM forum_replies WHERE forum = ?',
	undef,$message->{'forum'});
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE forum_list SET '.
		'last_modified = NOW(), '.
		(($message->{'pid'} == 0) ? 'threads_num = threads_num - 1, ' : '').
		'posts_num = posts_num - '.$rows.', '.
		'last_post_id = ? WHERE forum = ?'
	,undef,$last_post->{'max_mid'},$message->{'forum'});

	## refresh the indexes from where it is being moved to
	$last_post = $CyberArmy::Utils::Database::dbh->selectrow_hashref(
		'SELECT MAX(mid) as max_mid FROM forum_replies WHERE forum = ?'
	,undef,$to_forum);
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE forum_list SET '.
		'last_modified = NOW(), '.
		'threads_num = threads_num + 1, '.
		'posts_num = posts_num + '.$rows.', '.
		'last_post_id = ? WHERE forum = ?'
	,undef,$last_post->{'max_mid'},$to_forum);
	$CyberArmy::Utils::Database::dbh->do('UNLOCK TABLES');
}

sub GetForum { new CyberArmy::Forum ( id => $_[0]->{forum}, select => $_[1]) }

sub GetThread {
	my $GetThread = $CyberArmy::Utils::Database::dbh
	->prepare(
		'SELECT '.$_[1].' FROM forum_replies WHERE thread = ? '.
		'ORDER BY rdate DESC'
	); $GetThread->execute($_[0]->{thread}); ## Exec.
	
	return $GetThread->fetchall_arrayref({}); ## Fetch All..
	#$GetThread->finish; ## garbage collected
}

sub getPageNumber {

	my $numberOfPages = (($CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(*) FROM forum_replies '.
			'WHERE forum = ? AND pid = 0 AND mid > ?'
		,undef,$_[0]->{'forum'},$_[0]->{'mid'}
	)->[0]) / 50);

	return (int($numberOfPages) == $numberOfPages) ?
		$numberOfPages : int(++$numberOfPages);
}

sub setAsHeadline {
	return undef unless ($_[0]->{'pid'} == 0); ## only main threads
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE forum_replies SET frontpage = \'Y\' '.
		'WHERE mid = ?',undef,$_[0]->{'mid'}
	);
}

sub unsetAsHeadline {
	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE forum_replies SET frontpage = NULL '.
		'WHERE mid = ?',undef,$_[0]->{'mid'}
	);	
}



42;
