#!perl -wW
package CyberArmy::Banner;

#
# Banners API
#

use strict;

$CyberArmy::Banner::VERSION = '0.5.5';

use CyberArmy::Utils;

my @jack = qw /1 2 1 3 1 2 1 1 2 1/;

sub add {
	return undef unless ($_[1]->{'caption'} and $_[1]->{'url'});

	foreach (qw(priority credits)) {
		delete $_[1]->{$_} unless 
			defined ($_[1]->{$_}) && $_[1]->{$_} =~ /^\d+$/;
	}
	
	if ($_[1]->{'id'}) {
		($CyberArmy::Utils::Database::dbh->do(
			'UPDATE banner SET caption=?,url=?,priority=?,credits=? WHERE id = ?'
		,undef,$_[1]->{'caption'},$_[1]->{'url'},$_[1]->{'priority'}
		,$_[1]->{'credits'},$_[1]->{'id'}) && 
		$CyberArmy::Utils::Database::dbh->do(
			'DELETE FROM banner_image WHERE banner_id=?'
		,undef,$_[1]->{'id'})) or return undef;
	} else {
		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO banner (caption,url,priority,credits) '.
			'VALUES (?,?,?,?)',undef,$_[1]->{'caption'},$_[1]->{'url'},
			$_[1]->{'priority'},$_[1]->{'credits'}) or return undef;
	}

	my $id = $_[1]->{'id'} || $CyberArmy::Utils::Database::dbh->{'mysql_insertid'};
	
	foreach (@{$_[1]->{'images'}}) {
		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO banner_image (banner_id,image) VALUES (?,?)'
		,undef,$id,$_);
	}
	
	return $id;
}

sub list {
	my $getBanners = $CyberArmy::Utils::Database::dbh
		->prepare('SELECT * from banner ORDER BY id');
	
	$getBanners->execute();
	my $banners = $getBanners->fetchall_arrayref({});
	$getBanners->finish();
	
	#my $getImages = $CyberArmy::Utils::Database::dbh
	#	->prepare('SELECT * from banner_image');
	#$getImages->execute(); my $img;
	#while ($img = $getImages->fetchrow_arrayref()) {
	#	push @{$banners->{$img->[0]}->{'images'}}, $img->[1];
	#}
	#$getImages->finish;

	return $banners;
}

sub new {
	my $banner;
	
	if ($_[1]->{'id'}) { ## specified ID
		$banner = $CyberArmy::Utils::Database::dbh->selectrow_hashref(
			'SELECT * FROM banner LEFT JOIN banner_image '.
			'ON banner_id = id WHERE id = ? ORDER BY RAND() LIMIT 1',
		undef,$_[1]->{'id'}) or return undef;
	} else { ## else get a random banner
		my @order = $jack[int rand $#jack]; ## priorities
		if ($order[0] == 1) { $order[1] = 2; $order[2] = 3; }
		elsif ($order[0] == 2) { $order[1] = 1; $order[2] = 3; }
		elsif ($order[0] == 3) { $order[1] = 1; $order[2] = 2; }
		else { return undef } ## huh?
		
		$banner = $CyberArmy::Utils::Database::dbh->selectrow_hashref(
			'SELECT id,caption FROM banner WHERE priority IS NOT NULL '.
			'AND (credits IS NULL OR credits > 0) ORDER BY IF(priority= '.
			join(',',@order).'),RAND() LIMIT 1'
		) or return undef;
		
		my $image = $CyberArmy::Utils::Database::dbh->selectrow_arrayref(
			'SELECT image from banner_image WHERE banner_id = ? '.
			'ORDER BY RAND() LIMIT 1',
		undef,$banner->{'id'}) or return undef;
		
		$banner->{'image'} = $image->[0];
	}
	
	bless($banner,$_[0]);
}

sub remove {
	$CyberArmy::Utils::Database::dbh->do(
		'DELETE FROM banner WHERE id = ?'
	,undef,$_[0]->{'id'});
	
	$CyberArmy::Utils::Database::dbh->do(
		'DELETE FROM banner_image WHERE banner_id = ?'
	,undef,$_[0]->{'id'});	
}

sub getImages {
	my $getImages = $CyberArmy::Utils::Database::dbh
		->prepare('SELECT image from banner_image WHERE banner_id = ?');	
	$getImages->execute($_[0]->{'id'});
	my $images = $getImages->fetchall_arrayref();
	$getImages->finish;
	return $images;
}

sub _initStatistics {
	$CyberArmy::Utils::Database::dbh->do(
		'INSERT INTO banner_statistics (id,day) VALUES (?,NOW())'
	,undef,$_[0]->{'id'})
}

sub setViewed {
	if ( $CyberArmy::Utils::Database::dbh->do(
		'UPDATE banner_statistics set views = views + 1 '.
			'WHERE id = ? AND day = NOW()',undef,$_[0]->{'id'}) == 1) {

		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE banner SET credits = credits - 1 '.
				'WHERE id = ? AND credits IS NOT NULL',
		undef,$_[0]->{'id'});

	} else { $_[0]->_initStatistics && $_[0]->setViewed;  }
}

sub setClicked {
	unless ( $CyberArmy::Utils::Database::dbh->do(
		'UPDATE banner_statistics set clicks = clicks + 1 '.
			'WHERE id = ? AND day = NOW()',undef,$_[0]->{'id'}) == 1) {
		$_[0]->_initStatistics && $_[0]->setClicked;
	}
}

sub setCredits {
	if ($_[1] && $_[1] =~ /^(?:\+|\-)\d+$/) {
		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE banner SET credits = credits '.
			$_[1].' WHERE id = ?',undef,$_[0]->{'id'}
		);
	} else {
		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE banner SET credits = NULL '.
			'WHERE id = ?',undef,$_[0]->{'id'}
		);
	}
}

sub getStatistics {
	foreach ($_[1]->{'year'},$_[1]->{'month'},$_[1]->{'day'} ) { 
			$_ and (/^\d+$/ or return undef) ## verify they are all valid
	}
	
	my @day;
	
	if ($_[1]->{'year'}) {
		push (@day,'YEAR(day) ='.$_[1]->{'year'});
		if ($_[1]->{'month'}) {
			push (@day,'MONTH(day) = '.$_[1]->{'month'});
			if ($_[1]->{'day'}) {
				push (@day,'DAYOFMONTH(day) = '.$_[1]->{'day'});
			}
		}
	} elsif ($_[1]->{'month'}) {
		push (@day,'YEAR(day) = YEAR(NOW())');
		push (@day,'MONTH(day) = '.$_[1]->{'month'});
		if ($_[1]->{'day'}) {
			push (@day,'DAYOFMONTH(day) = '.$_[1]->{'day'});
		}
	}elsif ($_[1]->{'day'}) {
		push (@day,'YEAR(day) = YEAR(NOW())');
		push (@day,'MONTH(day) = MONTH(NOW())');
		push (@day,'DAYOFMONTH(day) = '.$_[1]->{'day'});
	} else { @day = ('day = NOW()'); }

	my $getStats = $CyberArmy::Utils::Database::dbh->prepare(
		'SELECT banner.id AS id,caption,priority,'.
		'sum(views) AS views,sum(clicks) AS clicks '.
		'FROM banner LEFT JOIN banner_statistics USING (id) '.
		'WHERE '.join(' AND ',@day).' GROUP BY caption ORDER BY banner.id'
	); $getStats->execute;
	
	my $statistics = $getStats->fetchall_arrayref({}); $getStats->finish;
	
	return $statistics;
}
	
1;
