package CyberArmy::BBCode;

my $tags = 'color|colour|url|email|img|quote|list|name|rtl'; #forgot to add #name at first, didnt work :((( - Icy
my $simpletags = 'b|u|i|big|small|center';
#addition 2008-9-29: rtl tag (right to left)
sub clean {
	while ($_[0] =~ s/\[($tags|$simpletags|code)(|=.*?)\](.*?)\[\/\1\]/$3/iseg){}
}
sub code {
	my $body = $_[0];
	$body =~ s#^\s*\n## if $body;
	$body =~ s!\n\s*$!! if $body;
	$body =~ s#\n#<NBRK2>#g if $body;
	$body =~ s#\[#<NOBB>#g if $body;
	$body =~ s#\]#<\/NOBB>#g if $body;
	return "<NBRK><pre class=\"code\">$body</pre><NBRK>";
}
sub apply {
	my $list = $_[1] ? join('|', grep(!/^code$/, @{$_[1]})) : $tags;

	# do [code]..[/code] first to prevent bbcode being resolved in those blocks
	if (!$_[1] || grep(/^code$/, @{$_[1]})) {
		while ($_[0] && $_[0] =~ s/\[code\](.+?)\[\/code\]/code($1)/iseg) {}
	}
	while ($_[0] && $_[0] =~ s/\[($list)(?:|=([^[]+?))\](.+?)\[\/\1\]/ReplaceTags($1,$2 ? $2:'',$3)/oiseg) {}
	while ($_[0] && $_[0] =~ s/\[($simpletags)\](.+?)\[\/\1\]/<$1>$2<\/$1>/oisg) {}

	# Perform final formatting adjustments	
	$_[0] =~ s/<NULL>//gs if $_[0];
	$_[0] =~ s/<NOBB>/\[/gs if $_[0];
	$_[0] =~ s/<\/NOBB>/\]/gs if $_[0];
	$_[0] =~ s/\s*<NBRK>\s*/<NBRK>/gs if $_[0];
	$_[0] =~ s/\n{2,}/<br><br>/gs if $_[0];
}

sub Parse {
	&apply;
	$_[0] =~ s/\n/<br>\n/gs if $_[0];
	$_[0] =~ s/<NBRK(|2)>/\n/gs if $_[0];
	return $_[0];
}

sub SafeLink {
	$_[0] =~ tr/\n//d;
	$_[0] = Apache::Util::escape_uri($_[0]);
	$_[0] =~ s/^(?:javascript:)+/_NASTY_/i;
	$_[0] =~ s/^(?:vbscript:)+/_I_AM_A_CUNT/i;
	$_[0] =~ s/^view-source:/_NASTY_/i
		if $_[1]; ## HACK: only for image links (via SafeImg)
	$_[0] = Apache::Util::unescape_uri($_[0]);
	$_[0] =~ s/^http\w??:\/\/$ENV{'SERVER_NAME'}\/(.*)/\/$1/
		if $ENV{'SERVER_NAME'}; ## HACK! (mostly for ssl)
	return $_[0];
}

sub SafeImg {
	return SafeLink($_[0], 1);
}

sub ReplaceTags {
	my ($intag, $param, $body) = @_;

	$intag = lc($intag);
	if ($body =~ /^\s+$/) {
		return ("[<NULL>$intag" . ($param ? "=$param" : "") . "][/<NULL>$intag]");
	}
	
	my $result;

	if ($intag =~ /^(url|email)$/) {
		my $mailto = ($intag eq 'url') ? '' : 'mailto:';
		if ($param eq '') {
			$result = "<a class=\"mark\" href=\"$mailto" . SafeLink($body) .
				"\">$body</a>";
		} else {
			$result = "<a class=\"mark\" href=\"$mailto" . SafeLink($param) .
				"\">$body</a>";
		}
	} elsif ($intag eq 'name') {
			$result = "<a name=\"" . SafeLink($param) . "\">" . SafeLink($body) . "</a>";
	} elsif ($intag eq 'rtl') {
			$result = "<div style=\"direction: rtl\"><p>" . SafeLink($body) . "</p></div>";
  } elsif ($intag eq 'img') {
		if ($param eq '') {
			$result = "<img src=\"" . SafeImg($body) . "\">";
		} else {
			# Hack to take BBCode tags that would end up inside the
			# alt text outside again (inc. already-parsed html tags)
			my $prefix = '';
			$prefix .= $1 while ($body =~ s/([\[<].*?[\]>])//s);
			$result = $prefix . "<img src=\"" . SafeImg($param) .
				"\" alt=\"$body\">";
		}
	} elsif ($intag eq 'quote') {
		$result = "<NBRK><blockquote>$body</blockquote><NBRK>";
	} elsif ($intag =~ /^colo(|u)r$/) {
		$result = '<font color="'.SafeLink($param)."\">$body</font>";
	} elsif ($intag eq 'list') {
		$body =~ s/\n//gs;
		if ($body =~ s/\[\*\]/<li>/s) {
			$body .= '</li>' if ($body =~ s/\[\*\]/<\/li><li>/gs);
		}
		if ($param eq '') {
			$result = "<NBRK><ul><NBRK>$body</ul><NBRK>";
		} else {
			$param = '1' if ($param !~ /^[1AaIi]$/);
			$result = "<NBRK><ol type=\"$param\"><NBRK>$body</ol><NBRK>";
		}
	}
	return $result;
}
