Array.prototype.indexOf = function (o) {
        for (var i = 0; i < this.length; ++i) {
            if (this[i] == o) {
                return i;
            }
        }
        return -1;
    }; 
    
function min_panel(section, pname){
    hide_panel(section, pname);
    addItem(section, pname);
}
function hide_panel(section, pname){
    var p,m,r;
    p = document.getElementById(pname + "content");
    m = document.getElementById(pname + "min");
    r = document.getElementById(pname + "res");
    
    if(p && m && r){
        p.style.display="none";
        m.style.display="none";
        r.style.display="inline";
    }
}
function show_panel(section, pname){
    var p,m,r;
    p = document.getElementById(pname + "content");
    m = document.getElementById(pname + "min");
    r = document.getElementById(pname + "res");
    
    if(p && m && r){
        p.style.display="block";
        m.style.display="inline";
        r.style.display="none";
    }
}
function res_panel(section, pname){
    show_panel(section, pname);
    delItem(section, pname);
}
/*
 * Add selected item to cookie to remember to
 * minimise it on subsequent visits
 */
function addItem(cookieName, item)
{
	if(cookieName.length>0 && item.length>0)
	{
		var items = readCookie(cookieName);
		if(items==null)
			items="";
                if(items.indexOf(item)>-1)
                        return;
		items =items.length>0 ? items+":"+item : item;
		createCookie(cookieName, items, 365);
	}
}
function delItem(cookieName, item)
{
	var items = readCookie(cookieName);
	//find item	
	var theItems=items.split(":");
	theItems.splice(theItems.indexOf(item), 1);
	items = theItems.join(":");
	createCookie(cookieName, items, 365);
}
function setup_panel(cookieName, item)
{
	var items = readCookie(cookieName);
	//find item	
	if(items==null) return;
	if(items.indexOf(item)>-1)
	{
		hide_panel(cookieName, item);
	}
	//shows by default, no action necessary

}
function change_panel(cookieName, item)
{
	var items = readCookie(cookieName);
	//find item	
	if(items!=null && items.indexOf(item)>-1)
	{
		res_panel(cookieName, item);
	}
	else
	{
		min_panel(cookieName, item);
	}

}
function createCookie(name, value, days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}

/**
 * Gets the value of the specified cookie.
 *
 * name  Name of the desired cookie.
 *
 * Returns a string containing value of specified cookie,
 *   or null if cookie does not exist.
 */
function readCookie(name) {
    var dc = document.cookie;
    var prefix = name + "=";
    var begin = dc.indexOf("; " + prefix);
    if (begin == -1) {
        begin = dc.indexOf(prefix);
        if (begin != 0) return null;
    } else {
        begin += 2;
    }
    var end = document.cookie.indexOf(";", begin);
    if (end == -1) {
        end = dc.length;
    }
    return unescape(dc.substring(begin + prefix.length, end));
}

function fixCookie(name) {
    var cookie = readCookie(name);
    if(cookie==null) return;
    var old_items = cookie.split(":").sort();
    if(old_items.length == 0) return;
    var new_items = new Array(old_items[0]);

    for(var i=1; i<old_items.length; i++){
        if(old_items[i-1] == old_items[i]) continue;
        new_items.push(old_items[i]);
    }
    createCookie(name, new_items.join(":"), 365);
}

fixCookie("my");

