//EVENT LISTENERS
function addLoadListener(fn)
{
	if (typeof window.addEventListener != 'undefined')
	{
		window.addEventListener('load', fn, false);
	}
	else if (typeof document.addEventListener != 'undefined')
	{
		document.addEventListener('load', fn, false);
	}
	else if (typeof window.attachEvent != 'undefined')
	{
		window.attachEvent('onload', fn);
	}
	else
	{
		return false;
	}
	
	return true;
};




function attachEventListener(target, eventType, functionRef, capture)
{
    if (typeof target.addEventListener != "undefined")
    {
        target.addEventListener(eventType, functionRef, capture);
    }
    else if (typeof target.attachEvent != "undefined")
    {
        target.attachEvent("on" + eventType, functionRef);
    }
    else
    {
        return false;
    }

    return true;
};


attachEventListener(window, "resize", checkBrowserWidth, false);




function checkBrowserWidth()
{
	var theWidth = getBrowserWidth();
	
	if (theWidth == 0)
	{
		var resolutionCookie = document.cookie.match(/(^|;)cyberarmy_css[^;]*(;|$)/);

		if (resolutionCookie != null)
		{
			setStylesheet(unescape(resolutionCookie[0].split("=")[1]));
		}
		
		addLoadListener(checkBrowserWidth);
		
		return false;
	}

	if (theWidth > 1220)
	{
		setStylesheet("1280 x 1024");
		document.cookie = "cyberarmy_css=" + escape("1280 x 1024")+"; path=/";
		var res = document.getElementById('res');
		if(res)
			res.innerHTML = '| ';
	}
	else if (theWidth > 1000)
	{
		setStylesheet("1024 x 768");
		document.cookie = "cyberarmy_css=" + escape("1024 x 768")+"; path=/";
		var res = document.getElementById('res');
		if(res)
			res.innerHTML = '| ';
	}
	else
	{
		setStylesheet("800 x 600");
		document.cookie = "cyberarmy_css="+"; path=/";
		var res = document.getElementById('res');
		if(res)
			res.innerHTML = '<br/>';
	}
	
	return true;
};




function getBrowserWidth()
{
	if (window.innerWidth)
	{
		return window.innerWidth;
	}
	else if (document.documentElement && document.documentElement.clientWidth != 0)
	{
		return document.documentElement.clientWidth;
	}
	else if (document.body)
	{
		return document.body.clientWidth;
	}
	
	return 0;
};




function setStylesheet(styleTitle)
{
	var currTag;

	if (document.getElementsByTagName)
	{
		for (var i = 0; (currTag = document.getElementsByTagName("link")[i]); i++)
		{
			if (currTag.getAttribute("rel").indexOf("style") != -1 && currTag.getAttribute("title"))
			{
				currTag.disabled = true;

				if(currTag.getAttribute("title") == styleTitle)
				{
					currTag.disabled = false;
				}
			}
		}
	}
	
	return true;
};

//set style for browser size
checkBrowserWidth();