-- MySQL dump 10.9
--
-- Host: localhost    Database: cyberarmy
-- ------------------------------------------------------
-- Server version	4.1.11
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;

/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

--
-- Table structure for table `accomplishments`
--

DROP TABLE IF EXISTS `accomplishments`;
CREATE TABLE `accomplishments` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(32) default NULL,
  `imageurl_before` varchar(255) default NULL,
  `imageurl_after` varchar(255) default NULL,
  `short_desc` varchar(1024) default NULL,
  `long_desc` varchar(4096) default NULL,
  `can_see_acl` varchar(128) default NULL,
  `can_award_acl` varchar(128) default NULL,
  `idempotent` tinyint(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `accomplishments_categories`
--

DROP TABLE IF EXISTS `accomplishments_categories`;
CREATE TABLE `accomplishments_categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(32) default NULL,
  `displayname` varchar(32) default NULL,
  `short_desc` varchar(512) default NULL,
  `can_see_acl` varchar(128) default NULL,
  `can_award_acl` varchar(128) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `accomplishments_earned`
--

DROP TABLE IF EXISTS `accomplishments_earned`;
CREATE TABLE `accomplishments_earned` (
  `id` int(11) NOT NULL auto_increment,
  `caid` int(11) NOT NULL,
  `acc_id` int(11) NOT NULL,
  `progress` char(1) default NULL,
  `status` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `accomplishments_link_category`
--

DROP TABLE IF EXISTS `accomplishments_link_category`;
CREATE TABLE `accomplishments_link_category` (
  `acc_id` int(11) default NULL,
  `category_id` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `accomplishments_noted`
--

DROP TABLE IF EXISTS `accomplishments_noted`;
CREATE TABLE `accomplishments_noted` (
  `id` int(11) NOT NULL default '0',
  `earned_id` int(11) NOT NULL,
  `awarded_by` int(11) default NULL,
  `date_noted` datetime default NULL,
  `note` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `article`
--

DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
  `id` INT( 10 ) unsigned NOT NULL AUTO_INCREMENT,
  `date_submitted` DATETIME NOT NULL ,
  `date_released` DATETIME NOT NULL ,
  `category` VARCHAR( 255 ) NOT NULL ,
  `project_id` INT( 6 ) unsigned NULL,
  `status` ENUM( 'draft', 'publication-only', 'review', 'live', 'deleted' ) NOT NULL ,
  `author_caID` INT( 7 ) UNSIGNED ZEROFILL NOT NULL ,
  `title` VARCHAR( 255 ) NOT NULL ,
  `summary` TINYTEXT ,
  `body` TEXT NOT NULL ,
  `total_rating` INT( 10 ) NOT NULL ,
  `num_votes` INT( 10 ) NOT NULL ,
  `admin_thread` INT( 10 ) NOT NULL DEFAULT '0',
  `public_thread` INT( 10 ) NULL DEFAULT '0',
  `language_id` INT( 6 ) unsigned NULL,
  `imported_from` VARCHAR( 255 ),  
  `original_author` VARCHAR( 255 ),  
  `imported_id` INT(4),
  PRIMARY KEY (`id`),
  KEY `caID` (`author_caID`),
  KEY `id` (`project_id`),
  KEY `ind_category_status` (`category`, `status`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `category_resource`
--

DROP TABLE IF EXISTS `category_resource`;
CREATE TABLE `category_resource` (
  `id` INT( 10 ) unsigned NOT NULL AUTO_INCREMENT,
  `date_added` DATETIME NOT NULL ,
  `category` VARCHAR( 255 ) NOT NULL ,
  `url` varchar(250) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` TEXT,
  PRIMARY KEY (`id`),
  KEY `ind_category_id_url` (`category`,`id`,`url`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `article_category`
--

DROP TABLE IF EXISTS `article_category`;
CREATE TABLE `article_category` (
  `id` INT( 3 ) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` INT( 3 ) NOT NULL ,
  `title` VARCHAR( 255 ) NOT NULL ,
  `description` TINYTEXT NOT NULL,
  `archived` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `article_votes`
--

DROP TABLE IF EXISTS `article_votes`;
CREATE TABLE `article_votes` (
  `user_caID` INT( 7 ) UNSIGNED NOT NULL,
  `article_id` INT( 10 ) NOT NULL ,
  `vote` INT( 1 ) NOT NULL,
  UNIQUE KEY `vote_key` (`user_caID`,`article_id`),
  KEY `caID` (`user_caID`),
  KEY `id` (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `banner`
--

DROP TABLE IF EXISTS `banner`;
CREATE TABLE `banner` (
  `id` int(3) unsigned NOT NULL auto_increment,
  `priority` tinyint(1) unsigned default NULL,
  `caption` tinytext NOT NULL,
  `url` varchar(250) NOT NULL default '',
  `credits` int(6) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url` (`url`),
  KEY `credits` (`credits`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `banner_image`
--

DROP TABLE IF EXISTS `banner_image`;
CREATE TABLE `banner_image` (
  `banner_id` int(3) NOT NULL default '0',
  `image` varchar(250) NOT NULL default '',
  UNIQUE KEY `image` (`banner_id`,`image`),
  KEY `banner_id` (`banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `banner_statistics`
--

DROP TABLE IF EXISTS `banner_statistics`;
CREATE TABLE `banner_statistics` (
  `id` int(3) unsigned NOT NULL default '0',
  `day` date NOT NULL default '0000-00-00',
  `views` int(10) unsigned NOT NULL default '0',
  `clicks` int(10) unsigned NOT NULL default '0',
  UNIQUE KEY `id_day` (`id`,`day`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `brigades`
--

DROP TABLE IF EXISTS `brigades`;
CREATE TABLE `brigades` (
  `brigade_id` int(6) unsigned NOT NULL auto_increment,
  `brigade_parent` int(6) unsigned NOT NULL default '0',
  `brigade_chain` varchar(250) default NULL,
  `brigade_name` varchar(100) NOT NULL default '',
  `brigade_acr` varchar(10) default NULL,
  `brigade_description` text,
  `brigade_color` varchar(15) default NULL,
  `brigade_hex_color` varchar(7) default NULL,
  `brigade_url` varchar(100) default NULL,
  `brigade_joinmode` enum('O','R','A') default NULL,
  `brigade_recruiting` enum('O','C') NOT NULL default 'O',
  `brigade_application` tinytext,
  `brigade_invite` varchar(100) default NULL,
  `brigade_projac` enum('y','n') default 'y',
  PRIMARY KEY  (`brigade_id`),
  UNIQUE KEY `name` (`brigade_name`,`brigade_color`,`brigade_hex_color`),
  KEY `acro` (`brigade_acr`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `cMS`
--

DROP TABLE IF EXISTS `cMS`;
CREATE TABLE `cMS` (
  `mid` int(8) unsigned NOT NULL auto_increment,
  `folder` varchar(30) NOT NULL default 'inbox',
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `sender_name` varchar(25) NOT NULL default '',
  `sender_rank` varchar(50) default NULL,
  `subject` varchar(40) NOT NULL default '',
  `body` mediumtext NOT NULL,
  `viewed` enum('y','n') default 'n',
  `tostring` mediumtext,
  `sticky` int(1) NOT NULL default '0',
  `replied` int(1) NOT NULL default '0',
  `forwarded` int(1) NOT NULL default '0',
  `direction` enum('outgoing','incoming') NOT NULL default 'incoming',
  PRIMARY KEY  (`mid`),
  KEY `ind_viewed_caID` (`viewed`, `caID`), -- Improved lookup on counting/retrieving unread messages for a user
  KEY `ind_folder_caID_sticky` (`folder`, `caID`, `sticky`), -- Improved lookup on counting/retrieving folder messages
  KEY `ind_rdate_folder_caID` (`rdate`,`folder`, `caID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `cMS_folders`
--

DROP TABLE IF EXISTS `cMS_folders`;
CREATE TABLE `cMS_folders` (
  `fid` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `description` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `caID` (`caID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `name` varchar(50) NOT NULL default '',
  `value` mediumtext,
  `cdate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `captcha`
--

DROP TABLE IF EXISTS `captcha`;
CREATE TABLE `captcha` (
  `id` int(10) NOT NULL auto_increment,
  `string` char(8) character set latin1 collate latin1_bin NOT NULL default '',
  `gen_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `string` (`string`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `failedlogins`
--
DROP TABLE IF EXISTS `failedlogins`;
CREATE TABLE `failedlogins` (
	`failureid` int(8) unsigned NOT NULL auto_increment,
  `nickname` varchar(25) NOT NULL default '',
  `failuredt` datetime NOT NULL default '0000-00-00 00:00:00',
  `failureip` varchar(15) NOT NULL default '',
  `failurelock` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`failureid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `feed_item`
--

DROP TABLE IF EXISTS `feed_item`;
CREATE TABLE `feed_item` (
  `feed_id` int(4) unsigned NOT NULL default '0',
  `id` int(7) unsigned NOT NULL auto_increment,
  `title` varchar(80) NOT NULL default '',
  `pubdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `url` varchar(120) NOT NULL default '',
  `content` text,
  PRIMARY KEY  (`id`),
  KEY `feed_id` (`feed_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `edition_article`
--

DROP TABLE IF EXISTS `edition_article`;
CREATE TABLE `edition_article` (
  `edition_id` int(7) unsigned NOT NULL default '0',
  `article_id` int(10) NOT NULL default '0',
  `weight` int(3) default '0',
  UNIQUE KEY `ea_key` (`edition_id`,`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `feed_list`
--

DROP TABLE IF EXISTS `feed_list`;
CREATE TABLE `feed_list` (
  `id` int(4) unsigned NOT NULL auto_increment,
  `name` varchar(40) NOT NULL default '',
  `type` varchar(40) NOT NULL default 'news',
  `url` varchar(60) NOT NULL default '',
  `last_update` datetime default NULL,
  `hash` varchar(32) default NULL,
  `remote` enum('Y','N') NOT NULL default 'Y',
  `acl` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_bans`
--

DROP TABLE IF EXISTS `forum_bans`;
CREATE TABLE `forum_bans` (
  `ban_id` int(10) unsigned NOT NULL auto_increment,
  `forum` varchar(10) NOT NULL default '',
  `type` enum('host','user') NOT NULL default 'host',
  `ban` varchar(200) NOT NULL default '',
  `ban_by` varchar(25) default '0',
  `ban_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `ban_comment` tinytext,
  PRIMARY KEY  (`ban_id`),
  UNIQUE KEY `forum_ban` (`ban`,`forum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_categories`
--

DROP TABLE IF EXISTS `forum_categories`;
CREATE TABLE `forum_categories` (
  `category` varchar(25) NOT NULL default '',
  `category_name` varchar(100) NOT NULL default '0',
  PRIMARY KEY  (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_from_mail`
--

DROP TABLE IF EXISTS `forum_from_mail`;
CREATE TABLE `forum_from_mail` (
  `mail` varchar(75) NOT NULL default '',
  `forum` varchar(10) NOT NULL default '',
  KEY `mail` (`mail`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_list`
--

DROP TABLE IF EXISTS `forum_list`;
CREATE TABLE `forum_list` (
  `forum` varchar(10) NOT NULL default '',
  `name` varchar(40) NOT NULL default '',
  `smalldesc` varchar(100) NOT NULL default '',
  `type` varchar(25) NOT NULL default 'normal',
  `logo` varchar(100) default NULL,
  `icon` varchar(100) default NULL,
  `last_modified` datetime default NULL,
  `motd` mediumtext,
  `last_post_time` datetime default NULL,
  `last_post_by` varchar(55) default NULL,
  `threads_num` int(6) default '0',
  `posts_num` int(8) default '0',
  `administrator` varchar(200) NOT NULL default '',
  `access_group` varchar(200) default NULL,
  `guest_post` enum('R','X','S') default 'R',
  `moderator` varchar(200) NOT NULL default 'moderators',
  `searchable` enum('Y','N') default 'N',
  `allow_html` enum('Y','N') default 'N',
  `locked` enum('Y','N') default 'N',
  `last_post_id` int(10) unsigned NOT NULL default '0',
  `replyonly` enum('Y','N') default 'N',
  `hex_color` varchar(7) default NULL,
  `secured` enum('N','Y') NOT NULL default 'N',
  PRIMARY KEY  (`forum`),
  KEY `ind_last` (`last_modified`),
  KEY `ind_last_post_id` (`last_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_replies`
--

DROP TABLE IF EXISTS `forum_replies`;
CREATE TABLE `forum_replies` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `forum` varchar(10) NOT NULL default '',
  `thread` int(10) unsigned NOT NULL default '0',
  `pid` int(10) unsigned NOT NULL default '0',
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `frontpage` char(1) default NULL,
  `author` varchar(50) NOT NULL default '',
  `author_caID` int(7) unsigned zerofill default NULL,
  `author_rank` varchar(50) NOT NULL default '',
  `author_ip` varchar(15) default NULL,
  `author_host` varchar(150) default NULL,
  `author_badge` tinytext,
  `author_cbadge` varchar(13) default NULL,
  `author_zbadge` varchar(13) default NULL,
  `author_color` varchar(7) default NULL,
  `subject` varchar(55) NOT NULL default '',
  `img_url` varchar(100) default NULL,
  `body` text,
  `signature` mediumtext,
  `bold` char(1) default NULL,
  `sticky` tinyint(1) default NULL,
  `trail` varbinary(255) NOT NULL default '',
  PRIMARY KEY  (`mid`),
  KEY `ind_thread` (`thread`),
  KEY `ind_author` (`author`),
  KEY `trail` (`trail`),
  KEY `author_caID` (`author_caID`),
  KEY `ind_rdate_forum_sticky` (`rdate`,`forum`,`sticky`),
  KEY `ind_forum_sticky` (`forum`,`sticky`),
  KEY `ind_pid_forum` (`pid`,`forum`),
  KEY `ind_frontpage_forum` (`frontpage`,`forum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `forum_reply_votes`
--

DROP TABLE IF EXISTS `forum_reply_votes`;
CREATE TABLE `forum_reply_votes` (
  `user_caID` INT( 7 ) UNSIGNED NOT NULL,
  `message_id` INT( 10 ) NOT NULL, 
  UNIQUE KEY `vote_key` (`user_caID`,`message_id`),
  KEY `caID` (`user_caID`),
  KEY `mid` (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `groupware`
--

DROP TABLE IF EXISTS `groupware`;
CREATE TABLE `groupware` (
  `id` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `priority` tinyint(2) NOT NULL default '0',
  `hitpoints` tinyint(3) NOT NULL default '0',
  `brigade` int(6) unsigned NOT NULL default '1',
  `master` varchar(100) NOT NULL default '',
  `description` tinytext NOT NULL,
  `deprecated_by` varchar(100) NOT NULL default '',
  `depends_on` varchar(100) NOT NULL default '',
  `add_title` varchar(100) NOT NULL default '',
  `add_title_abrv` varchar(50) NOT NULL default '',
  `add_badge` varchar(255) NOT NULL default '',
  `add_role` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `library_language`
--
DROP TABLE IF EXISTS `library_language`;
CREATE TABLE `library_language` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `language` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `log_library`
--

DROP TABLE IF EXISTS `log_library`;
CREATE TABLE `log_library` (
  `item_id` int(6) unsigned NOT NULL default '0',
  `type` varchar(20),
  `msg` tinytext,
  `action_by` varchar(25) default NULL,
  `action_by_id` int(7) unsigned default NULL,
  `adate` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `action_by_id` (`action_by_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `log_brigades`
--

DROP TABLE IF EXISTS `log_brigades`;
CREATE TABLE `log_brigades` (
  `brigade_id` int(6) unsigned NOT NULL default '0',
  `type` enum('brig_created','brig_deleted','brig_subcreated','brig_subdeleted','brig_modified','brig_cmodified') default NULL,
  `msg` tinytext,
  `action_by` varchar(25) default NULL,
  `action_by_id` int(7) unsigned default NULL,
  `adate` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `brigade_id` (`brigade_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `log_projects`
--

DROP TABLE IF EXISTS `log_projects`;
CREATE TABLE `log_projects` (
  `project_id` int(6) unsigned NOT NULL default '0',
  `type` varchar(20),
  `msg` tinytext,
  `action_by` varchar(25) default NULL,
  `action_by_id` int(7) unsigned default NULL,
  `adate` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `project_id` (`project_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `log_brigades_users`
--

DROP TABLE IF EXISTS `log_brigades_users`;
CREATE TABLE `log_brigades_users` (
  `brigade_id` int(6) unsigned NOT NULL default '0',
  `action_on` varchar(25) NOT NULL default '',
  `action_on_id` int(7) unsigned NOT NULL default '0',
  `type` enum('user_join','user_kick','user_discharge','user_setco','user_unsetco','user_setsubco','user_unsetsubco','user_setxo','user_unsetxo') NOT NULL default 'user_join',
  `msg` tinytext,
  `action_by` varchar(25) default NULL,
  `action_by_id` int(7) unsigned default NULL,
  `adate` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `brigade_id` (`brigade_id`),
  KEY `action_on_id` (`action_on_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `log_forum`
--

DROP TABLE IF EXISTS `log_forum`;
CREATE TABLE `log_forum` (
  `forum` varchar(10) NOT NULL default '',
  `action` enum('delete','move','warn','report') NOT NULL default 'delete',
  `dest` varchar(10) default NULL,
  `thread_id` int(10) unsigned NOT NULL default '0',
  `subject` varchar(55) NOT NULL default '',
  `author` varchar(70) NOT NULL default '?',
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `logby` varchar(25) NOT NULL default '',
  `logby_id` int(7) unsigned zerofill default NULL,
  `ldate` datetime NOT NULL default '0000-00-00 00:00:00',
  `reason` varchar(120) NOT NULL default '',
  `votes` int(7) unsigned NOT NULL default '0',
  KEY `forum` (`forum`),
  KEY `dest` (`dest`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `log_users`
--

DROP TABLE IF EXISTS `log_users`;
CREATE TABLE `log_users` (
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `nickname` varchar(25) default NULL,
  `type` set('joined','modified','passreset','promoted','banned','unbanned','note') default NULL,
  `msg` text,
  `logby` varchar(100) default NULL,
  `logbycaID` int(7) unsigned default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `caID` (`caID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `mail`
--

DROP TABLE IF EXISTS `mail`;
CREATE TABLE `mail` (
  `id` varchar(128) NOT NULL default '',
  `caid` int(7) unsigned zerofill default NULL,
  `forward` varchar(128) default NULL,
  `password` varchar(128) default NULL,
  `home` varchar(128) NOT NULL default '/usr/local/mail/',
  `maildir` varchar(255) default NULL,
  `quota` int(8) unsigned NOT NULL default '0',
  `date_limit` datetime default NULL,
  `system` enum('N','Y') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `caid` (`caid`),
  KEY `date_limit` (`date_limit`),
  KEY `forward` (`forward`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `pgpkey`
--

DROP TABLE IF EXISTS `pgpkey`;
CREATE TABLE `pgpkey` (
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `uid` varchar(255) NOT NULL default '',
  `fingerprint` varchar(40) NOT NULL default '',
  `created` int(10) unsigned NOT NULL default '0',
  `expires` int(10) unsigned default NULL,
  `pgpkey` text NOT NULL,
  `warned` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`caID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `project_categories`
--

DROP TABLE IF EXISTS `project_categories`;
CREATE TABLE `project_categories` (
  `category` varchar(25) default NULL,
  `category_name` varchar(100) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `project_news`
--

DROP TABLE IF EXISTS `project_news`;
CREATE TABLE `project_news` (
  `news_id` int(6) unsigned zerofill NOT NULL auto_increment,
  `proj_id` int(6) NOT NULL default '0',
  `news_title` varchar(100) default NULL,
  `news_content` text NOT NULL,
  `news_date` datetime default NULL,
  `news_poster` varchar(100) default NULL,
  PRIMARY KEY  (`news_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `proj_id` int(6) unsigned NOT NULL auto_increment,
  `proj_name` varchar(100) NOT NULL default '',
  `proj_brigade_parent` int(6) NOT NULL default '0',
  `proj_group` varchar(100) NOT NULL default '',
  `proj_desc` mediumtext,
  `proj_type` varchar(250) default NULL,
  `proj_status` int(3) NOT NULL default '0',
  `proj_start` date default NULL,
  `proj_end` date default NULL,
  `proj_modified` datetime default NULL,
  `proj_access` enum('P','I','C') default 'P',
  `proj_invite` varchar(100) default NULL,
  `proj_img` varchar(100) NOT NULL default 'www.cyberarmy.net/includes/images/proj_default.png',
  `proj_q` enum('y','n') default 'y',
  `proj_leader_access` varchar(100) default NULL,
  PRIMARY KEY  (`proj_id`),
  UNIQUE KEY `name` (`proj_name`),
  UNIQUE KEY `proj_group` (`proj_group`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `promotions`
--

DROP TABLE IF EXISTS `promotions`;
CREATE TABLE `promotions` (
  `caID` tinyint(7) unsigned zerofill NOT NULL default '0000000',
  `mentor` int(7) unsigned default NULL,
  `state` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`caID`),
  KEY `state` (`state`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `publication`
--

DROP TABLE IF EXISTS `publication`;
CREATE TABLE `publication` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `description` tinytext NOT NULL,
  `administrator` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `publication_edition`
--

DROP TABLE IF EXISTS `publication_edition`;
CREATE TABLE `publication_edition` (
  `id` int(3) unsigned NOT NULL auto_increment,
  `publication_id` int(3) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `description` tinytext NOT NULL,
  `status` enum('new','published','deleted') NOT NULL default 'new',
  PRIMARY KEY  (`id`),
  KEY `id` (`publication_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `remote_mission`
--

DROP TABLE IF EXISTS `remote_mission`;
CREATE TABLE `remote_mission` (
  `url` varchar(100) default NULL,
  `last_update` varchar(10) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `remote_mission_items`
--

DROP TABLE IF EXISTS `remote_mission_items`;
CREATE TABLE `remote_mission_items` (
  `title` varchar(100) NOT NULL default '',
  `category` varchar(100) NOT NULL default '',
  `status` varchar(50) NOT NULL default '',
  `description` text,
  `link` tinytext NOT NULL,
  `proposer` varchar(50) NOT NULL default '',
  `dateset` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `repository_category`
--

DROP TABLE IF EXISTS `repository_category`;
CREATE TABLE `repository_category` (
  `id` int(5) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `path` varchar(255) default NULL,
  `description` text,
  `parent` int(5) unsigned NOT NULL default '0',
  `status` enum('open','closed') NOT NULL default 'open',
  `forum` varchar(10) default NULL,
  `read_access` varchar(255) default NULL,
  `upload_access` varchar(255) default NULL,
  `review_access` varchar(255) NOT NULL default 'repo_master',
  `admin_access` varchar(255) NOT NULL default 'repo_master',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `directory` (`name`,`parent`),
  UNIQUE KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `repository_file`
--

DROP TABLE IF EXISTS `repository_file`;
CREATE TABLE `repository_file` (
  `id` int(5) unsigned NOT NULL auto_increment,
  `category_id` int(5) unsigned NOT NULL default '0',
  `name` varchar(150) NOT NULL default '',
  `size` int(10) unsigned NOT NULL default '0',
  `type` varchar(150) default NULL,
  `description` varchar(255) default NULL,
  `md5_digest` varchar(32) NOT NULL default '',
  `status` enum('pending','listed','hidden') NOT NULL default 'pending',
  `upload_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `uploaded_by_caid` int(7) unsigned zerofill NOT NULL default '0000000',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `digest` (`md5_digest`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `script_password`
--

DROP TABLE IF EXISTS `script_password`;
CREATE TABLE `script_password` (
  `confirm` varbinary(24) NOT NULL default '',
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `remote_ip` varchar(15) NOT NULL default '',
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `retrieved` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`confirm`),
  UNIQUE KEY `caID` (`caID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `script_register`
--

DROP TABLE IF EXISTS `script_register`;
CREATE TABLE `script_register` (
  `confirm` varchar(24) NOT NULL default '0',
  `nickname` varchar(25) NOT NULL default '0',
  `showname` varbinary(25) NOT NULL default '',
  `prvemail` varchar(45) NOT NULL default '0',
  `remote_ip` varchar(15) NOT NULL default '',
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`confirm`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `skill`
--

DROP TABLE IF EXISTS `skill`;
CREATE TABLE `skill` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `reference` tinytext,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `skill_level`
--

DROP TABLE IF EXISTS `skill_level`;
CREATE TABLE `skill_level` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `tc_hof`
--

DROP TABLE IF EXISTS `tc_hof`;
CREATE TABLE `tc_hof` (
  `id` int(4) unsigned NOT NULL auto_increment,
  `showname` varbinary(25) default NULL,
  `fdate` datetime default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `user_group`
--

DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group` (
  `caid` int(7) unsigned zerofill NOT NULL default '0000000',
  `group_id` varchar(100) NOT NULL default '',
  `level` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`caid`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `user_skill`
--

DROP TABLE IF EXISTS `user_skill`;
CREATE TABLE `user_skill` (
  `user_id` int(7) unsigned zerofill NOT NULL default '0000000',
  `skill_id` tinyint(3) unsigned NOT NULL default '0',
  `level_id` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`user_id`,`skill_id`),
  KEY `level_id` (`level_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `user_todo`
--

DROP TABLE IF EXISTS `user_todo`;
CREATE TABLE `user_todo` (
  `caID` int(7) unsigned zerofill NOT NULL default '0000000',
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `task` blob NOT NULL,
  `group_id` varchar(100) NOT NULL default 'user',
  PRIMARY KEY  (`caID`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `caID` int(7) unsigned zerofill NOT NULL auto_increment,
  `nickname` varchar(25) NOT NULL default '',
  `showname` varbinary(25) NOT NULL default '',
  `passwd` varbinary(32) NOT NULL default '',
  `pubemail` varchar(45) NOT NULL default '',
  `prvemail` varchar(45) NOT NULL default '',
  `challenge_number` int(4) unsigned default NULL,
  `brigade` int(6) unsigned default NULL,
  `brigade_pos` tinyint(1) unsigned default NULL,
  `irc_nickname` varchar(30) default NULL,
  `away` int(10) unsigned default NULL,
  `bantime` int(10) unsigned default NULL,
  `securityflag` tinyint(1) default NULL,
  `retired` int(10) unsigned default NULL,
  `session_id` varbinary(15) default NULL,
  `session_time` int(10) unsigned default NULL,
  `session_ip` varchar(15) default NULL,
  `session_mode` enum('normal','secured') default NULL,
  `session_ltime` int(10) unsigned default NULL,
  `session_timeout` tinyint(2) unsigned NOT NULL default '1',
  `publicplan` text,
  `signature` text,
  `joined_on` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`caID`),
  UNIQUE KEY `ind_mail` (`prvemail`),
  UNIQUE KEY `ind_nick` (`nickname`),
  UNIQUE KEY `ind_sess` (`session_id`),
  KEY `ind_brig` (`brigade`),
  KEY `ind_brigpos` (`brigade_pos`),
  KEY `ind_ircnick` (`irc_nickname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki`
--

DROP TABLE IF EXISTS `wiki`;
CREATE TABLE `wiki` (
  `name` varchar(50) NOT NULL default '',
  `title` varchar(128) NOT NULL default '',
  `description` tinytext,
  `frontnode` varchar(128) NOT NULL default 'FrontPage',
  `admin_group` varchar(128) default NULL,
  `edit_group` varchar(128) default NULL,
  `access_group` varchar(128) default NULL,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_link`
--

DROP TABLE IF EXISTS `wiki_link`;
CREATE TABLE `wiki_link` (
  `wiki` varchar(50) NOT NULL default '',
  `origin` varchar(128) NOT NULL default '',
  `destination` varchar(128) NOT NULL default '',
  UNIQUE KEY `wiki` (`wiki`,`origin`,`destination`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_node`
--

DROP TABLE IF EXISTS `wiki_node`;
CREATE TABLE `wiki_node` (
  `wiki` varchar(50) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `author` varchar(25) NOT NULL default '',
  `content` text NOT NULL,
  UNIQUE KEY `wiki_name` (`wiki`,`name`),
  KEY `created` (`created`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_revision`
--

DROP TABLE IF EXISTS `wiki_revision`;
CREATE TABLE `wiki_revision` (
  `wiki` varchar(50) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `revision` int(8) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `log` tinytext,
  `author` varchar(25) NOT NULL default '',
  `content` text NOT NULL,
  UNIQUE KEY `wiki_name` (`wiki`,`name`,`revision`),
  KEY `revision` (`revision`),
  KEY `created` (`created`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `iplog`
--

DROP TABLE IF EXISTS `iplog`;
CREATE TABLE `iplog` (
  `caid` int(7) unsigned zerofill NOT NULL default '0000000',
  `dt` datetime NOT NULL default '0000-00-00 00:00:00',
  `ip` varchar(15) NOT NULL default '',
  `host` varchar(64) default NULL,
  PRIMARY KEY  (`caid`,`dt`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `join_reason_votes`
--

DROP TABLE IF EXISTS `join_reason_votes`;
CREATE TABLE `join_reason_votes` (
  `nickname` varchar(25) NOT NULL default '0',
  `user_caID` INT( 7 ) UNSIGNED, 
  `rdate` datetime NOT NULL default '0000-00-00 00:00:00', 
  `reason_id` INT( 10 ),
  `comments` TEXT,
  UNIQUE KEY `vote_key` (`nickname`,`user_caID`,`reason_id`),
  KEY `caID` (`user_caID`,`nickname`,`reason_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `join_reasons`
--

DROP TABLE IF EXISTS `join_reasons`;
CREATE TABLE `join_reasons` (
  `id` INT( 7 ) unsigned auto_increment, 
  `reason` varchar(150), 
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `windstone_sites`
--

DROP TABLE IF EXISTS `windstone_sites`;
CREATE TABLE `windstone_sites` (
  `id` int(11) NOT NULL auto_increment,
  `url` varchar(255) default NULL,
  `secret` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

--
-- Table structure for table `windstone_tokens`
--

DROP TABLE IF EXISTS `windstone_tokens`;
CREATE TABLE `windstone_tokens` (
  `id` int(11) NOT NULL auto_increment,
  `dateset` datetime default NULL,
  `caid` int(11) default NULL,
  `siteid` int(11) default NULL,
  `request_token` varchar(32) default NULL,
  `auth_token` varchar(32) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;

