#!/usr/bin/perl

$|++;

use strict;
use Getopt::Long;
use HTML::Entities;
use CyberArmy::Utils;
use CyberArmy::User;

## Get the args
my ($brigid,@fields,@methods); GetOptions (
	"brigade|brig=i" => \$brigid,
	"fields=s" => \@fields,
	"methods=s" => \@methods
);
	@fields = split(/,/,join(',',@fields));
	@methods = split(/,/,join(',',@methods));

## Sanity checks handeling
die "Specify a brigade (--brigade=#id)\n" unless $brigid;
die "No data to dump?\n" unless @fields;

my $pattern = ($brigid == 1) ? "'1,%'" : "'%,$brigid,%'";
my $getChain = $CyberArmy::Utils::Database::dbh->prepare(
	"SELECT * FROM brigades WHERE brigade_id = $brigid".
	" OR (brigade_chain LIKE $pattern)"
); $getChain->execute(); ## Get the chain of the brigade

my %brigades; ## build the tree of the selected brigade
while (my $brigade = $getChain->fetchrow_hashref()) {
	$brigades{$brigade->{'brigade_id'}}{'fields'} = $brigade;
} $getChain->finish(); foreach (keys %brigades) {
	if ($brigades{$_}{'fields'}->{'brigade_parent'}) {
		push @{ 
			$brigades{
				$brigades{$_}{'fields'}->{'brigade_parent'}
			}{'subbrigades'}
		}, $_;
	}
}

## get the troops of the selected brigade
my $getTroops = $CyberArmy::Utils::Database::dbh->prepare(
	'SELECT  '.join(',',@fields).',groups,brigade,brigade_pos FROM users '.
	'WHERE brigade IN ('.join(',',keys %brigades).') AND brigade_pos > 0'
); $getTroops->execute();

while (my $user = $getTroops->fetchrow_hashref()) {
	if ($user->{brigade_pos} == 1) {
		push @{$brigades{$user->{brigade}}{troops}},
			CyberArmy::User->Forge(key => 'caID', input => $user);

	} elsif ($user->{brigade_pos} == 2) {
		push @{$brigades{$user->{brigade}}{xo}},
			CyberArmy::User->Forge(key => 'caID', input => $user);
	} elsif ($user->{brigade_pos} == 3) {
		push @{$brigades{$user->{brigade}}{co}},
			CyberArmy::User->Forge(key => 'caID', input => $user);
	} elsif ($user->{brigade_pos} == 5) {
		push @{$brigades{$user->{brigade}}{co}}, 
			CyberArmy::User->Forge(key => 'caID', input => $user);	
		push @{$brigades{ $brigades{$user->{brigade}}{fields}->{brigade_parent} }{xo}},
			CyberArmy::User->Forge(key => 'caID', input => $user);
	} else { die "Data Inconsistencies\n" }
}


## now do the acctual output
my ($depth,$current,$tabs) = (-1,$brigid);
print qq~<?xml version="1.0" encoding="ISO-8859-1"?>\n~;

LOOP:

if (!$brigades{$current}{printed}) {
	$depth++; $tabs = "\t" x $depth;
	
	if ($current == 1) { print "$tabs<cyberarmy>\n" }
	elsif ($brigades{$current}{fields}->{brigade_parent} == 1)
	{ print "$tabs<brigade>\n" } else { print "$tabs<subdivision>\n";}
	
	print
		"$tabs<id>"
		.encode_entities($brigades{$current}{fields}->{brigade_id}).
		"</id>\n";

	print
		"$tabs<chain>".
		encode_entities($brigades{$current}{fields}->{brigade_chain}).
		"</chain>\n";

	print
		"$tabs<name>".
		encode_entities($brigades{$current}{fields}->{brigade_name}).
		"</name>\n";

	print
		"$tabs<acronym>".
		encode_entities($brigades{$current}{fields}->{brigade_acr}).
		"</acronym>\n";

	print
		"$tabs<url>".
		encode_entities($brigades{$current}{fields}->{brigade_url}).
		"</url>\n";

	print
		"$tabs<description>".
		encode_entities($brigades{$current}{fields}->{brigade_description}).
		"</description>\n";
	
	foreach (['co','commander'],['xo','xcommander'],['troops','member']) {
		foreach my $user (@{$brigades{$current}{$_->[0]}}) {
			print "$tabs<$_->[1]>\n"; foreach (@fields,@methods) {
				if (my $data = $user->$_) {
					print
						"$tabs<".(lc $_).">"
						.encode_entities($data).
						"</".(lc $_).">\n" 
				}}
			print "$tabs</$_->[1]>\n";
		}
	}

	$brigades{$current}{printed}++;
}

if (@{$brigades{$current}{subbrigades}}[0]) {
	my $new = shift @{$brigades{$current}{subbrigades}};
	$brigades{$new}{parent} = $current;
	$current = $new; goto LOOP;
} else { 
	print "\t" x $depth;
	
	if ($current == 1) { print "</cyberarmy>\n" }
	elsif ($brigades{$current}{fields}->{brigade_parent} == 1)
	{ print "</brigade>\n" } else { print "</subdivision>\n";}
 
	if ($brigades{$current}{parent}) {
		$current = $brigades{$current}{parent};
		$depth--; 
		goto LOOP;
	} else { exit; }
}
