#!/usr/bin/perl

$|++;

use strict;
use CyberArmy::Utils;

my $getForum = $CyberArmy::Utils::Database::dbh
->prepare('SELECT forum,name,threads_num,posts_num FROM forum_list ');

$getForum->execute; ## get all forums

while ( my $forum = $getForum->fetchrow_hashref() ) {

	my $error = 0;
	
	my $messagesInForum = $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(mid) FROM forum_replies WHERE forum = ?'
		,undef,$forum->{'forum'})->[0];

	my $threadsInForum = $CyberArmy::Utils::Database::dbh
		->selectrow_arrayref(
			'SELECT count(mid) FROM forum_replies WHERE forum = ? AND pid = 0'
		,undef,$forum->{'forum'})->[0];
	
	print "$forum->{name} ($forum->{forum}):";
		
	unless ($messagesInForum == $forum->{'posts_num'}) {
		print " Messages ($messagesInForum/$forum->{posts_num})"; $error++;
	}

	unless ($threadsInForum == $forum->{'threads_num'}) {
		print " Threads ($threadsInForum/$forum->{threads_num})"; $error++;
	}
	
	print $error ? "\n" : " ok!\n";
}
