#!/usr/bin/perl -w

## install/bootstrap dinah

use strict;
use Cwd ();
use File::Spec ();
use File::Temp ();
use Sys::Hostname ();

eval { require Module::Build };
die "install Module::Build first\n" if $@;

my $ca_pm = File::Spec->catfile('lib','CyberArmy.pm');

my $build = Module::Build->new(
	dist_name => 'dinah',
	dist_version => '0.5.5',
	add_to_cleanup => [ $ca_pm ],
	pm_files => { $ca_pm => $ca_pm },
	requires => {
		'perl'						=> '5.8.2',
		'Algorithm::Diff'			=> '1.15',
		'Apache'					=> '1.27',
		'Apache::DBI'				=> '0.94',
		'Apache::Request'			=> '1.3',
		'Apache::Singleton'			=> '0.06',
		'Class::Singleton'			=> '1.03',
		'DBD::mysql'				=> '2.9004',
		'Digest::MD5'				=> '2.33',
		'HTML::Entities'			=> '1.27',
		'MIME::Parser'				=> '5.414',
		'Net::SMTP'					=> '2.29',
		'Net::Server'				=> '0.87',
		'Proc::Daemon'				=> '0.03',
		'Proc::PID::File'			=> '0.05',
		'Sys::Syslog'				=> '0.05',
		'Template'					=> '2.14',
		'Template::Plugin::Date'	=> '2.72',
		'Time::HiRes'				=> '1.60',
		'MySQL::Diff'				=> '0.33',
		'XML::RSS'					=> '1.00',
		'GD'					=> '2.16',
		'Data::Password'			=> '1.05'
	},
	build_elements => ['pm'] ## only deal with our specified pm file
);

warn "loaded existing values...\n"
		if (eval { require CyberArmy });

$CyberArmy::Config{'DINAH_BASE'}  = Cwd::getcwd();

$CyberArmy::Config{'SERVER_NAME'} = $build->prompt(
	'What is your hostname',Sys::Hostname::hostname());

$CyberArmy::Config{'DINAH_ADMIN'} = $build->prompt(
	'What is your email address?',
(getpwuid($<))[0].'@'.$CyberArmy::Config{'SERVER_NAME'});

$CyberArmy::Config{'SMTP_RELAY'} = $build->prompt(
	'What is an SMTP relay I can use?',
$CyberArmy::Config{'SMTP_RELAY'} || $CyberArmy::Config{'SERVER_NAME'});

unless ( $CyberArmy::Config{'HTTPD'} ) {
	HTTPD:
	foreach my $path (File::Spec->path()) {
		foreach (qw(httpd apache)) {
			if (-x (my $httpd = File::Spec->catfile($path,$_))) {
				$CyberArmy::Config{'HTTPD'} = $httpd; last HTTPD;
			}
		}
	}
}

while ((not $CyberArmy::Config{'HTTPD'})
	or (not -x $CyberArmy::Config{'HTTPD'})
	or (not `$CyberArmy::Config{HTTPD} -v` =~ /Apache\/1\.3/)){

	warn $CyberArmy::Config{'HTTPD'}," ins't a valid httpd\n"
		if $CyberArmy::Config{'HTTPD'};

	$CyberArmy::Config{'HTTPD'} =
		$build->prompt('Where is your httpd located');
}

open (my $pm, ">lib/CyberArmy.pm") or die $!;
my $lib = File::Spec->catfile($CyberArmy::Config{'DINAH_BASE'},'lib');
my $cnf = File::Spec->catfile($CyberArmy::Config{'DINAH_BASE'},'conf','my.cnf');
print $pm <<MODULE;
package CyberArmy;

use strict;
use lib qw( $lib );

\$CyberArmy::VERSION = '0.5.5';

\%CyberArmy::Config = (
	SERVER_NAME => '$CyberArmy::Config{SERVER_NAME}',
	DINAH_BASE => '$CyberArmy::Config{DINAH_BASE}',
	DINAH_ADMIN => '$CyberArmy::Config{DINAH_ADMIN}',
	SMTP_RELAY => '$CyberArmy::Config{SMTP_RELAY}',
	DINAH_DSN => 'DBI:mysql:cyberarmy;mysql_read_default_file=$cnf',
	HTTPD => '$CyberArmy::Config{HTTPD}'

);

1;
MODULE
close ($pm);

$build->dispatch('build');
eval {$build->dispatch('install')};
warn "Installation failed!\n" if $@;
$build->dispatch('realclean');
