/*
 * Decompiled with CFR 0.152.
 */
package jalt;

import jalt.PlafMacros;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class MultiLineToolTipUI
extends ToolTipUI {
    static MultiLineToolTipUI SINGLETON = new MultiLineToolTipUI();
    static boolean DISPLAY_ACCELERATOR = true;
    int accelerator_offset = 15;
    int inset = 3;

    private MultiLineToolTipUI() {
    }

    public static void initialize() {
        String string = "ToolTipUI";
        Class<?> clazz = SINGLETON.getClass();
        String string2 = clazz.getName();
        UIManager.put(string, string2);
        UIManager.put(string2, clazz);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return SINGLETON;
    }

    public void installUI(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    public void uninstallUI(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    public static void setDisplayAcceleratorKey(boolean bl) {
        DISPLAY_ACCELERATOR = bl;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.getHeight();
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        String[] stringArray = PlafMacros.breakupLines(string);
        int n2 = stringArray.length;
        int n3 = n2 * n;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            String string2;
            int n5 = fontMetrics.stringWidth(stringArray[i]);
            if (DISPLAY_ACCELERATOR && i == n2 - 1 && !(string2 = this.getAcceleratorString((JToolTip)jComponent)).equals("")) {
                n5 += fontMetrics.stringWidth(string2) + this.accelerator_offset;
            }
            n4 = Math.max(n4, n5);
        }
        return new Dimension(n4 + this.inset * 2, n3 + this.inset * 2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAscent();
        String string = ((JToolTip)jComponent).getTipText();
        String[] stringArray = PlafMacros.breakupLines(string);
        int n3 = stringArray.length;
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        int n4 = 0;
        int n5 = 2 + n2;
        while (n4 < n3) {
            String string2;
            graphics.drawString(stringArray[n4], this.inset, n5);
            if (DISPLAY_ACCELERATOR && n4 == n3 - 1 && !(string2 = this.getAcceleratorString((JToolTip)jComponent)).equals("")) {
                Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                graphics.setFont(font2);
                graphics.drawString(string2, fontMetrics.stringWidth(stringArray[n4]) + this.accelerator_offset, n5);
            }
            ++n4;
            n5 += n;
        }
    }

    public String getAcceleratorString(JToolTip jToolTip) {
        JComponent jComponent = jToolTip.getComponent();
        if (jComponent == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        String string = "";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 2);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keyStroke.equals(keyStrokeArray[i])) continue;
            char c = (char)keyStrokeArray[i].getKeyCode();
            int n = keyStrokeArray[i].getModifiers();
            if (n == 2) {
                string = "Ctrl+" + (char)keyStrokeArray[i].getKeyCode();
                break;
            }
            if (n != 8) continue;
            string = "Alt+" + (char)keyStrokeArray[i].getKeyCode();
            break;
        }
        return string;
    }
}

