/*
 * Decompiled with CFR 0.152.
 */
package IRC;

import IRC.Event;
import IRC.IRCConnection;
import IRC.User;
import IRC.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Channel
extends List
implements MouseListener,
ActionListener {
    private String name;
    public User[] users = new User[2048];
    public IRCConnection conn;
    PopupMenu commandMenu;
    Component selectedComponent;

    public Channel(String string) {
        this.name = string;
        this.commandMenu = new PopupMenu("Commands");
        this.commandMenu.add(this.makeMenuItem("Private Message"));
        this.commandMenu.add(this.makeMenuItem("Whois"));
        this.commandMenu.add(this.makeMenuItem("Ping"));
        this.commandMenu.add(this.makeMenuItem("Slap"));
        this.add(this.commandMenu);
        this.addMouseListener(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addUser(User user) {
        if (this.getUser(user) != null) {
            return;
        }
        int n = this.getInsertPosition(user);
        if (n > -1) {
            this.addItem(user.nameWithModes(), n);
        }
        for (int i = 0; i < this.users.length; ++i) {
            if (this.users[i] != null) continue;
            this.users[i] = user;
            break;
        }
    }

    public int getInsertPosition(User user) {
        String[] stringArray = this.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            boolean bl = false;
            int n = Util.compare(user.nameWithModes(), stringArray[i]);
            if (n == -1) {
                return i;
            }
            if (n != 0) continue;
            return -1;
        }
        return this.getItemCount() + 1;
    }

    public int getItemPos(String string) {
        String[] stringArray = this.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void sortList() {
        User[] userArray = Util.sortItemsAlphabetically(this.users);
        this.clear();
        for (int i = userArray.length - 1; i >= 0; --i) {
            if (userArray[i] == null) continue;
            this.addItem(userArray[i].nameWithModes(), i);
        }
    }

    public void dumpUsers() {
        System.err.println("===== Dumping Users for " + this.name + " ====");
        for (int i = 0; i < this.users.length; ++i) {
            if (this.users[i] == null) continue;
            System.err.println("[" + i + "] " + this.users[i].getName() + "(" + this.users[i].nameWithModes() + ")");
        }
        System.err.println("===== END Users for " + this.name + " ====");
    }

    public User getUser(User user) {
        String string = user.getName();
        for (int i = 0; i < this.users.length; ++i) {
            if (this.users[i] == null || !this.users[i].getName().equalsIgnoreCase(string)) continue;
            return this.users[i];
        }
        return null;
    }

    public void removeUser(User user) {
        if (user == null) {
            return;
        }
        for (int i = 0; i < this.users.length; ++i) {
            if (this.users[i] == null || !this.users[i].getName().equalsIgnoreCase(user.getName())) continue;
            try {
                this.remove(this.users[i].nameWithModes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.users[i] = null;
            return;
        }
    }

    public void setHalfOps(String string, boolean bl) {
        if (string == null) {
            return;
        }
        User user = this.getUser(User.create(string));
        if (user != null) {
            this.removeUser(user);
            user.halfops = bl;
            this.addUser(user);
        }
    }

    public void setVoice(String string, boolean bl) {
        if (string == null) {
            return;
        }
        User user = this.getUser(User.create(string));
        if (user != null) {
            this.removeUser(user);
            user.voice = bl;
            this.addUser(user);
        }
    }

    public void setOps(String string, boolean bl) {
        if (string == null) {
            return;
        }
        User user = this.getUser(User.create(string));
        if (user != null) {
            this.removeUser(user);
            user.ops = bl;
            this.addUser(user);
        }
    }

    public void changeName(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        User user = this.getUser(User.create(string));
        if (user != null) {
            this.removeUser(user);
            user.setName(string2);
            this.addUser(user);
        } else {
            System.err.println("Warning: Tried to remove '" + string + "' but user not found.");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        String[] stringArray;
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2 && (stringArray = this.getSelectedItems()).length > 0 && stringArray[0] != null && this.conn != null) {
            if (stringArray[0].startsWith("+") || stringArray[0].startsWith("@") || stringArray[0].startsWith("%") || stringArray[0].startsWith("~")) {
                stringArray[0] = stringArray[0].substring(1);
            }
            this.conn.startQuery(stringArray[0]);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private MenuItem makeMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.selectedComponent = mouseEvent.getComponent();
        int n = 0;
        int n2 = 0;
        this.commandMenu.show(this, n + mouseEvent.getX(), n2 + mouseEvent.getY());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String[] stringArray = this.getSelectedItems();
        for (int i = 0; i < stringArray.length; ++i) {
            if ((stringArray[i] == null || !stringArray[i].startsWith("+")) && !stringArray[i].startsWith("%") && !stringArray[i].startsWith("~") && !stringArray[i].startsWith("@")) continue;
            stringArray[i] = stringArray[i].substring(1);
        }
        if (string.equals("Private Message")) {
            if (stringArray.length > 0 && stringArray[0] != null) {
                this.conn.startQuery(stringArray[0]);
            }
        } else if (string.equals("Whois")) {
            if (stringArray.length > 0 && stringArray[0] != null) {
                this.conn.whois(stringArray[0]);
            }
        } else if (string.equals("Ping")) {
            if (stringArray.length > 0 && stringArray[0] != null) {
                this.conn.ping(stringArray[0]);
            }
        } else if (string.equals("Slap")) {
            if (stringArray.length > 0 && stringArray[0] != null) {
                String string2 = "slaps " + stringArray[0] + " around a bit with a pair of " + "steelcapped Doc Martens";
                this.conn.ctcp("ACTION", this.name, string2);
                this.conn.fireEvent(new Event(17, this.conn.getNick(), this.name, string2));
            } else {
                this.setBackground(Color.white);
            }
        }
    }
}

