<?php
include('magpierss/rss_fetch.inc');

define(MIN, 15);

function date_sort($a, $b)
{
  if($a['date'] == $b['date'])
    return 0;

  return ($a['date'] < $b['date']) ? 1 : -1;
}

$feeds = array('http://www.r4n0k.com/feed/', 'http://rss.slashdot.org/Slashdot/slashdot');
$rsses = array();
$items = array();

foreach($feeds as $feed)
{
  $rsses[count($rsses)] = fetch_rss($feed);
}

foreach($rsses as $rss)
{
  foreach($rss->items as $item)
    {
      $date = $item['pubDate'];
      if($date == '')
	$date = $item['dc']['date'];
      $items[count($items)] = array('title' => $item['title'], 'link' => $item['link'], 'date' => strtotime($date), 'desc' => $item['description']);
    }
}

usort($items, 'date_sort');

header('Content-type: application/rss+xml');

// Print it all out
print '<?xml version="1.0" encoding="utf-8" ?>  <rss version="2.0">'."\r\n";
print "<channel>\r\n\t<title>nok's feed combiner</title>\r\n\t<link>http://www.cyberarmy.net</link>\r\n\t";
print "<description>A whole bunch of fun feeds!</description>\r\n\t<language>en-us</language>\r\n";

$num = min(MIN, count($items));
for($i = 0; $i < $num; $i++) {
  print "\t<item>\r\n\t\t<title>{$items[$i]['title']}</title>\r\n\t\t";
  print "<link>{$items[$i]['link']}</link>\r\n\t\t";
  print "<description></description>\r\n\t\t";
  print "<pubDate>".date(DATE_RFC822, $items[$i]['date'])."</pubDate>\r\n";
  print "\t</item>\r\n";
 }

print '</channel></rss>';
?>