# MySQL Dump for voting db tables
#
# Host: StarwayCongress Database: cyberarmy
#--------------------------------------------------------
# Server version 3.23.36


#
# Table structure for table 'poll'
#

CREATE TABLE /*!32300 IF NOT EXISTS*/ poll (
  poll_id int(8) unsigned NOT NULL auto_increment,
  title text NOT NULL,
  expire_time int(8) unsigned,
  expire_tvotes smallint unsigned,
  expire_svotes smallint unsigned,
  creator varchar(20) NOT NULL,
  create_time int(8) unsigned,
  active enum('y','n') DEFAULT 'n',
  expired enum('y','') DEFAULT '',
  restricted varchar(6) DEFAULT '',
  PRIMARY KEY (poll_id),
  INDEX (create_time)
);

#
# Table structure for table 'poll_options'
#

CREATE TABLE /*!32300 IF NOT EXISTS*/ poll_options (
  poll_id int(8) unsigned NOT NULL auto_increment,
  choice_id int(8) unsigned NOT NULL,
  description varchar(75),
  pcount int(8) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (poll_id, choice_id),
  INDEX (choice_id)
);

#
# Table structure for table 'poll_votes'
#

CREATE TABLE /*!32300 IF NOT EXISTS*/ poll_votes (
  poll_id int(8) unsigned NOT NULL,
  users_id varchar(24) binary NOT NULL DEFAULT '' ,
  time int(10) unsigned NOT NULL,
  PRIMARY KEY (poll_id, users_id)
);



## Inserts for the first poll

INSERT INTO poll ( poll_id, title, expire_tvotes, creator, active, expired)
VALUES ( 1, "Sample poll: Will expire after 7 total votes.", 7, 'Pandect', 'y', '' );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 1, 1, "Sample question 1", 3 );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 1, 2, "Sample question 2", 1 );



## Inserts for the second poll

INSERT INTO poll ( poll_id, title, expire_svotes, creator, active, expired, restricted)
VALUES ( 2, "Sample poll 2: Will expire after 3 votes in any category, and it's restricted to c8", 3, 'Pandect', 'n', '', 'c8z1' );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 2, 1, "What, another poll?", 2 );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 2, 2, "Okay, it's not so bad", 0 );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 2, 3, "Well, it's pretty good...", 2 );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 2, 4, "Frickin-A!", 1 );



## Inserts for the third poll

INSERT INTO poll ( poll_id, title, creator, active, expired)
VALUES ( 3, "Sample poll: This poll has already expired.", 'Pandect', 'n', 'y' );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 3, 1, "Sample question 1", 132 );

INSERT INTO poll_options ( poll_id, choice_id, description, pcount )
VALUES ( 3, 2, "Sample question 2", 255 );





