#!/usr/bin/perl
package CyberArmy::Vote;

use strict;
use CyberArmy::Utils::Config;
use CyberArmy::Utils::Database;

#Set this to set the level at which a user can admin! e.g. z9c6
$CyberArmy::Vote::levelstoauth = "z1c6";

#Seconds to cache poll_SSI for...
$CyberArmy::Vote::ssicachetime = 60;
$CyberArmy::Vote::ssilastcache = time - 80;

#Seconds to cache poll HTML output for...
$CyberArmy::Vote::cachetime = 60;
$CyberArmy::Vote::lastcache = time - 80;
$CyberArmy::Vote::pollcache = '';

our $dbh = CyberArmy::Utils::Database->Connect;

our ($params, $posted, $user, $options, $poll_data);

sub export {
	(undef,$CyberArmy::Vote::cgi,$user) = @_;

	$params = $CyberArmy::Vote::cgi->Params(-escapehtml => 1);
	$posted = $CyberArmy::Vote::cgi->PostedParams(-escapehtml => 1);

	$CyberArmy::Vote::starchamber = '';

	# I'll bet you can't guess what this one does  =P
	&_filter_vars;

	if (!$params->{action}) { &_view_vote() }
	elsif ($params->{action} eq "admin") { &_parse_admin(); }
	elsif ($params->{action} eq "viewold") { &_view_old_vote() }
	elsif ($params->{action} eq "newvote") { &_new_vote() }
	elsif ($params->{action} eq "starchamber") { $CyberArmy::Vote::starchamber = " AND restricted LIKE '%c8%' "; &_view_vote() }
	elsif ($params->{action} eq "ltkcouncil") { $CyberArmy::Vote::starchamber = " AND restricted LIKE '%c6%' "; &_view_vote() }
	else { print "Welcome to Oblivion!"; }
}

sub ssi_export {

	# Implement caching...
	if ( ( time - $CyberArmy::Vote::ssilastcache ) > $CyberArmy::Vote::ssicachetime )
	{

		$poll_data =
		$dbh->selectrow_hashref( "SELECT poll_id, title, expire_time, expire_tvotes, expire_svotes, creator, create_time, restricted FROM poll WHERE active = 'y' AND expired = ''");

		#Get the description for the requested poll...
		my $sth2 = $dbh->prepare( "SELECT description, pcount FROM poll_options WHERE poll_id = '$poll_data->{poll_id}' ORDER BY choice_id" );
		$sth2->execute();
		$options = $sth2->fetchall_arrayref();
		$sth2->finish;

		$CyberArmy::Vote::ssilastcache = time;
	}


	if ( $poll_data->{poll_id} && &_check_auth($poll_data->{restricted}) ) {

		
		my $total = 0; my @results; my $y = 0;
	
		foreach (@$options) 
		{
	
			# Prepare the total
			$total += $options->[$y]->[1];
		
			#Also check for expired here, since we already have all the vars SELECTed
			if ($poll_data->{expire_svotes}) { &_expire_poll($poll_data->{poll_id}) if ($options->[$y]->[1] >= $poll_data->{expire_svotes}); } 
		
			$y++;
		}
	
		#Since we already have all of the data, check to make sure poll isn't expired...
		if ($poll_data->{expire_tvotes}) { &_expire_poll($poll_data->{poll_id}) if ($total >= $poll_data->{expire_tvotes}); }
		if ($poll_data->{expire_time}) { &_expire_poll($poll_data->{poll_id}) if ($poll_data->{expire_time} <= time); }
	
		print qq~
		<table cellpadding="1" cellspacing="0" border="0" width="450" align="Center" bgcolor="#000000" class='blackbg'>
		  <tbody>
		    <tr valign="Top">
		      <td valign="Top">
			<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
			  <tbody>
			    <tr valign="Top">
			      <td valign="Top" colspan="3">
				<form method=GET>
				<input type=hidden name=poll_id value="$poll_data->{poll_id}">
				<div align="Center"><b>Poll</b>: "$poll_data->{title}" - $poll_data->{creator}<br><br>
				</div>
			      </td>
			    </tr>
		~;
	
		#Start sorting the results and printing them out
		for(my $n=0; $n<$y; $n++) {
	
				my $percent = 0;
				unless (!$total | !$options->[$n]->[0]) { $percent = int( ($options->[$n]->[1] / $total) * 100); }
				my $therest = 100 - $percent;
				if ($options->[$n]->[0]) {
					print qq~
				    <tr valign="Top">
				      <td valign="Top" width="50%">
					<input type=radio name=uservote value=$n > &nbsp; @$options->[$n]->[0]<BR>
				      </td>
				      <td valign="Top" width="22%">$options->[$n]->[1] or $percent%
				      </td>
				      <td valign="Middle" width="30%" align="Left"><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" ><img src="$CyberArmy::Utils::Config::site{includes}/vote.jpg" alt="Results" width=$percent height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/vote2.jpg" alt="Un-Results" width=$therest height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" >
				      </td>
				    </tr>
					~;
				}
		}

	print qq~
		    <tr valign="Top">
		      <td valign="Top" colspan=3 >
			<input type=hidden name=action value=newvote>
			<input type=hidden name=area value=Vote >
			<div align="Center"><br><input type=submit value="Vote"></div></form>
		      </td>
		    </tr>
		  </tbody>
		</table>
	      </td>
	    </tr>
	  </tbody>
	</table>
	~;

	} else {
	
		print qq~
		<table cellpadding="1" cellspacing="0" border="0" width="60%" align="Center" bgcolor="#000000" class='blackbg'>
		  <tbody>
		    <tr valign="Top">
		      <td valign="Top">
			<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
			  <tbody>
			    <tr valign="Top">
			      <td valign="Top">
				<div align=center>No current poll.</div>
			      </td>
			    </tr>
			  </tbody>
			</table>
		      </td>
		    </tr>
		  </tbody>
		</table>
		~;
	}

}

sub _view_vote {

	# Implement caching...
	if ( ( time - $CyberArmy::Vote::lastcache ) > $CyberArmy::Vote::cachetime )
	{

		&_make_cache;
		$CyberArmy::Vote::lastcache = time;

	}

	print $CyberArmy::Vote::pollcache;

}

sub _make_cache {

	$CyberArmy::Vote::pollcache = '';

	# Prepare DB stuff...
#	my $sth = $dbh->prepare( "SELECT poll_id, title, expire_time, expire_tvotes, expire_svotes, active, creator, create_time, restricted FROM poll WHERE expired = '' $CyberArmy::Vote::starchamber ORDER BY active AND create_time" );
	my $sth = $dbh->prepare( "SELECT poll_id, title, expire_time, expire_tvotes, expire_svotes, active, creator, create_time, restricted FROM poll WHERE expired = '' $CyberArmy::Vote::starchamber ORDER BY active,create_time" );
	
	#Execute! (Bang bang) ;P
	$sth->execute();
	
	my $x = 0;


	#Start the display loop...
	while ( my $poll_data = $sth->fetchrow_hashref() ) {

		if ( &_check_auth($poll_data->{restricted}) ) {
	
			#Get the description for the requested poll...
			my $sth2 = $dbh->prepare( "SELECT description, pcount FROM poll_options WHERE poll_id = '$poll_data->{poll_id}' ORDER BY choice_id" );
			$sth2->execute();
			my ( $options ) = $sth2->fetchall_arrayref();
			$sth2->finish;
		
			my $total = 0; my @results; my $y = 0;
		
			foreach (@$options) 
			{
		
				# Prepare the total
				$total += $options->[$y]->[1];
			
				#Also check for expired here, since we already have all the vars SELECTed
				if ($poll_data->{expire_svotes}) { &_expire_poll($poll_data->{poll_id}) if ($options->[$y]->[1] >= $poll_data->{expire_svotes}); } 
			
				$y++;
			}

			#Since we already have all of the data, check to make sure poll isn't expired...
			if ($poll_data->{expire_tvotes}) { &_expire_poll($poll_data->{poll_id}) if ($total >= $poll_data->{expire_tvotes}); }
			if ($poll_data->{expire_time}) { &_expire_poll($poll_data->{poll_id}) if ($poll_data->{expire_time} <= time); }
		
			if ($poll_data->{active} eq 'y') { $CyberArmy::Vote::pollcache .= "<div align=center><h2>Main poll</h2></div>" }
			elsif ($poll_data->{restricted} =~ /c8/ ) { $CyberArmy::Vote::pollcache .= "\n<div align=center><h2>Starchamber poll</h2></div>" }
			elsif ($poll_data->{restricted} =~ /c6/ ) { $CyberArmy::Vote::pollcache .= "\n<div align=center><h2>Lt. Ker. Council Poll</h2></div>" }
		
			$CyberArmy::Vote::pollcache .= qq~ \n
			<table cellpadding="1" cellspacing="0" border="0" width="60%" align="Center" bgcolor="#000000" class='blackbg'>
			  <tbody>
			    <tr valign="Top">
			      <td valign="Top">
				<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
				  <tbody>
				    <tr valign="Top">
				      <td valign="Top" colspan="3">
					<form method=GET>
					<input type=hidden name=poll_id value="$poll_data->{poll_id}">
					<div align="Center"><b>Poll</b>: "$poll_data->{title}" - $poll_data->{creator}<br><br>
					</div>
				      </td>
				    </tr>
			~;

			#Start sorting the results and printing them out
			for(my $n=0; $n<$y; $n++) {
		
					my $percent = 0;
					unless (!$total | !$options->[$n]->[0]) { $percent = int( ($options->[$n]->[1] / $total) * 100); }
					my $therest = 100 - $percent;
					if ($options->[$n]->[0]) {
						$CyberArmy::Vote::pollcache .= qq~ \n
					    <tr valign="Top">
					      <td valign="Top" width="50%">
						<input type=radio name=uservote value=$n > &nbsp; @$options->[$n]->[0]<BR>
					      </td>
					      <td valign="Top" width="22%">$options->[$n]->[1] or $percent%
					      </td>
					      <td valign="Middle" width="30%" align="Left"><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" ><img src="$CyberArmy::Utils::Config::site{includes}/vote.jpg" alt="Results" width=$percent height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/vote2.jpg" alt="Un-Results" width=$therest height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" >
					      </td>
					    </tr>

						~;
					}
			}

			$CyberArmy::Vote::pollcache .= qq~ \n
				    <tr valign="Top">
				      <td valign="Top" colspan=3 >
					<input type=hidden name=action value=newvote>
					<input type=hidden name=area value=Vote >
					<div align="Center"><br><input type=submit value="Vote"></div></form>
				      </td>
				    </tr>
				  </tbody>
				</table>
			      </td>
			    </tr>
			  </tbody>
			</table>
			<BR><BR><BR><BR>
			~;

			$x++;
			
		} 

	}

	$sth->finish;

	$CyberArmy::Vote::pollcache .= qq~ \n
	<div align=center><hr align=center width=40% size=2>
	<BR>End of polls</div>
	<BR><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=viewold">Old polls?</a><BR>
	~;
	$CyberArmy::Vote::pollcache .= "\n<a href=\"$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin\">Admin?</a>" if (&_check_auth($CyberArmy::Vote::levelstoauth));

}

sub _view_old_vote {

	# Prepare DB stuff...
	my $sth = $dbh->prepare( "SELECT poll_id, title, expire_time, expire_tvotes, expire_svotes, active, creator, create_time, restricted FROM poll WHERE expired = 'y' ORDER BY create_time" );
	
	#Execute! (Bang bang) ;P
	$sth->execute();

	my $x = 0;

	#Start the display loop...
	while ( my ( $poll_id, $title, $expire_time, $expire_tvotes, $expire_svotes, $active, $creator, $create_time, $restricted ) = $sth->fetchrow_array() ) {

		if ( &_check_auth($restricted) ) {
	
			#Get the description for the requested poll...
			my $sth2 = $dbh->prepare( "SELECT description, pcount FROM poll_options WHERE poll_id = $poll_id ORDER BY choice_id" );
			$sth2->execute();
			my ( $options ) = $sth2->fetchall_arrayref();
			$sth2->finish;
		
			my $total = 0; my @results; my $y = 0;
		
			foreach (@$options) 
			{
		
				# Prepare the total
				$total += $options->[$y]->[1];
			
				$y++;
			}
			
			if ($restricted =~ /c8/ ) { print "<div align=center><h2>Starchamber poll</h2></div>" }
			elsif ($restricted =~ /c6/ ) { print "<div align=center><h2>Lt. Ker. Council Poll</h2></div>" }

			print qq~
			<table cellpadding="1" cellspacing="0" border="0" width="60%" align="Center" bgcolor="#000000" class='blackbg'>
			  <tbody>
			    <tr valign="Top">
			      <td valign="Top">
				<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
				  <tbody>
				    <tr valign="Top">
				      <td valign="Top" colspan="3">
					<div align="Center"><b>Poll</b>: "$title" - $creator<br><br>
					</div>
				      </td>
				    </tr>
			~;

			#Start sorting the results and printing them out
			for(my $n=0; $n<15; $n++) {
		
					my $percent = 0;
					unless (!$total | !$options->[$n]->[0]) { $percent = int( ($options->[$n]->[1] / $total) * 100); }
					my $therest = 100 - $percent;
					if ($options->[$n]->[0]) {
						print qq~
					    <tr valign="Top">
					      <td valign="Top" width="50%">
						@$options->[$n]->[0]<BR>
					      </td>
					      <td valign="Top" width="22%">$options->[$n]->[1] or $percent%
					      </td>
					      <td valign="Middle" width="30%" align="Left"><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" ><img src="$CyberArmy::Utils::Config::site{includes}/vote.jpg" alt="Results" width=$percent height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/vote2.jpg" alt="Un-Results" width=$therest height=10 border=0 ><img src="$CyberArmy::Utils::Config::site{includes}/cap.jpg" alt="Results cap" >
					      </td>
					    </tr>
						~;
					}
			}

			print qq~
				    <tr valign="Top">
				      <td valign="Top" colspan=3 >
					<div align="Center"><br></div></form>
				      </td>
				    </tr>
				  </tbody>
				</table>
			      </td>
			    </tr>
			  </tbody>
			</table>
			<BR><BR><BR><BR>
			~;

			$x++;
			
		} 

	}

	$sth->finish;

	print qq~
	<div align=center><hr align=center width=40% size=2>
	<BR>End of polls</div>
	<BR><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote">New polls?</a><BR>
	~;
	print "<a href=\"$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin\">Admin?</a>" if (&_check_auth($CyberArmy::Vote::levelstoauth));

}

sub _new_vote {

	my ( $exist_check, $notexpired_check, $validvote_check, $valid_access, $already_voted ) = (0,0,0,0,0);

	## Start with DB actions

	#Get stuff from the poll DB
	my $poll_data = $dbh->selectrow_arrayref("SELECT title, expired, restricted from poll WHERE poll_id = '$params->{poll_id}' ");
	$exist_check = 1 unless ( $poll_data->[0] );
	$notexpired_check = 1 if ( $poll_data->[1] );

	if ( &_check_auth($poll_data->[2]) ) {

		#Get the option descriptions for the requested poll...
		my $sth3 = $dbh->prepare( "SELECT description FROM poll_options WHERE poll_id = '$params->{poll_id}' ORDER BY choice_id" );
		$sth3->execute();
		my ( $options ) = $sth3->fetchall_arrayref();
		$sth3->finish;

		# Vote var
		my $vote = $params->{uservote} + 1;
	
		#Figure out when the questions stop!
		my ($stop);
		for (my $x=0; $x < 15; $x++) { if (!$options->[$x]->[0]) { $stop = $x; last; } elsif ($x == 14) { $stop = 15; } }
		$validvote_check = 1 if ($vote > $stop);
	
		if ( !$exist_check && !$notexpired_check && !$validvote_check ) {
	
			eval {
				$dbh->do("INSERT INTO poll_votes ( poll_id, users_id, time ) VALUES ( $params->{poll_id}, '$user->{fields}->{caID}', ? )", undef, time) || eval ( $already_voted = 1 );
				unless ( $already_voted ) {
				$dbh->do("UPDATE poll_options SET pcount = ( pcount + 1 ) WHERE poll_id = '$params->{poll_id}' AND choice_id = '$vote' "); }
			};
			if ($@) { print "Error recording vote: $@<BR><BR>This is most likely due to a DB failure. Please contact an admin."; 
			} elsif ( $already_voted ) {
				print "You have already voted!<BR>Your vote will only be counted once...";
			} else {
				print "Your vote was recorded...<BR>Thank you for voting.";
			}
		}
		elsif ( $exist_check != 0 ) {
			print "The poll you have voted on does not exist!";
		}
		elsif ( $notexpired_check != 0) {
			print "Sorry, the poll has already expired.";
		}
		elsif ( $validvote_check != 0) {
			print "Sorry, that vote is not an option on this poll!";
		}
		elsif ( $valid_access != 0) {
			print "I'm sorry, you don't have the required clearance to vote on this poll!";
		} else { print "Weird freak! Data:$exist_check;$notexpired_check;$validvote_check;$valid_access"; }

	} else { print "You do not have the required clearance to vote on this poll!"; }

}

sub _expire_poll {

	eval {
		$dbh->do("UPDATE poll SET expired = 'y', active = 'n' WHERE poll_id = $_[0]");
	};
	print "Error setting poll to expired: $@<BR>Please contact an admin." if $@;
	
	print "<div align=center>Expiring poll $_[0] because $_[1]</div>";

}

####################
## Admin section
####################

sub _parse_admin {

	if ( &_check_auth($CyberArmy::Vote::levelstoauth) ) {
		if (!$params->{admin}) { &_admin_menu() }
		elsif ($params->{admin} eq "new") { &_new_poll() }
		elsif ($params->{admin} eq "new15") { &_new15_poll() }
		elsif ($params->{admin} eq "new2") { &_create_poll() }
		elsif ($params->{admin} eq "edit") { &_edit_poll() }
		elsif ($params->{admin} eq "del") { &_del_poll() }
		elsif ($params->{admin} eq "active") { &_active_poll() }
		elsif ($params->{admin} eq "expire") { &_expired_poll() }
		else { print "Welcome to Oblivion!"; }
	} else { print "You do not have the required clearance to admin polls!"; }

}

sub _admin_menu {

	&_header;
	print qq~
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=new">Add a poll</a><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=edit">Edit a poll</a><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=del">Delete a poll</a><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=active">Set a poll to active/inactive</a><BR>
	<a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=expire">Set a poll to expired</a><BR></div>
	~;
	&_footer;

}

sub _new_poll {

	&_header;
	print qq~
	<form method=get>
	<h2>New poll</h2>
	<table>
	  <tr>
	    <td>
		Question: &nbsp; <br>
	    </td>
	    <td valign="Bottom">
		<input type=text name="question" size="35"><br>
	    </td>
	  </tr>
	~;

	for (my $t=1; $t<6; $t++) {
		print qq~
		  <tr>
		    <td >
			Answer $t:<br>
		    </td>
		    <td valign="Bottom">
			<input type=text name="answer$t" size="35"><br>
		    </td>
		  </tr>
		~;
	}

	print qq~
	  <tr>
	    <td colspan=2 >
		<div align=center><font size=2><i>(Leave a field blank to have it not included as an answer)<BR></i><a href="$CyberArmy::Utils::Config::site{officeurl}?area=Vote&action=admin&admin=new15">Click here to enter more questions than 5.</a></div></font>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="tvotes" size="5"> total votes.<br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="svotes" size="5"> votes in any category.<br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="time" size="5"> hours.<br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll restricted to: <input type=text name="restricted" size="5"><br><font size=2><i>( ex. z1c6; Rank entered *must* be matched, so to create a Starchamber poll you would put z1c8, etc... )</i></font><br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		&nbsp; &nbsp; <font size=2><i>(Leave a field blank to not have it set as a limit. If none of these fields are filled out, the poll will have to be manually expired.)</i></font>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		<br><input type=checkbox name="active" value="y">Make the current poll active?<br><div align=center><font size=2><i>In other words, this poll will be shown on an "SSI" call.</i></font></div>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		<br><div align=center><input type=hidden name=area value=Vote><input type=hidden name=action value=admin><input type=hidden name=admin value=new2><input type=submit value="Create Poll"></div></form>
	    </td>
	  </tr>
	</table>
	~;
	&_footer;

}


sub _new15_poll {

	&_header;
	print qq~
	<form method=get>
	<h2>New poll</h2>
	<table>
	  <tr>
	    <td>
		Question: &nbsp; <br>
	    </td>
	    <td valign="Bottom">
		<input type=text name="question" size="35"><br>
	    </td>
	  </tr>
	~;

	for (my $t=1; $t<16; $t++) {
		print qq~
		  <tr>
		    <td >
			Answer $t:<br>
		    </td>
		    <td valign="Bottom">
			<input type=text name="answer$t" size="35"><br>
		    </td>
		  </tr>
		~;
	}

	print qq~
	  <tr>
	    <td colspan=2 >
		<div align=center><font size=2><i>(Leave a field blank to have it not included as an answer)</i></div></font>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="tvotes" size="5"> total votes.<br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="svotes" size="5"> votes in any category.<br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2>
		<br>Poll expires after <input type=text name="time" size="5"> hours.<br>
	    </td>
	  </tr>
	    <td colspan=2>
		<br>Poll restricted to: <input type=text name="restricted" size="5"><br><font size=2><i>( ex. z1c6; Rank entered *must* be matched, so to create a Starchamber poll you would put z1c8, etc... )</i></font><br>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		&nbsp; &nbsp; <font size=2><i>(Leave a field blank to not have it set as a limit. If none of these fields are filled out, the poll will have to be manually expired.)</i></font>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		<br><input type=checkbox name="active" value="y">Make the current poll active?<br><div align=center><font size=2><i>In other words, this poll will be shown on an "SSI" call.</i></font></div>
	    </td>
	  </tr>
	  <tr>
	    <td colspan=2 >
		<br><div align=center><input type=hidden name=area value=Vote><input type=hidden name=action value=admin><input type=hidden name=admin value=new2><input type=submit value="Create Poll"></div></form>
	    </td>
	  </tr>
	</table>
	~;
	&_footer;

}

sub _edit_poll {

	if ($params->{poll_id}) {
	
		if ($params->{do}) {
		
			#Start check vars... Needs updating!
			if (!$params->{question} && !$params->{answer1} && !$params->{answer2}) {
				&_header;
				print "I'm sorry, you must at least have a question and two answer... Please go back and fill it out again...";
				&_footer;
			} # Needs much much more var checking!
			elsif ($params->{restricted} && $params->{active}) {
				&_header;
				print "I'm sorry, you cannot create an active poll that is restricted!";
				&_footer;
			}
			else {
			
				unless (!$params->{time}) { $params->{time} = ((($params->{time} * 60) * 60) + time); }
				
				eval {
			
					#Get the description for the requested poll...
					my $sth2 = $dbh->prepare( "SELECT description FROM poll_options WHERE poll_id = '$params->{poll_id}' ORDER BY choice_id" );
					$sth2->execute();
					my ( $options ) = $sth2->fetchall_arrayref();
					$sth2->finish;
					
					my $stop = 0;
					for (my $x=0; $x<16; $x++) { if (!$options->[$x]->[0]) { $stop = $x; last; } }
					
					my @options2 = ( $params->{answer1}, $params->{answer2}, $params->{answer3}, $params->{answer4}, $params->{answer5}, $params->{answer6}, $params->{answer7}, $params->{answer8}, $params->{answer9}, $params->{answer10}, $params->{answer11}, $params->{answer12}, $params->{answer13}, $params->{answer14}, $params->{answer15} );
					push @options2, '';
					my $p = 0; my ($optionz2, $stop2);
					foreach $optionz2 (@options2) { if (!$optionz2) { $stop2 = $p; last; } $p++; }
				
					$CyberArmy::Vote::voter_changes = 0;my $stopdif = 0;
				
					if ($stop eq $stop2) { $CyberArmy::Vote::voter_changes = 0; }
					elsif ($stop > $stop2) { $CyberArmy::Vote::voter_changes = 1; $stopdif = $stop - $stop2; }
					elsif ($stop < $stop2) { $CyberArmy::Vote::voter_changes = 1; }
				
					
					unless ($CyberArmy::Vote::voter_changes) {
						if ($params->{active} eq 'y') { $dbh->do("UPDATE poll SET active = 'n'") }
						$dbh->do("UPDATE poll SET title = ?, expire_time = ?, expire_tvotes = ?, expire_svotes = ?, active = ?, expired = '', restricted = ? WHERE poll_id = ?", undef, $params->{question}, $params->{time}, $params->{tvotes}, $params->{svotes}, $params->{active}, $params->{restricted}, $params->{poll_id} );
					
						my $arrete = 1;
						while ( $arrete ) {
							my $getval = "answer".$arrete;
							if ( $params->{$getval} )
							{
								$dbh->do(" UPDATE poll_options SET description = '$params->{$getval}' WHERE poll_id = '$params->{poll_id}' AND choice_id = '$arrete' ") || print "UPDATE for poll_options failed!";
								$arrete++;
							} else { $arrete = 0 }
						}
					
						#This is where it gets nice and complicated.
					} else  {
						print "I'm sorry, you cannot remove or add a column from your vote. Please recreate your poll if you wish to do this... Perhaps this will be supported in futur versions.";
					}
				};
				print "Error: $@" if $@;
	
				unless ($@ || $CyberArmy::Vote::voter_changes) {
					&_header;
					print "Poll Modified.";
					&_footer;
				}
			}
	
		} else {

			#Get info from DB
			
			
			my ( $poll_id, $title, $expire_time, $expire_tvotes, $expire_svotes, $creator, $create_time, $restricted, $active ) = 	
			$dbh->selectrow_array( "SELECT poll_id, title, expire_time, expire_tvotes, expire_svotes, creator, create_time, restricted, active FROM poll WHERE poll_id = $params->{poll_id} AND expired = ''");
		
			#Get the description for the requested poll...
			my $sth3 = $dbh->prepare( "SELECT description FROM poll_options WHERE poll_id = '$params->{poll_id}' ORDER BY choice_id" );
			$sth3->execute();
			my ( $options ) = $sth3->fetchall_arrayref();
			$sth3->finish;
		
			if ($active) { $active = "Checked=yes"; }
			else { $active = ""; }
			
			&_header;
			print qq~
			<form method=get>
			<h2>Edit poll</h2>
			<table>
			  <tr>
			    <td>
				Question: &nbsp; <br>
			    </td>
			    <td valign="Bottom">
				<input type=text name="question" size="35" value="$title"><br>
			    </td>
			  </tr>
			~;
			for (my $s=1; $s<16; $s++) {
				if ( $options->[$s-1]->[0] )
				{
					print qq~
					  <tr>
					    <td >
							Answer $s:<br>
					    </td>
					    <td valign="Bottom">
							<input type=text name="answer$s" size="35" value="$options->[$s-1]->[0]"><br>
					    </td>
					  </tr>
					~;
				} else {
					print qq~
					  <tr>
					    <td >
							Answer $s:<br>
					    </td>
					    <td valign="Bottom">
							<input type=text name="answer$s" size="35" value=""><br>
					    </td>
					  </tr>
					~;

				}	

			}

			print qq~
			  <tr>
			    <td colspan=2 >
					<div align=center><font size=2><i>(Leave a field blank to have it not included as an answer)</i></div></font>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2>
					<br>Poll expires after <input type=text name="tvotes" size="5" value="
			~;
			print $expire_tvotes if ( $expire_tvotes );
			print qq~
			"> total votes.<br>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2>
				<br>Poll expires after <input type=text name="svotes" size="5" value="
			~;
			print $expire_svotes if ( $expire_svotes );
			print qq~
			"> votes in any category.<br>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2>
				<br>Poll expires after <input type=text name="time" size="5" value="
			~;
			print $expire_time if ( $expire_time );
			print qq~
			"> hours.<br>
			    </td>
			  </tr>
			  <tr>
			<td colspan=2>
				<br>Poll restricted to? <input type=text name="restricted" value="
			~;
			print $restricted if ( $restricted );
			print qq~
			" size="5"><br><font size=2><i>( ex. z1c6; Rank entered *must* be matched, so to create a Starchamber poll you would put z1c8, etc... )</i></font><br>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2 >
				&nbsp; &nbsp; <font size=2><i>(Leave a field blank to not have it set as a limit. If none of these fields are filled out, the poll will have to be manually expired.)</i></font>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2 >
				<br><input type=checkbox $active name="active" value="y">Make the current poll active?<br><div align=center><font size=2><i>In other words, this poll will be shown on an "SSI" call.</i></font></div>
			    </td>
			  </tr>
			  <tr>
			    <td colspan=2 >
				<br><font size=2>Note: If your poll is already underway, you can still edit it. However, the results might be a little weird. For example, if you add a column that didn't exist, it will be displayed as if no-one voted for it. Similarly, if you remove a column, all of those votes will be removed.</font><br><br><div align=center><input type=hidden name=area value=Vote><input type=hidden name=action value=admin><input type=hidden name=poll_id value=$params->{poll_id}><input type=hidden name=do value=1><input type=hidden name=admin value=edit><input type=submit value="Edit" onClick=\"javascript:var n=confirm('Are you sure you want to modify this poll to these new values?'); return n;\"></div></form>
			    </td>
			  </tr>
			</table>
			~;
			&_footer;
	
	
		}
	} else {
	
	
		&_header;
	
		print qq~
		<form method=get>
		<br>Edit &nbsp; <select name="poll_id">
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT poll_id, title FROM poll WHERE expired = ''" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $poll_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$poll_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> <br> &nbsp; <input type=submit name="set" value="Edit">
		<input type=hidden name=area value=Vote>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value=edit></form>
		~;
	
		&_footer;
	
	}

}


sub _create_poll {

	if (!$params->{question} && !$params->{answer1} && !$params->{answer2}) {
		&_header;
		print "I'm sorry, you must at least have a question and two answers... Please go back and fill it out again...";
		&_footer;
	} # Needs much much more var checking!
	elsif ($params->{restricted} && $params->{active}) {
		&_header;
		print "I'm sorry, you cannot create an active poll that is restricted!";
		&_footer;
	}
	else {
	
		unless (!$params->{time}) { $params->{time} = ((($params->{time} * 60) * 60) + time); }
		if (!$params->{active}) { $params->{active} = 'n'; }
		
		eval {

			if ($params->{active} eq 'y') { $dbh->do("UPDATE poll SET active = 'n'") }
			$dbh->do("INSERT INTO poll ( title, expire_time, expire_tvotes, expire_svotes, active, expired, creator, create_time, restricted ) VALUES ( ?, ?, ?, ?, ?, '', ?, ?, ? )", undef, $params->{question}, $params->{time}, $params->{tvotes}, $params->{svotes}, $params->{active}, $user->{fields}->{showname}, time, $params->{restricted}  );
			my $arrete = 1;
			my $poll_id = $dbh->selectrow_array(" SELECT poll_id FROM poll WHERE title = '$params->{question}'");
			while ( $arrete ) {
				my $getval = "answer".$arrete;
				if ( $params->{$getval} )
				{
					$dbh->do(" INSERT INTO poll_options ( poll_id, choice_id, description, pcount ) VALUES ( $poll_id, $arrete, '$params->{$getval}', 0 )") || print "INSERT for poll_options failed!";
					$arrete++;
				} else { $arrete = 0 }
			}
		};
		print "Error: $@" if $@;
		
		unless ($@) {
			&_header;
			print "Poll created.";
			&_footer;
		}
	}

}

sub _del_poll {

	if ($params->{poll_id}) {
	
		eval {
			$dbh->do("DELETE FROM poll_votes WHERE poll_id = $params->{poll_id}");
			$dbh->do("DELETE FROM poll_options WHERE poll_id = $params->{poll_id}");
			$dbh->do("DELETE FROM poll WHERE poll_id = $params->{poll_id}");
		};
		print "Error deleting poll: $@. Database should be investigated manually. Please inform an admin!" if $@;
		
		unless ($@) {
			&_header;
			print "Poll deleted!";
			&_footer;
		}

	}
	else {
	
		&_header;
	
		print qq~
		<form method=get>
		<br>Delete poll: &nbsp; <select name=poll_id>
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT poll_id, title FROM poll" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $poll_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$poll_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> &nbsp; <input type=submit name="Delete" onClick=\"javascript:var n=confirm('Are you sure you want to delete this poll?'); return n;\">
		<input type=hidden name=area value=Vote>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value=del></form>
		~;
	
		&_footer;
	}

}

sub _active_poll {

	if ($params->{set}) { 
		if ($params->{set} eq "Active") {
		
			eval {
				$dbh->do("UPDATE poll SET active = 'n'");
				$dbh->do("UPDATE poll SET active = 'y' WHERE poll_id = $params->{poll_id}");
			};
			print "Error modifying poll: $@. Please inform an admin!" if $@;
			
			unless ($@) {
				&_header;
				print "Poll set to active!";
				&_footer;
			}
	
		}
		elsif ($params->{set} eq "Inactive") {
		
			eval {
				$dbh->do("UPDATE poll SET active = 'n' WHERE poll_id = $params->{poll_id}");
			};
			print "Error modifying poll: $@. Please inform an admin!" if $@;
			
			unless ($@) {
				&_header;
				print "Poll set to inactive!";
				&_footer;
			}
		}
	}
	else {
	
		&_header;
	
		print qq~
		<form method=get>
		<br>Set &nbsp; <select name=poll_id>
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT poll_id, title FROM poll WHERE expired = ''" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $poll_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$poll_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> <br> &nbsp; <input type=submit name="set" value="Active" onClick=\"javascript:var n=confirm('Are you sure you want to set this poll to active? This will set all other polls to inactive.'); return n;\"> <input type=submit name="set" value="Inactive" onClick=\"javascript:var n=confirm('Are you sure you want to set this poll to inactive? There will be no current active poll!'); return n;\">
		<input type=hidden name=area value=Vote>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value="active"></form>
		~;
	
		&_footer;
	}

}

sub _expired_poll {

	if ($params->{poll_id}) {
	
		eval {
			$dbh->do("UPDATE poll SET expired = 'y' WHERE poll_id = $params->{poll_id}");
		};
		print "Error Setting poll to expired: $@. Please inform an admin!" if $@;
		
		unless ($@) {
			&_header;
			print "Poll manually expired!";
			&_footer;
		}
	
	
	}
	else {
	
		&_header;
	
		print qq~
		<form method=get>
		<br>Set &nbsp; <select name=poll_id>
		~;
	
		# Prepare DB stuff...
		my $sth = $dbh->prepare( "SELECT poll_id, title FROM poll WHERE expired = ''" );
		
		#Execute! (Bang bang) ;P
		$sth->execute();
	
		#Start the display loop...
		while ( my ( $poll_id, $title ) = $sth->fetchrow_array() ) {
			print "<option value=\"$poll_id\">".DBI::neat($title,50)."</option>";
		}
		
		print qq~
		</select> <br> &nbsp; <input type=submit value="Expired" onClick=\"javascript:var n=confirm('Are you sure you want to set this poll to expired? This poll will no longer be able to be voted on. This action cannot be undone!'); return n;\">
		<input type=hidden name=area value=Vote>
		<input type=hidden name=action value=admin>
		<input type=hidden name=admin value="expire"></form>
		~;
	
		&_footer;
	}

}

sub _check_auth {

	my ( $restricted ) = @_;

	my $valid_access = 0;

	if ( $restricted ) 
	{ 
		my $firstrank = substr($restricted,0,2);
		my $secondrank = substr($restricted,2,4);

		if ( $user->IsInGroup($firstrank) && $user->IsInGroup($secondrank) ) 
		{ $valid_access = 1; }


	} else {
		$valid_access = 1;
	}

	return $valid_access;

}

sub _filter_vars {

	#Filter all of the vars!
	while ( my ($key, $value) = each %$params) {
	
		# Make a NULL value suitable for the db...
		$params->{$key} = undef if !$params->{$key};
		
		# Take out all non alphanum or nice symbols... Thanks booto!
		$value =~ s/[^_0-9a-zA-Z\s\!\,\.\@\#\$\&\*\(\)\-\+\=\?\;]//eg;
	
		# Num vars take out alpha as well...
		if ( $key eq 'tvotes' | $key eq 'svotes' | $key eq 'time' | $key eq 'uservote' )
		{
			$value =~ s/[^0-9]//eg;
		}
	
		# Assign the new value to the key!
		$params->{$key} = $value;
	}

}

sub _header {

	print qq~
	
	<BR>
	<table cellpadding="1" cellspacing="0" border="0" width="60%" align="Center" bgcolor="#000000" class='blackbg'>
	  <tbody>
	    <tr valign="Top">
	      <td valign="Top">
		<table cellpadding="7" cellspacing="0" border="0" width="100%" bgcolor="#263c6d">
		  <tbody>
		    <tr valign="Top">
		      <td valign="Top">
			<div align=center>
	~;
}

sub _footer {

	print qq~
		      </td>
		    </tr>
		  </tbody>
		</table>
	      </td>
	    </tr>
	  </tbody>
	</table>
	~;

}

1337357;



