#!/usr/bin/perl
package CyberArmy::Apache::Office;

use strict;
use CyberArmy::CGI;
use CyberArmy::Vote;
use CyberArmy::Utils::Config;
use CyberArmy::Apache::Office::cIMS;
use CyberArmy::Apache::Office::Profile;
use Benchmark;

our ($cgi,$user,$params);

sub handler {
	my $r = shift;

	$cgi = CyberArmy::CGI->new; $user = CyberArmy::Users->Session; $params = $cgi->Params(-escapehtml => 1);

	$r->content_type('text/html'); $r->header_out('Pragma' => 'no-cache'); $r->send_http_header;
	
	my $showarea = $params->{area} || 'home'; my $group = $user->cGroup; my $rankname = $user->RankName; my $cbadge = $user->cRankBadge;
	my $zbadge = $user->zRankBadge($user->zGroup); if ($zbadge)  { $zbadge = qq{<img border="0" src="$zbadge">} } else {$zbadge = ''};

	my $ltime = gmtime($user->{fields}->{session_time});
	my $location = "CyberArmy -> Office -> $user->{fields}->{showname} -> $showarea";
	
	print $cgi->Header(-title => $location, -complete => 1).$cgi->PageHeader(-complete => 1).qq~
<p>&nbsp;</p>
<div align="center">
 <table border="0" width="750" cellspacing="0" cellpadding="0">
    <tr>
      <td width="18"><img border="0" src="$CyberArmy::Utils::Config::site{includes}/office/blackblob.gif" width="18" height="18"></td>
      <td width="500" align="center" valign="bottom" bgcolor="#000000"><b>$location</b></td>
      <td width="214" align="center" rowspan="2"><img border="0" src="$cbadge">$zbadge</td>
      <td width="18" rowspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td width="18">&nbsp;</td>
      <td width="500" valign="middle">$rankname $user->{fields}->{showname}<br>Logged In Since $ltime GMT <br>From $user->{fields}->{session_ip}<br><br></td>
    </tr> 
    <tr>
    <td width="18"><img border="0" src="$CyberArmy::Utils::Config::site{includes}/office/blackblob.gif" width="18" height="18"></td>
    <td width="500" align="right" bgcolor="#000000"> <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}"> Home</a> - <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=profile"> Profile</a> - <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=cIMS">cIMS</a>      - <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=privileges">Privileges</a>      - <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=Vote">Voting</a>      - <a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=News">News</a></td>
    <td width="214" align="center" bgcolor="#000000">[<a href="http://$CyberArmy::Utils::Config::site{server}$CyberArmy::Utils::Config::site{officeurl}?area=logout">Log Out</a>]</td>
    <td width="18"><img border="0" src="$CyberArmy::Utils::Config::site{includes}/office/pipejoin.gif" width="18" height="18"></td>
    </tr>
    <tr>
      <td width="18"></td>
      <td width="500"></td>
      <td width="214" align="right" ><img border="0" src="$CyberArmy::Utils::Config::site{includes}/office/pipejoin3.gif" width="18" height="18"></td>
      <td width="18" bgcolor="#000000" align="left"></td>
    </tr>
    <tr>
      <td width="18"></td>
      <td width="500"></td>
      <td width="214"></td>
      <td width="18"><img border="0" src="$CyberArmy::Utils::Config::site{includes}/office/blackblob_down.gif" width="18" height="18"></td>
    </tr>
    <tr>
      <td width="18"></td>
      <td width="714" colspan="2">
      <!-- Start Area Input -->
      ~;

	if ($showarea eq 'home') { home() }
	elsif ($showarea eq 'logout') { print logout() }
	elsif ($showarea eq 'cIMS') { CyberArmy::Apache::Office::cIMS->export($cgi); print "<BR><BR><BR>"; CyberArmy::Vote->ssi_export; }
	elsif ($showarea eq 'profile') { CyberArmy::Apache::Office::Profile->profile($cgi) }
	elsif ($showarea eq 'Vote') { CyberArmy::Vote->export($cgi,$user) }
	elsif ($showarea eq 'VoteSSI') { CyberArmy::Vote->ssi_export; }
	elsif ($showarea eq 'News') { CyberArmy::News->export; }
	elsif ($showarea eq 'privileges') { }
	else { print 'the BackYard' }
      
      print qq~
      <!-- End Area Input -->
      </td>
      <td width="18"></td>
    </tr>
  </table>
</div>
</body>
</html>
	~;
}

sub home {

	print qq~
	 <table border="0" width="750" cellspacing="0" cellpadding="0">
	    <tr>
	      <td valign=top width="550">
		Home!
		<BR><BR><br><br><br><BR><BR><br><br><br>
	~;
	CyberArmy::Vote->ssi_export;
	
	print qq~
	      </td>
	      <td valign=top width="200">
	~;
	CyberArmy::News->export;
	print qq~
	      </td>
	    </tr>
	  </table>
	~;
}

sub logout {
	CyberArmy::Users->Session->Update( -session_id => undef );
	return q~<p>&nbsp;</p><p>&nbsp;</p><p align="center"> You have been successfully logged out </p>~;
}

1;





