#!perl -wW
package CyberArmy::WWW::Windstone;

use strict;
use CyberArmy::Windstone::Utils;

$CyberArmy::WWW::Windstone::CronIntervalHours = 2;
$CyberArmy::WWW::Windstone::CronInterval = 7200;
$CyberArmy::WWW::Windstone::CronLast = 0;

sub handler {
	my $r = shift;

	my $user = CyberArmy::WWW::Request::User->instance;
	if (!$user) { return 403 }

	my (undef,$node) = split(/\//,$r->path_info);
	if (not $node) { return 500; }

	elsif ($node eq 'auth' || $node eq 'Auth') { &showAuth }
	return -1;
}

sub showAuth {
    my $r = CyberArmy::WWW::Request->instance();
	my $user = CyberArmy::WWW::Request::User->instance;

	# Rudimentary crontab to delete old entries
	if ($CyberArmy::WWW::Windstone::CronLast < time() - $CyberArmy::WWW::Windstone::CronInterval) {
		CyberArmy::Windstone::Utils::expire_old_tokens($CyberArmy::WWW::Windstone::CronIntervalHours);
		$CyberArmy::WWW::Windstone::CronLast = time();
	}

    #actions from url (GET)
    my $actionParams = $r->getParams({ escapehtml => 1 });

	my $siteid = $actionParams->{'siteid'};
	my $request_token = $actionParams->{'rtok'};
	if ($siteid =~ /\D/ || $request_token =~ /\W/) { return 500 } # Thank you, come again.

	my $site_query = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT url FROM windstone_sites WHERE id = ?");
	$site_query->execute($siteid);

	my(@site_row) = $site_query->fetchrow_array();
	my $forward_url = $site_row[0];


	my($auth_token) = CyberArmy::Windstone::Utils::insert_auth_token($siteid, $request_token, $user->caid);
	#die("GOTS: $auth_token, $siteid, $request_token, " . ($user->caid) . "\n");

	if ($site_row[0]) { $r->redirectTo($site_row[0]."?auth=$auth_token"); return 1; }

	return 500;
}

1;
